/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.teiid.designer.ui.refactor.move.MoveResourcesDescriptor;

public class MoveResourcesContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_NUMBER_OF_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENT = "element";
    private static final String ATTRIBUTE_DESTINATION = "destination";

    private IPath handleToResourcePath(String project, String handle) {
        IPath path = Path.fromPortableString((String)handle);
        if (project != null && project.length() > 0 && !path.isAbsolute()) {
            return new Path(project).append(path).makeAbsolute();
        }
        return path;
    }

    private String resourcePathToHandle(String project, IPath resourcePath) {
        if (project != null && project.length() > 0 && resourcePath.segmentCount() != 1 && resourcePath.segment(0).equals(project)) {
            return resourcePath.removeFirstSegments(1).toPortableString();
        }
        return resourcePath.toPortableString();
    }

    public RefactoringDescriptor createDescriptor() {
        return new MoveResourcesDescriptor();
    }

    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map arguments, int flags) throws IllegalArgumentException {
        try {
            int numResources = Integer.parseInt((String)arguments.get(ATTRIBUTE_NUMBER_OF_RESOURCES));
            if (numResources < 0 || numResources > 100000) {
                throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, number of moved elements invalid");
            }
            ArrayList<IPath> resourcePaths = new ArrayList<IPath>(numResources);
            int i = 0;
            while (i < numResources) {
                String resource = (String)arguments.get(ATTRIBUTE_ELEMENT + String.valueOf(i + 1));
                if (resource == null) {
                    throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, resource missing");
                }
                resourcePaths.add(this.handleToResourcePath(project, resource));
                ++i;
            }
            String destination = (String)arguments.get(ATTRIBUTE_DESTINATION);
            if (destination == null) {
                throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, destination missing");
            }
            IPath destPath = this.handleToResourcePath(project, destination);
            MoveResourcesDescriptor descriptor = new MoveResourcesDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setDestinationPath(destPath);
            descriptor.setResourcePathsToMove(resourcePaths);
            return descriptor;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map");
        }
    }

    public Map retrieveArgumentMap(RefactoringDescriptor descriptor) {
        if (!(descriptor instanceof MoveResourcesDescriptor)) {
            return null;
        }
        MoveResourcesDescriptor moveDescriptor = (MoveResourcesDescriptor)descriptor;
        HashMap<String, String> map = new HashMap<String, String>();
        Collection<IPath> paths = moveDescriptor.getResourcePaths();
        String project = moveDescriptor.getProject();
        IPath destinationPath = moveDescriptor.getDestinationPath();
        int i = 0;
        map.put(ATTRIBUTE_NUMBER_OF_RESOURCES, String.valueOf(paths.size()));
        for (IPath path : paths) {
            map.put(ATTRIBUTE_ELEMENT + (i + 1), this.resourcePathToHandle(project, path));
            ++i;
        }
        map.put(ATTRIBUTE_DESTINATION, this.resourcePathToHandle(project, destinationPath));
        return map;
    }
}

