/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;

public abstract class AbstractRefactorAction
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private IWorkbenchWindow window;
    private List<IResource> selectedResources;

    public void init(IViewPart view) {
        this.window = view.getSite().getWorkbenchWindow();
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    protected List<IResource> getSelectedResources() {
        return this.selectedResources;
    }

    protected abstract RefactoringWizard getRefactoringWizard(List<IResource> var1, IWorkbenchWindow var2);

    private void run(RefactoringWizard wizard, Shell parent) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, wizard.getWindowTitle());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IAction action) {
        if (this.selectedResources == null || this.selectedResources.isEmpty() || this.window == null) {
            return;
        }
        this.run(this.getRefactoringWizard(this.selectedResources, this.window), this.window.getShell());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        if (!SelectionUtilities.isAllIResourceObjects((ISelection)selection)) {
            action.setEnabled(false);
            return;
        }
        List resources = SelectionUtilities.getSelectedIResourceObjects((ISelection)selection);
        action.setEnabled(true);
        this.selectedResources = resources;
    }

    public void dispose() {
    }
}

