/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.extension;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.ui.actions.CopyFilesAndFoldersOperation;
import org.teiid.designer.ui.properties.extension.ChooseVdbFileFromWorkspaceDialog;
import org.teiid.designer.ui.properties.extension.ChooseVdbFileOptionsDialog;
import org.teiid.designer.ui.properties.extension.Messages;
import org.teiid.designer.ui.wizards.FolderUtil;

public class VdbFileDialogUtil
implements StringConstants {
    private static String chooseOptionsSelectFile(Shell shell, IProject project, VdbHelper.VdbFolders vdbFolder) {
        boolean[] choices = VdbFileDialogUtil.showOptionsDialog(shell, vdbFolder, false);
        boolean selectFromWorkspace = false;
        boolean copyToWorkspace = false;
        if (choices == null) {
            return "";
        }
        selectFromWorkspace = choices[0];
        copyToWorkspace = choices[1];
        String selectedFile = selectFromWorkspace ? VdbFileDialogUtil.chooseFileFromWorkspace(shell, project, vdbFolder) : VdbFileDialogUtil.chooseFileFromFileSystem(shell, project, vdbFolder, copyToWorkspace);
        return selectedFile;
    }

    public static String selectFile(Shell shell, IProject project, VdbHelper.VdbFolders vdbFolder) {
        String selectedFile = null;
        IContainer folder = VdbHelper.getFolder((IProject)project, (String)vdbFolder.getReadFolder());
        if (folder == null) {
            if (VdbHelper.VdbFolders.UDF.equals((Object)vdbFolder)) {
                selectedFile = VdbFileDialogUtil.chooseFileFromFileSystem(shell, project, vdbFolder, true);
            } else {
                boolean[] choices = VdbFileDialogUtil.showOptionsDialog(shell, vdbFolder, true);
                boolean copyToWorkspace = false;
                if (choices == null) {
                    return "";
                }
                copyToWorkspace = choices[1];
                selectedFile = VdbFileDialogUtil.chooseFileFromFileSystem(shell, project, vdbFolder, copyToWorkspace);
            }
        } else if (VdbHelper.folderContainsOneOrMoreFile((IContainer)folder, (String)vdbFolder.getExtension())) {
            selectedFile = VdbFileDialogUtil.chooseOptionsSelectFile(shell, project, vdbFolder);
        } else {
            boolean copyToWorkspace = true;
            if (!VdbHelper.VdbFolders.UDF.equals((Object)vdbFolder)) {
                boolean[] choices = VdbFileDialogUtil.showOptionsDialog(shell, vdbFolder, true);
                if (choices != null) {
                    copyToWorkspace = choices[1];
                } else {
                    return "";
                }
            }
            selectedFile = VdbFileDialogUtil.chooseFileFromFileSystem(shell, project, vdbFolder, copyToWorkspace);
        }
        return selectedFile;
    }

    private static boolean[] showOptionsDialog(Shell shell, VdbHelper.VdbFolders vdbFolder, boolean disableWorkspaceOption) {
        ChooseVdbFileOptionsDialog optionsDialog;
        int returnCode;
        boolean selectFromWorkspace = false;
        boolean copyToWorkspace = false;
        String title = "";
        StringBuffer message = new StringBuffer();
        if (VdbHelper.VdbFolders.UDF.equals((Object)vdbFolder)) {
            title = Messages.workspaceOrFileSystemDialogUdfTitle;
            message.append(Messages.workspaceOrFileSystemDialogUdfMessage);
        } else {
            title = Messages.workspaceOrFileSystemDialogFileTitle;
            message.append(Messages.workspaceOrFileSystemDialogFileMessage);
        }
        if (disableWorkspaceOption) {
            message.append("\n" + Messages.workspaceOptionIsDisabledMessage);
        }
        if ((returnCode = (optionsDialog = new ChooseVdbFileOptionsDialog(shell, title, message.toString(), vdbFolder, disableWorkspaceOption)).open()) == 0) {
            selectFromWorkspace = optionsDialog.selectFromWorkspaceSelected();
            copyToWorkspace = optionsDialog.copyToWorkspaceSelected();
            return new boolean[]{selectFromWorkspace, copyToWorkspace};
        }
        return null;
    }

    private static String chooseFileFromFileSystem(Shell shell, IProject project, VdbHelper.VdbFolders vdbFolder, boolean copyToWorkspace) {
        String fileResult = null;
        FileDialog dlg = new FileDialog(shell);
        VdbHelper.FileFilter fileFilter = vdbFolder == null ? VdbHelper.ALL_FILE_FILTER : vdbFolder.getFileFilter();
        dlg.setFilterExtensions(new String[]{fileFilter.getFilter()});
        dlg.setFilterNames(new String[]{fileFilter.getName()});
        String fileFullName = dlg.open();
        if (fileFullName == null) {
            return "";
        }
        File theFile = new File(fileFullName);
        String fileShortName = theFile.getName();
        if (fileShortName != null && VdbHelper.VdbFolders.UDF.equals((Object)vdbFolder) && !fileShortName.endsWith("jar")) {
            MessageDialog.openError((Shell)shell, (String)Messages.selectedFileNotAJarDialogTitle, (String)Messages.selectedFileNotAJarDialogMessage);
            return "";
        }
        String folderName = vdbFolder.getWriteFolder();
        IContainer folder = VdbHelper.getFolder((IProject)project, (String)folderName);
        if (folder == null && copyToWorkspace) {
            FolderUtil.createFolder(shell, project, folderName);
            folder = VdbHelper.getFolder((IProject)project, (String)folderName);
        }
        if (folder != null && copyToWorkspace) {
            String[] files = new String[]{fileFullName};
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
            operation.copyFiles(files, folder);
        }
        fileResult = !VdbHelper.VdbFolders.UDF.equals((Object)vdbFolder) && !copyToWorkspace ? fileFullName : VdbHelper.getFileRelativePath((IContainer)folder, (String)fileShortName);
        return fileResult;
    }

    private static String chooseFileFromWorkspace(Shell shell, IProject project, VdbHelper.VdbFolders vdbFolder) {
        IResource choice;
        String fileName = null;
        String title = null;
        String message = null;
        if (VdbHelper.VdbFolders.UDF.equals((Object)vdbFolder)) {
            title = Messages.chooseFileFromWorkspaceDialogUdfTitle;
            message = Messages.chooseFileFromWorkspaceDialogUdfMessage;
        } else {
            title = Messages.chooseFileFromWorkspaceDialogFileTitle;
            message = Messages.chooseFileFromWorkspaceDialogFileMessage;
        }
        ChooseVdbFileFromWorkspaceDialog dlg = new ChooseVdbFileFromWorkspaceDialog(shell, title, message, project, vdbFolder);
        IResource iResource = choice = dlg.open() == 0 ? (IResource)dlg.getFirstResult() : null;
        if (choice != null) {
            fileName = choice.getProjectRelativePath().toString();
        }
        return fileName;
    }
}

