/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class ReadOnlyPropertyDescriptor
implements IPropertyDescriptor {
    public static final String READ_ONLY_TITLE = UiConstants.Util.getString("ReadOnlyPropertyDescriptor.readOnlyModelTitle", new Object[0]);
    public static final String READ_ONLY_MESSAGE = UiConstants.Util.getString("ReadOnlyPropertyDescriptor.readOnlyModelMessage", new Object[0]);
    public static final int READ_ONLY_PROPERTY = 0;
    public static final int READ_ONLY_RESOURCE = 1;
    public static final int NO_MODEL_EDITOR = 2;
    private IPropertyDescriptor delegate;
    private int status = 0;
    private IFile modelFile;

    public ReadOnlyPropertyDescriptor(IPropertyDescriptor delegate, int type) {
        this.delegate = delegate;
        this.status = type;
    }

    public ReadOnlyPropertyDescriptor(IPropertyDescriptor delegate, int type, IFile modelToOpen) {
        this.delegate = delegate;
        this.status = type;
        this.modelFile = modelToOpen;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (this.status == 1) {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)READ_ONLY_TITLE, (String)READ_ONLY_MESSAGE);
        } else if (this.status == 2 && this.modelFile != null) {
            if (!ModelEditorManager.isOpen(this.modelFile)) {
                String autoOpen = UiPlugin.getDefault().getPreferenceStore().getString("autoOpenEditorIfNeeded");
                boolean forceOpen = "always".equals(autoOpen);
                if (!forceOpen) {
                    Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                    forceOpen = ModelEditorManager.showDialogShouldOpenEditor(shell);
                }
                if (forceOpen) {
                    ModelEditorManager.activate(this.modelFile, true);
                }
                return null;
            }
            return this.delegate.createPropertyEditor(parent);
        }
        return null;
    }

    public String getCategory() {
        return this.delegate.getCategory();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String[] getFilterFlags() {
        return this.delegate.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this.delegate.getHelpContextIds();
    }

    public Object getId() {
        return this.delegate.getId();
    }

    public ILabelProvider getLabelProvider() {
        return this.delegate.getLabelProvider();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return this.delegate.isCompatibleWith(anotherProperty);
    }
}

