/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ITransientPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

class ObjectUriPropertyDescriptor
implements ITransientPropertyDescriptor,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ObjectUriPropertyDescriptor.class);
    private EObject obj;
    private ILabelProvider labelProvider;

    ObjectUriPropertyDescriptor() {
    }

    public CellEditor createPropertyEditor(Composite theParent) {
        return null;
    }

    public String getCategory() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "category");
    }

    public String getDescription() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "description");
    }

    public String getDisplayName() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "displayName");
    }

    public String[] getFilterFlags() {
        return null;
    }

    @Override
    public Object getPropertyValue() {
        String result = null;
        if (this.obj == null) {
            throw new IllegalStateException(Util.getStringOrKey(String.valueOf(PREFIX) + "errorMsg.objectNotSet"));
        }
        ModelResource model = ModelUtilities.getModelResourceForModelObject(this.obj);
        if (model != null) {
            try {
                String namespaceUri = model.getModelAnnotation().getNamespaceUri();
                if (!CoreStringUtil.isEmpty((String)namespaceUri)) {
                    result = new StringBuffer().append(namespaceUri).append("#").append(ModelerCore.getObjectIdString((EObject)this.obj)).toString();
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                throw new IllegalStateException(Util.getString(String.valueOf(PREFIX) + "errorMsg.modelAnnotationProblem", (Object)this.obj));
            }
        }
        return result;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "id");
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor theAnotherProperty) {
        return false;
    }

    @Override
    public void setObject(Object theObject) {
        if (theObject == null || !this.supports(theObject)) {
            throw new IllegalArgumentException(Util.getString(String.valueOf(PREFIX) + "errorMsg.objectNotSupported", (Object)this.obj));
        }
        this.obj = (EObject)theObject;
    }

    @Override
    public boolean supports(Object theObject) {
        return theObject instanceof EObject;
    }
}

