/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.xsd.XSDSchema;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ITransientPropertyDescriptor;

class NamespacePropertyDescriptor
implements ITransientPropertyDescriptor,
UiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(NamespacePropertyDescriptor.class);
    private EObject obj;
    private ILabelProvider labelProvider;
    List namespaces;

    NamespacePropertyDescriptor() {
    }

    public CellEditor createPropertyEditor(Composite theParent) {
        DialogCellEditor editor = new DialogCellEditor(theParent){

            protected Object openDialogBox(Control cellEditorWindow) {
                ListDialog dialog = new ListDialog(cellEditorWindow.getShell());
                dialog.setInput((Object)NamespacePropertyDescriptor.this.namespaces);
                dialog.setContentProvider((IStructuredContentProvider)new ListSCP());
                dialog.setLabelProvider(NamespacePropertyDescriptor.this.getLabelProvider());
                dialog.setTitle(Util.getStringOrKey(String.valueOf(PREFIX) + "displayName"));
                dialog.open();
                return null;
            }
        };
        return editor;
    }

    public String getCategory() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "category");
    }

    public String getDescription() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "description");
    }

    public String getDisplayName() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "displayName");
    }

    public String[] getFilterFlags() {
        return null;
    }

    @Override
    public Object getPropertyValue() {
        if (this.obj == null) {
            throw new IllegalStateException(Util.getStringOrKey(String.valueOf(PREFIX) + "errorMsg.objectNotSet"));
        }
        XSDSchema xsdObj = (XSDSchema)this.obj;
        Map qNameRoNamespaces = xsdObj.getQNamePrefixToNamespaceMap();
        if (qNameRoNamespaces != null && !qNameRoNamespaces.isEmpty()) {
            this.namespaces = new ArrayList();
            for (Map.Entry entry : qNameRoNamespaces.entrySet()) {
                if (entry.getKey() != null) {
                    this.namespaces.add("xmlns:" + entry.getKey() + "=" + entry.getValue());
                    continue;
                }
                this.namespaces.add("xmlns[default]=" + entry.getValue());
            }
        }
        if (this.namespaces != null && this.namespaces.size() > 0) {
            return this.namespaces.get(0);
        }
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "id");
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor theAnotherProperty) {
        return false;
    }

    @Override
    public void setObject(Object theObject) {
        if (theObject == null || !this.supports(theObject)) {
            throw new IllegalArgumentException(Util.getString(String.valueOf(PREFIX) + "errorMsg.objectNotSupported", (Object)this.obj));
        }
        this.obj = (XSDSchema)theObject;
    }

    @Override
    public boolean supports(Object theObject) {
        return theObject instanceof XSDSchema;
    }

    class ListSCP
    implements IStructuredContentProvider {
        ListSCP() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

