/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class AutoOpenPerspectivePreferenceContributor
implements IGeneralPreferencePageContributor,
UiConstants {
    private static final String PREF_ID = "autoOpenPerspectiveWhenModelEditorOpened";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AutoOpenPerspectivePreferenceContributor.class);
    private Button btnAlways;
    private Button btnNever;
    private Button btnPrompt;

    @Override
    public void createPreferenceEditor(Composite parent) {
        Group pnlButtons = WidgetFactory.createGroup((Composite)parent, (String)Util.getStringOrKey(String.valueOf(PREFIX) + "lbl.text"), (int)768, (int)1, (int)3);
        pnlButtons.setFont(JFaceResources.getDialogFont());
        this.btnAlways = WidgetFactory.createRadioButton((Composite)pnlButtons, (String)Util.getStringOrKey(String.valueOf(PREFIX) + "btnAlways.text"));
        this.btnAlways.setToolTipText(Util.getStringOrKey(String.valueOf(PREFIX) + "btnAlways.toolTip"));
        this.btnNever = WidgetFactory.createRadioButton((Composite)pnlButtons, (String)Util.getStringOrKey(String.valueOf(PREFIX) + "btnNever.text"));
        this.btnNever.setToolTipText(Util.getStringOrKey(String.valueOf(PREFIX) + "btnNever.toolTip"));
        this.btnPrompt = WidgetFactory.createRadioButton((Composite)pnlButtons, (String)Util.getStringOrKey(String.valueOf(PREFIX) + "btnPrompt.text"));
        this.btnPrompt.setToolTipText(Util.getStringOrKey(String.valueOf(PREFIX) + "btnPrompt.toolTip"));
        this.refresh();
    }

    @Override
    public String getName() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    private String getPreferenceStoreValue(boolean defaultFlag) {
        IPreferenceStore prefStore = this.getPreferenceStore();
        String value = null;
        value = defaultFlag ? prefStore.getDefaultString(PREF_ID) : prefStore.getString(PREF_ID);
        if (StringUtilities.isEmpty((String)value)) {
            value = "prompt";
        }
        return value;
    }

    @Override
    public String getToolTip() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performDefaults() {
        this.update(this.getPreferenceStoreValue(true));
        return true;
    }

    @Override
    public boolean performOk() {
        String value = "prompt";
        if (this.btnAlways.getSelection()) {
            value = "always";
        } else if (this.btnNever.getSelection()) {
            value = "never";
        }
        this.getPreferenceStore().setValue(PREF_ID, value);
        return true;
    }

    @Override
    public void refresh() {
        this.update(this.getPreferenceStoreValue(false));
    }

    @Override
    public void setWorkbench(IWorkbench theWorkbench) {
    }

    private void update(String value) {
        if ("always".equals(value)) {
            if (!this.btnAlways.getSelection()) {
                this.btnAlways.setSelection(true);
                this.btnNever.setSelection(false);
                this.btnPrompt.setSelection(false);
            }
        } else if ("never".equals(value)) {
            if (!this.btnNever.getSelection()) {
                this.btnAlways.setSelection(false);
                this.btnNever.setSelection(true);
                this.btnPrompt.setSelection(false);
            }
        } else if (!this.btnPrompt.getSelection()) {
            this.btnAlways.setSelection(false);
            this.btnNever.setSelection(false);
            this.btnPrompt.setSelection(true);
        }
    }
}

