/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.outline;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelOutlineTreeViewerDropAdapter
extends EditingDomainViewerDropAdapter {
    public ModelOutlineTreeViewerDropAdapter(EditingDomain domain, Viewer viewer) {
        super(domain, viewer);
    }

    public void drop(DropTargetEvent event) {
        boolean started = ModelerCore.startTxn((String)UiConstants.Util.getString("ModelOutlineTreeViewer.dndUndoLabel", new Object[0]), (Object)((Object)this));
        boolean succeeded = false;
        try {
            if (this.dragAndDropCommandInformation != null) {
                this.command = this.dragAndDropCommandInformation.createCommand();
            } else {
                this.source = this.extractDragSource(event.data);
                Object target = this.extractDropTarget(event.item);
                this.command = DragAndDropCommand.create((EditingDomain)this.domain, (Object)target, (float)this.getLocation(event), (int)event.operations, (int)this.originalOperation, (Collection)this.source);
            }
            if (this.command.canExecute()) {
                try {
                    ModelerCore.getModelEditor().executeCommand(null, this.command);
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                    succeeded = false;
                }
            } else {
                event.detail = 0;
                this.command.dispose();
            }
            this.command = null;
            this.commandTarget = null;
            this.source = null;
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void dragEnter(DropTargetEvent event) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)((Object)this));
        boolean succeeded = false;
        try {
            super.dragEnter(event);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void dragLeave(DropTargetEvent event) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)((Object)this));
        boolean succeeded = false;
        try {
            super.dragLeave(event);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)((Object)this));
        boolean succeeded = false;
        try {
            super.dragOperationChanged(event);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void dragOver(DropTargetEvent event) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)((Object)this));
        boolean succeeded = false;
        try {
            super.dragOver(event);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)((Object)this));
        boolean succeeded = false;
        try {
            super.dropAccept(event);
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    protected void helper(DropTargetEvent theEvent) {
        super.helper(theEvent);
        if (this.source != null && !this.source.isEmpty() && theEvent.item != null) {
            Object parent = theEvent.item.getData();
            if ((theEvent.feedback & 2) == 2 && parent instanceof EObject) {
                EObject temp = ((EObject)parent).eContainer();
                if (temp == null) {
                    temp = ModelUtilities.getModelResourceForModelObject((EObject)parent);
                }
                parent = temp;
            }
            for (Object child : this.source) {
                if (parent == null || !(child instanceof EObject) || ModelerCore.getModelEditor().isValidParent(parent, (EObject)child)) continue;
                theEvent.detail = 0;
                break;
            }
        }
    }
}

