/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.outline;

import java.util.EventObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.actions.TreeViewerRenameAction;
import org.teiid.designer.ui.common.actions.ExtendedMenuManager;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.outline.ModelOutlineContentProvider;
import org.teiid.designer.ui.outline.ModelOutlineNotificationHandler;
import org.teiid.designer.ui.outline.ModelOutlinePage;
import org.teiid.designer.ui.outline.ModelOutlineTreeViewerDropAdapter;
import org.teiid.designer.ui.views.ModelViewer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;

public class ModelOutlineTreeViewer
extends ContentOutlinePage
implements ModelEditorPageOutline,
IMenuListener,
IModelerActionConstants,
ModelViewer {
    ModelEditor modelEditor;
    private ISelectionListener selectionListener;
    private ModelerGlobalActionsMap actionsMap;
    private INotifyChangedListener notificationHandler;
    private ImageDescriptor icon = UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/outlineView.gif");
    private String toolTipText = "ModelOutlineTreeViewer.tooltip";
    private IWorkbenchPart workbenchPart;
    private ILabelProvider labelProvider;
    private TreeViewerRenameAction renameAction;
    private EventObjectListener modelResourceListener;

    public ModelOutlineTreeViewer(ModelEditor editor) {
        this.modelEditor = editor;
    }

    public void init(IPageSite thePageSite) {
        super.init(thePageSite);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        IEditorInput input = this.modelEditor.getEditorInput();
        ModelOutlineContentProvider contentProvider = new ModelOutlineContentProvider(input);
        this.getTreeViewer().setContentProvider((IContentProvider)contentProvider);
        ILabelDecorator decorator = UiUtil.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.labelProvider = new DecoratingLabelProvider((ILabelProvider)new ModelExplorerLabelProvider(), decorator);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput((Object)input);
        this.getTreeViewer().expandToLevel(2);
        this.getTreeViewer().reveal(contentProvider.getElements(input)[0]);
        IStatusLineManager slManager = this.getSite().getActionBars().getStatusLineManager();
        this.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getModelObjectSelectionListener());
        this.getSite().setSelectionProvider(this.getModelObjectSelectionProvider());
        this.notificationHandler = new ModelOutlineNotificationHandler(this);
        ModelUtilities.addNotifyChangedListener(this.notificationHandler);
        this.renameAction = new TreeViewerRenameAction();
        this.renameAction.setTreeViewer(this.getTreeViewer(), this.labelProvider);
        ModelerActionService svc = (ModelerActionService)UiPlugin.getDefault().getActionService(this.getSite().getPage());
        svc.addWorkbenchSelectionListener((ISelectionListener)this.renameAction);
        this.actionsMap = new ModelerGlobalActionsMap();
        this.actionsMap.put(IActionConstants.EclipseGlobalActions.RENAME, this.renameAction);
        IActionBars bars = this.getSite().getActionBars();
        svc.registerDefaultGlobalActions(bars);
        bars.setGlobalActionHandler(IActionConstants.EclipseGlobalActions.RENAME, (IAction)this.renameAction);
        bars.updateActionBars();
        String contextMenuId = String.valueOf(ModelOutlinePage.class.getName()) + ".contextMenu";
        ExtendedMenuManager mgr = new ExtendedMenuManager(null, contextMenuId);
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener((IMenuListener)this);
        Control control = this.getControl();
        Menu contextMenu = mgr.createContextMenu(control);
        control.setMenu(contextMenu);
        this.getSite().registerContextMenu(contextMenuId, (MenuManager)mgr, this.getModelObjectSelectionProvider());
        this.initDragAndDrop();
        this.modelResourceListener = new EventObjectListener(){

            public void processEvent(EventObject obj) {
                ModelResource modelResource = ((ModelResourceEvent)obj).getModelResource();
                if (ModelOutlineTreeViewer.this.modelEditor.getModelResource().equals(modelResource)) {
                    ModelOutlineTreeViewer.this.refresh();
                }
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelOutlineTreeViewer.this.handleRefresh();
            }
        });
    }

    void handleRefresh() {
        if (this.getTreeViewer() != null && !this.getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().refresh();
        }
    }

    protected void initDragAndDrop() {
        try {
            EditingDomain domain = ((ContainerImpl)ModelerCore.getModelContainer()).getEditingDomain();
            int dndOperations = 7;
            Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
            this.getTreeViewer().addDragSupport(dndOperations, transfers, (DragSourceListener)new OutlineDragAdapter((Viewer)this.getTreeViewer()));
            this.getTreeViewer().addDropSupport(dndOperations, transfers, (DropTargetListener)new ModelOutlineTreeViewerDropAdapter(domain, (Viewer)this.getTreeViewer()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    TreeViewer getTree() {
        return this.getTreeViewer();
    }

    IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    @Override
    public void addModelObjectDoubleClickListener(IDoubleClickListener listener) {
        this.getTreeViewer().addDoubleClickListener(listener);
    }

    public ISelectionListener getModelObjectSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!(part instanceof ContentOutline) && ModelOutlineTreeViewer.this.isSynchronized() && selection instanceof IStructuredSelection && !selection.isEmpty() && !ModelOutlineTreeViewer.this.getSelection().equals(selection)) {
                        ModelOutlineTreeViewer.this.setSelection(selection);
                    }
                }
            };
        }
        return this.selectionListener;
    }

    ModelResource getModelResource() {
        return this.modelEditor.getModelResource();
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.getTreeViewer();
    }

    public boolean isSynchronized() {
        return true;
    }

    public void menuAboutToShow(IMenuManager theMenuMgr) {
        IWorkbenchWindow window = this.modelEditor.getSite().getWorkbenchWindow();
        ModelerActionService actionService = (ModelerActionService)UiPlugin.getDefault().getActionService(this.getSite().getPage());
        ISelection selection = this.getTreeViewer().getSelection();
        actionService.contributeToContextMenu(theMenuMgr, this.actionsMap, selection);
        if (this.workbenchPart == null) {
            this.workbenchPart = window.getActivePage().getActivePart();
        }
    }

    @Override
    public void removeModelObjectDoubleClickListener(IDoubleClickListener listener) {
        this.getTreeViewer().removeDoubleClickListener(listener);
    }

    @Override
    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getModelObjectSelectionListener());
        ModelUtilities.removeNotifyChangedListener(this.notificationHandler);
        if (this.modelResourceListener != null) {
            try {
                UiPlugin.getDefault().getEventBroker().removeListener(this.modelResourceListener);
            }
            catch (EventSourceException eventSourceException) {}
        }
        super.dispose();
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.icon;
    }

    @Override
    public String getToolTipText() {
        return UiPlugin.getDefault().getPluginUtil().getString(this.toolTipText, new Object[0]);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setVisible(boolean isVisible) {
    }

    private class OutlineDragAdapter
    extends ViewerDragAdapter {
        public OutlineDragAdapter(Viewer theViewer) {
            super(theViewer);
        }

        public void dragStart(DragSourceEvent theEvent) {
            if (ModelUtilities.isReadOnly(ModelOutlineTreeViewer.this.getModelResource())) {
                theEvent.doit = false;
            }
            super.dragStart(theEvent);
        }
    }
}

