/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerFilterer {
    public static final int DEFAULT_FILTER_DELAY_TIME = 400;
    private ViewerFilter myVFilter;
    private IFilter myIFilter;
    private Map currentViewers = new HashMap();
    Timer lastTimer;
    private int delayMillis = 400;

    public abstract Control addControl(Composite var1, FormToolkit var2);

    protected abstract ViewerFilter createViewerFilter();

    protected abstract IFilter createVirtualFilter();

    private void init(boolean virtual) {
        if (virtual) {
            if (this.myIFilter == null) {
                this.myIFilter = this.createVirtualFilter();
            }
        } else if (this.myVFilter == null) {
            this.myVFilter = this.createViewerFilter();
        }
    }

    public Control addControl(Composite parent) {
        return this.addControl(parent, null);
    }

    public void attachToViewer(StructuredViewer viewer, boolean autoSelectFirstMatch) {
        this.init(false);
        viewer.addFilter(this.myVFilter);
        this.currentViewers.put(viewer, new ViewerInfo(viewer, null, autoSelectFirstMatch));
    }

    public void attachToVirtualViewer(StructuredViewer viewer, DeferredContentProvider dcp, boolean autoSelectFirstMatch) {
        this.init(true);
        this.currentViewers.put(viewer, new ViewerInfo(viewer, dcp, autoSelectFirstMatch));
    }

    public void removeFromViewer(StructuredViewer viewer) {
        this.init(false);
        viewer.removeFilter(this.myVFilter);
        this.currentViewers.remove(viewer);
    }

    public void updateFilter() {
        for (final ViewerInfo vi : this.currentViewers.values()) {
            if (vi.viewer.getControl().isDisposed()) continue;
            if (vi.dcp == null) {
                vi.viewer.refresh();
                StructuredViewerFilterer.autoSelectIfNeeded(vi);
                continue;
            }
            vi.dcp.setFilter(this.myIFilter);
            Thread selector = new Thread("filter selector"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(300L);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                StructuredViewerFilterer.autoSelectIfNeeded(vi);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            selector.setDaemon(true);
            selector.setPriority(3);
            selector.start();
        }
    }

    static void autoSelectIfNeeded(ViewerInfo vi) {
        if (vi.autoSelect && vi.viewer.getSelection().isEmpty()) {
            Tree t;
            Control c = vi.viewer.getControl();
            Object toSelect = null;
            if (c instanceof Table) {
                Table t2 = (Table)c;
                if (t2.getItemCount() > 0) {
                    toSelect = t2.getItem(0).getData();
                }
            } else if (c instanceof List) {
                List l = (List)c;
                if (l.getItemCount() > 0) {
                    toSelect = l.getItem(0);
                }
            } else if (c instanceof Tree && (t = (Tree)c).getItemCount() > 0) {
                toSelect = t.getTopItem().getData();
            }
            if (toSelect != null) {
                vi.viewer.setSelection((ISelection)new StructuredSelection(toSelect));
            }
        }
    }

    public void setDelayTime(int millis) {
        this.delayMillis = millis;
    }

    public void scheduleUpdate() {
        if (this.lastTimer != null) {
            this.lastTimer.cancel();
            this.lastTimer = null;
        }
        if (this.delayMillis > 0) {
            this.lastTimer = new Timer(true);
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StructuredViewerFilterer.this.updateFilter();
                        }
                    });
                    if (StructuredViewerFilterer.this.lastTimer != null) {
                        StructuredViewerFilterer.this.lastTimer.cancel();
                    }
                    StructuredViewerFilterer.this.lastTimer = null;
                }
            };
            this.lastTimer.schedule(tt, this.delayMillis);
        } else {
            this.updateFilter();
        }
    }

    private static class ViewerInfo {
        StructuredViewer viewer;
        DeferredContentProvider dcp;
        boolean autoSelect;

        public ViewerInfo(StructuredViewer viewer, DeferredContentProvider dcp, boolean select) {
            this.viewer = viewer;
            this.dcp = dcp;
            this.autoSelect = select;
        }
    }
}

