/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.IgnorableNotificationSource;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.actions.TreeViewerRenameAction;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.editors.IInlineRenameable;
import org.teiid.designer.ui.explorer.ModelExplorerResourceNavigator;
import org.teiid.designer.ui.util.ModelObjectNotificationHelper;
import org.teiid.designer.ui.util.ModelObjectTreeViewerNotificationHandler;
import org.teiid.designer.ui.wizards.INewModelObjectWizard;

public class ModelExplorerNotificationHandler
extends ModelObjectTreeViewerNotificationHandler
implements UiConstants {
    private static final EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    ModelExplorerResourceNavigator viewer;
    private IWorkbenchWindow window;
    TreeViewerRenameAction renameAction;

    public ModelExplorerNotificationHandler(TreeViewer tv, ModelExplorerResourceNavigator viewer) {
        super(tv);
        this.viewer = viewer;
        this.window = viewer.getSite().getWorkbenchWindow();
        this.renameAction = new TreeViewerRenameAction();
        this.renameAction.setTreeViewer(tv, (ILabelProvider)tv.getLabelProvider());
    }

    @Override
    public boolean shouldHandleNotification(Notification notification) {
        return true;
    }

    @Override
    protected ModelObjectNotificationHelper handleNotification(Notification notification) {
        Set children;
        Object source;
        ModelObjectNotificationHelper notificationHelper = super.handleNotification(notification);
        if (notification instanceof SourcedNotification && (source = ((SourcedNotification)notification).getSource()) != null && source instanceof IgnorableNotificationSource) {
            return notificationHelper;
        }
        if (NotificationUtilities.isAdded((Notification)notification) && this.getTreeViewer() != null && !this.getTreeViewer().getTree().isDisposed() && (children = notificationHelper.getAddedChildren()) != null) {
            boolean isModelObjectAction;
            Iterator itor = children.iterator();
            while (itor.hasNext()) {
                EObject child = (EObject)itor.next();
                if (ModelerCore.getModelEditor().getMetamodelDescriptor(child).isPrimary()) continue;
                itor.remove();
            }
            if (children.isEmpty()) {
                return notificationHelper;
            }
            Object source2 = ((SourcedNotification)notification).getSource();
            boolean bl = isModelObjectAction = source2 instanceof ModelObjectAction || source2 instanceof ModelObjectWorker || source2 instanceof INewModelObjectWizard;
            if (this.window.getActivePage() != null && isModelObjectAction) {
                IWorkbenchPart activePart = this.window.getActivePage().getActivePart();
                boolean isThisActivePage = activePart == this.viewer;
                IInlineRenameable renameablePart = null;
                if (this.window.getActivePage().getActivePart() instanceof IInlineRenameable) {
                    renameablePart = (IInlineRenameable)activePart;
                }
                if (!isThisActivePage) {
                    this.viewer.setFocus();
                }
                EObject child = (EObject)children.iterator().next();
                this.getTreeViewer().expandToLevel((Object)child, 0);
                StructuredSelection selection = new StructuredSelection((Object[])children.toArray(EMPTY_EOBJECT_ARRAY));
                this.getTreeViewer().setSelection((ISelection)selection);
                if (children.size() == 1 && notification instanceof SourcedNotification && ModelerCore.getModelEditor().hasName(child)) {
                    this.renameAction.selectionChanged((IWorkbenchPart)this.viewer, (ISelection)selection);
                    if (renameablePart == null) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ModelExplorerNotificationHandler.this.viewer.getViewer().getControl().isFocusControl()) {
                                    ModelExplorerNotificationHandler.this.renameAction.doRun(false);
                                }
                            }
                        });
                    } else {
                        renameablePart.renameInline(child, renameablePart.getInlineRenameable(child));
                    }
                }
            }
        }
        return notificationHelper;
    }
}

