/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.FindModelObjectHandler;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.ui.wizards.NewModelWizard;
import org.teiid.designer.ui.wizards.NewModelWizardInput;

public class ModelExplorerNewAction
extends Action
implements IMenuCreator {
    static final String RELATIONAL = "Relational";
    static final String XML = "XML";
    static final String XML_SCHEMA = "XML Schema (XSD)";
    static final String WEB_SERVICE = "Web Service";
    static final String FUNCTION = "Function";
    private List<IAction> actions;

    public ModelExplorerNewAction() {
        super("", 4);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-model-project.png"));
        this.actions = this.createActions();
        this.setMenuCreator(this);
        this.setToolTipText("New...");
    }

    public void run() {
        ModelerUiViewUtils.launchWizard("newModelProject", (IStructuredSelection)new StructuredSelection(), new Properties(), false);
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    protected List<IAction> createActions() {
        ArrayList<IAction> list = new ArrayList<IAction>();
        list.add((IAction)new Action("New Model Project", UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-model-project.png")){

            public void run() {
                ModelerUiViewUtils.launchWizard("newModelProject", (IStructuredSelection)new StructuredSelection(), new Properties(), false);
            }
        });
        list.add((IAction)new Action("New Source Model", UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-source-model.png")){

            public void run() {
                ModelExplorerNewAction.this.launchNewModelWizard(ModelType.PHYSICAL_LITERAL, ModelExplorerNewAction.RELATIONAL, new Properties());
            }
        });
        list.add((IAction)new Action("New View Model", UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-view-model.png")){

            public void run() {
                ModelExplorerNewAction.this.launchNewModelWizard(ModelType.VIRTUAL_LITERAL, ModelExplorerNewAction.RELATIONAL, new Properties());
            }
        });
        list.add((IAction)new Action("New Web Service Model", UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-web-service-model.png")){

            public void run() {
                ModelExplorerNewAction.this.launchNewModelWizard(ModelType.VIRTUAL_LITERAL, ModelExplorerNewAction.WEB_SERVICE, new Properties());
            }
        });
        list.add((IAction)new Action("New XML Document Model", UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-xml-document-model.png")){

            public void run() {
                ModelExplorerNewAction.this.launchNewModelWizard(ModelType.VIRTUAL_LITERAL, ModelExplorerNewAction.XML, new Properties());
            }
        });
        list.add((IAction)new Action("New VDB", UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/newvdb_wiz.gif")){

            public void run() {
                ModelerUiViewUtils.launchWizard("newVdbWizard", (IStructuredSelection)new StructuredSelection(), new Properties(), false);
            }
        });
        return list;
    }

    private void addFindModelObjectAction(Menu menu) {
        new Separator().fill(menu, -1);
        Action action = new Action("Find model object...", UiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/opentype.gif")){

            public void run() {
                FindModelObjectHandler.findObject();
            }
        };
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    private void addGoToExamplesAction(Menu menu) {
        new Separator().fill(menu, -1);
        Action goToExamplesAction = new Action("Go to examples..."){

            public void run() {
                ModelerUiViewUtils.openTeiidDesignerExamplesPage();
            }
        };
        ActionContributionItem item = new ActionContributionItem((IAction)goToExamplesAction);
        item.fill(menu, -1);
    }

    public void dispose() {
    }

    private Menu fillMenu(Menu menu) {
        for (IAction action : this.actions) {
            this.addActionToMenu(menu, action);
        }
        this.addFindModelObjectAction(menu);
        this.addGoToExamplesAction(menu);
        this.setEnabled(!this.actions.isEmpty());
        return menu;
    }

    public Menu getMenu(Control parent) {
        return this.fillMenu(new Menu(parent));
    }

    public Menu getMenu(Menu parent) {
        return this.fillMenu(new Menu(parent));
    }

    void launchNewModelWizard(ModelType type, String modelClass, Properties props) {
        block7: {
            IWorkbenchWindow iww = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            boolean successful = false;
            try {
                NewModelWizard wizard = new NewModelWizard(new NewModelWizardInput(modelClass, type, null), props);
                String viewId = ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId();
                ISelection theSelection = iww.getSelectionService().getSelection(viewId);
                wizard.init(iww.getWorkbench(), (IStructuredSelection)theSelection);
                WizardDialog dialog = new WizardDialog(iww.getShell(), (IWizard)wizard);
                wizard.updateForProperties();
                String openProjectStatus = DesignerPropertiesUtil.getProjectStatus(props);
                if (openProjectStatus == null || !"noOpenProject".equalsIgnoreCase(openProjectStatus)) {
                    int result = dialog.open();
                    if (result == 0) {
                        successful = true;
                    }
                    break block7;
                }
                return;
            }
            catch (Exception e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                MessageDialog.openError((Shell)iww.getShell(), (String)"New Model Error", (String)e.getMessage());
            }
            finally {
                this.notifyResult(successful);
            }
        }
    }
}

