/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.common.actions.WorkerProblem;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PasteWorker
extends ModelObjectWorker {
    private static final String PROBLEM = "PasteAction.problem";
    private boolean pastingDiagram = false;

    public PasteWorker(boolean enableAfterExecute) {
        super(enableAfterExecute);
    }

    @Override
    public boolean execute() {
        boolean successful;
        block20: {
            successful = false;
            Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)((ISelection)this.getSelection()));
            if (this.pastingDiagram) {
                EObject eObj;
                List cbContents = this.getClipboardContents(selectedObject);
                if (cbContents != null && cbContents.size() == 1 && (eObj = (EObject)cbContents.get(0)) instanceof Diagram) {
                    DiagramHelperManager.paste((Diagram)eObj, (EObject)selectedObject);
                    successful = true;
                }
            } else {
                String pasteInName = null;
                if (selectedObject instanceof EObject) {
                    pasteInName = ModelerCore.getModelEditor().getName((EObject)selectedObject);
                } else if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)selectedObject)) {
                    try {
                        ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                        if (modelResource == null) {
                            throw new ModelWorkspaceException(UiConstants.Util.getString("PasteWorker.msg.nullModelResource", new Object[0]));
                        }
                        selectedObject = modelResource;
                        pasteInName = ModelerCore.getModelEditor().getModelName(modelResource);
                    }
                    catch (ModelWorkspaceException theException) {
                        UiConstants.Util.log((Throwable)theException);
                    }
                } else {
                    CoreArgCheck.isTrue((boolean)false, (String)(PasteWorker.class + ".doRun: unexpected paste target <" + selectedObject + ">."));
                }
                if (pasteInName != null) {
                    boolean started = ModelerCore.startTxn((boolean)true, (String)UiConstants.Util.getString("PasteWorker.undoLabel", (Object)pasteInName), (Object)this);
                    boolean succeeded = false;
                    try {
                        try {
                            ModelerCore.getModelEditor().pasteFromClipboard(selectedObject);
                            succeeded = true;
                        }
                        catch (Exception err) {
                            String title = UiConstants.Util.getString("PasteWorker.errorTitle", new Object[0]);
                            String message = UiConstants.Util.getString("PasteWorker.errorMessage", new Object[0]);
                            this.setWorkerProblem(new WorkerProblem(title, message));
                            String msg = UiConstants.Util.getString(PROBLEM, new Object[]{selectedObject});
                            UiConstants.Util.log(4, (Throwable)err, msg);
                            if (!started) break block20;
                            if (succeeded) {
                                successful = true;
                                ModelerCore.commitTxn();
                                break block20;
                            }
                            ModelerCore.rollbackTxn();
                        }
                    }
                    finally {
                        if (started) {
                            if (succeeded) {
                                successful = true;
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        }
        return successful;
    }

    @Override
    public boolean setEnabledState() {
        boolean enable = false;
        this.pastingDiagram = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && SelectionUtilities.isSingleSelection((ISelection)((ISelection)selection)) && !this.isReadOnly() && this.canLegallyEditResource()) {
            enable = true;
            Object obj = SelectionUtilities.getSelectedObject((ISelection)((ISelection)selection));
            if (obj != null) {
                enable = ModelerCore.getModelEditor().isValidPasteParent(obj);
            }
            if (!enable && (enable = this.isAndCanPasteDiagram((ISelection)selection))) {
                this.pastingDiagram = true;
            }
        }
        return enable;
    }

    private boolean isAndCanPasteDiagram(ISelection iSingleSelection) {
        Object obj;
        List cbContents;
        boolean canPaste = false;
        EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)iSingleSelection);
        if (eObj != null && (cbContents = this.getClipboardContents(eObj)) != null && cbContents.size() == 1 && (obj = cbContents.get(0)) instanceof Diagram) {
            canPaste = DiagramHelperManager.canPaste((Diagram)obj, eObj);
        }
        return canPaste;
    }

    private List getClipboardContents(Object targetForPaste) {
        ArrayList cbContents = null;
        try {
            cbContents = new ArrayList(ModelerCore.getModelEditor().getClipboardContents(targetForPaste));
        }
        catch (ModelerCoreException err) {
            String msg = UiConstants.Util.getString(PROBLEM, new Object[]{targetForPaste});
            UiConstants.Util.log(4, (Throwable)err, msg);
        }
        if (cbContents == null) {
            return Collections.EMPTY_LIST;
        }
        return cbContents;
    }
}

