/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.TransactionSettings;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectEditHelperManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CutWorker
extends ModelObjectWorker {
    private static final String PROBLEM = "CutWorker.problem";
    private static final String UNDO_TEXT = "CutAction.undoText";
    private static final String PLURAL_UNDO_TEXT = "CutAction.pluralUndoText";
    private ModelResource modelResource;
    private boolean editorIsOpening = false;
    private EObject focusedObject;
    private ISelection tempSelection;

    public CutWorker(boolean enableAfterExecute) {
        super(enableAfterExecute);
    }

    @Override
    public boolean setEnabledState() {
        ISelection iSelection;
        boolean enable = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && !(iSelection = (ISelection)selection).isEmpty() && !this.isReadOnly() && this.canLegallyEditResource()) {
            if (SelectionUtilities.isSingleSelection((ISelection)iSelection)) {
                EObject o = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                if (o instanceof Diagram) {
                    enable = DiagramHelperManager.canCut((Diagram)o);
                } else {
                    boolean bl = enable = o != null && ModelObjectEditHelperManager.canCut(o);
                }
                if (enable) {
                    this.focusedObject = o;
                    this.modelResource = ModelUtilities.getModelResourceForModelObject(o);
                }
            } else if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                enable = !sourceEObjects.isEmpty();
                Iterator iter = sourceEObjects.iterator();
                while (iter.hasNext() && enable) {
                    Object o = iter.next();
                    enable = o instanceof Diagram ? DiagramHelperManager.canCut((Diagram)o) : ModelObjectEditHelperManager.canCut(o);
                    if (!enable || this.tempSelection != null) continue;
                    this.focusedObject = (EObject)o;
                    this.modelResource = ModelUtilities.getModelResourceForModelObject((EObject)o);
                }
            }
        }
        if (!enable) {
            this.focusedObject = null;
            this.modelResource = null;
        }
        return enable;
    }

    @Override
    public boolean execute() {
        boolean successful = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && this.canLegallyEditResource()) {
            block15: {
                ISelection iSelection = (ISelection)selection;
                Object objectString = null;
                List lstObjs = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                TransactionSettings ts = this.getTransactionSettings();
                ts.setSource(this);
                boolean started = ModelerCore.startTxn((boolean)ts.isSignificant(), (boolean)ts.isUndoable(), (String)ts.getDescription(), (Object)ts.getSource());
                boolean succeeded = false;
                try {
                    try {
                        ModelerCore.getModelEditor().cutAllToClipboard((Collection)lstObjs);
                        succeeded = true;
                    }
                    catch (ModelerCoreException theException) {
                        String msg = UiConstants.Util.getString(PROBLEM, objectString);
                        UiConstants.Util.log(4, (Throwable)theException, msg);
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    throw throwable;
                }
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            this.tempSelection = null;
            this.editorIsOpening = false;
            this.focusedObject = null;
            this.modelResource = null;
            this.setTransactionSettings(null);
        }
        return successful;
    }

    public TransactionSettings initTransactionSettings() {
        TransactionSettings ts = this.getTransactionSettings();
        ts = this.processCanUndoCut(ts);
        ts = this.processDescription(ts);
        return ts;
    }

    private TransactionSettings processDescription(TransactionSettings ts) {
        Object selection = this.getSelection();
        if (selection instanceof ISelection && this.canLegallyEditResource()) {
            ISelection iSelection = (ISelection)selection;
            String objectString = null;
            List lstObjs = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
            String description = null;
            if (lstObjs.size() == 1) {
                EObject obj = (EObject)lstObjs.get(0);
                objectString = ModelerCore.getModelEditor().getModelRelativePath(obj).toString();
                description = UiConstants.Util.getString(UNDO_TEXT, (Object)objectString);
            } else {
                objectString = "" + lstObjs.size();
                description = UiConstants.Util.getString(PLURAL_UNDO_TEXT, (Object)objectString);
            }
            ts.setDescription(description);
        }
        return ts;
    }

    private TransactionSettings processCanUndoCut(TransactionSettings ts) {
        ISelection iSelection;
        boolean bCanUndoCut = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && !(iSelection = (ISelection)selection).isEmpty() && !this.isReadOnly() && this.canLegallyEditResource()) {
            if (SelectionUtilities.isSingleSelection((ISelection)iSelection)) {
                EObject o = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                bCanUndoCut = o != null && ModelObjectEditHelperManager.canUndoCut(o);
            } else if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                bCanUndoCut = true;
                if (sourceEObjects.size() > 0) {
                    bCanUndoCut = ModelObjectEditHelperManager.canUndoCut(sourceEObjects);
                }
            }
            ts.setIsUndoable(bCanUndoCut);
        }
        return ts;
    }

    public void setModelResource(ModelResource modelResource) {
        this.modelResource = modelResource;
    }

    public ISelection getTempSelection() {
        return this.tempSelection;
    }

    public void setTempSelection(ISelection tempSelection) {
        this.tempSelection = tempSelection;
    }

    public void setEditorIsOpening(boolean editorIsOpening) {
        this.editorIsOpening = editorIsOpening;
    }

    public boolean getEditorIsOpening() {
        return this.editorIsOpening;
    }

    public EObject getFocusedObject() {
        return this.focusedObject;
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }
}

