/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ContentViewer;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;

public final class SortModelContentsAction
extends Action
implements UiConstants {
    private ContentViewer viewer;

    public SortModelContentsAction(ContentViewer theViewer) {
        this.viewer = theViewer;
        String PREFIX = I18nUtil.getPropertyPrefix(this.getClass());
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/alphab_sort.gif"));
        this.setToolTipText(Util.getString(String.valueOf(PREFIX) + "tooltip", new Object[0]));
        this.setText(Util.getString(String.valueOf(PREFIX) + "text", new Object[0]));
        this.setId("modelExplorerResourceNavigator.sortModelContentsAction");
        this.setInitialState();
    }

    private void setInitialState() {
        boolean sorting = false;
        String pref = this.getPreferenceStore().getString("sortModelContents");
        if (!CoreStringUtil.isEmpty((String)pref) && pref.equals("always")) {
            sorting = true;
        }
        this.setChecked(sorting);
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    public void setChecked(boolean theCheckedFlag) {
        super.setChecked(theCheckedFlag);
        this.getPreferenceStore().setValue("sortModelContents", theCheckedFlag ? "always" : "never");
        if (this.viewer.getContentProvider() instanceof ModelExplorerContentProvider) {
            ((ModelExplorerContentProvider)this.viewer.getContentProvider()).setEnableModelSorting(theCheckedFlag);
            this.viewer.refresh();
        }
    }
}

