/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.net.URL;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.association.AbstractAssociationDescriptor;
import org.teiid.designer.core.association.AssociationDescriptor;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.wizards.NewModelObjectWizardManager;

public class NewAssociationAction
extends ModelObjectAction {
    private static final String PROBLEM = "NewAssociationAction.problem";
    private static final String NONE_ALLOWED = "NewAssociationAction.noneAllowed";
    private AssociationDescriptor descriptor;

    public NewAssociationAction() {
        super(UiPlugin.getDefault());
        this.configureNoneAllowedState();
    }

    public NewAssociationAction(AssociationDescriptor theDescriptor) {
        super(UiPlugin.getDefault());
        this.setDescriptor(theDescriptor);
    }

    private void configureAllowedState() {
        this.setText(this.descriptor.getText());
        Object o = this.descriptor.getImage();
        if (o instanceof URL) {
            o = ExtendedImageRegistry.INSTANCE.getImage(o);
        }
        if (o instanceof Image) {
            this.setImage((Image)o);
        }
        this.setEnabled(this.descriptor.isComplete());
    }

    private void configureNoneAllowedState() {
        this.setText(this.getPluginUtils().getString(NONE_ALLOWED, new Object[0]));
        this.setEnabled(false);
    }

    @Override
    protected void doRun() {
        Shell shell;
        if (this.descriptor != null && NewModelObjectWizardManager.isAssociationDescriptorValid(shell = super.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), this.descriptor, super.getSelection())) {
            if (!this.descriptor.creationComplete()) {
                try {
                    EObject newAssociation = ModelerCore.getModelEditor().createNewAssociationFromDescriptor((Object)this.descriptor);
                    ModelEditorManager.open(newAssociation, true);
                }
                catch (ModelerCoreException theException) {
                    String msg = this.getPluginUtils().getString(PROBLEM, new Object[]{this.descriptor});
                    this.getPluginUtils().log(4, (Throwable)theException, msg);
                    this.setEnabled(false);
                }
            } else {
                EObject newAssociation = ((AbstractAssociationDescriptor)this.descriptor).getNewAssociation();
                if (newAssociation != null) {
                    ModelEditorManager.open(newAssociation, true);
                }
            }
        }
    }

    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
    }

    public void setDescriptor(AssociationDescriptor theDescriptor) {
        this.descriptor = theDescriptor;
        if (this.descriptor == null) {
            this.configureNoneAllowedState();
        } else {
            this.configureAllowedState();
        }
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }
}

