/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelObjectEditorPanel;

public class FindAction
extends AbstractAction
implements IPartListener,
FocusListener {
    private FindReplaceAction actEclipseFindReplaceAction;
    private boolean bHasFocus;
    private ModelObjectEditorPanel moepModelEditorPanel = null;
    private FocusEvent feMostRecentFocusGainEvent;

    public FindAction() {
        super((AbstractUiPlugin)UiPlugin.getDefault());
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/find.gif"));
        this.setEnableState();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnableState(thePart);
    }

    protected void doRun() {
        FindReplaceAction actFindReplace = this.getFindReplaceAction();
        actFindReplace.update();
        actFindReplace.run();
    }

    private void setEnableState(IWorkbenchPart part) {
        if (part != null) {
            IFindReplaceTarget target = (IFindReplaceTarget)part.getAdapter(IFindReplaceTarget.class);
            if (target != null) {
                this.setEnabled(this.hasFocus());
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    private void setEnableState() {
        this.setEnableState(this.getCurrentWorkbenchPart());
    }

    private FindReplaceAction getFindReplaceAction() {
        ResourceBundle rb = ResourceBundle.getBundle("org.teiid.designer.ui.i18n");
        IWorkbenchPart workbenchPart = this.getCurrentWorkbenchPart();
        this.actEclipseFindReplaceAction = new FindReplaceAction(rb, "ConstantEditor.title", workbenchPart);
        this.actEclipseFindReplaceAction.setHelpContextId(IAbstractTextEditorHelpContextIds.FIND_ACTION);
        this.actEclipseFindReplaceAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        return this.actEclipseFindReplaceAction;
    }

    private IWorkbenchPart getCurrentWorkbenchPart() {
        IWorkbenchPage activePage = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IEditorPart workbenchPart = activePage.getActiveEditor();
            return workbenchPart;
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof ModelEditor) {
            this.moepModelEditorPanel = ((ModelEditor)part).getEditorContainer();
            if (this.moepModelEditorPanel != null) {
                this.moepModelEditorPanel.addFocusListener(this);
            }
        }
        this.setEnableState();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partClosed(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part instanceof ModelEditor && this.moepModelEditorPanel == null) {
            this.moepModelEditorPanel = ((ModelEditor)part).getEditorContainer();
            if (this.moepModelEditorPanel != null) {
                this.moepModelEditorPanel.removeFocusListener(this);
            }
        }
        this.moepModelEditorPanel = null;
        this.setEnabled(false);
    }

    public void partOpened(IWorkbenchPart part) {
        this.setEnableState();
    }

    public boolean hasFocus() {
        return this.bHasFocus;
    }

    public void focusLost(FocusEvent fe) {
        if (this.feMostRecentFocusGainEvent != null && fe.widget == this.feMostRecentFocusGainEvent.widget) {
            this.bHasFocus = false;
        }
        this.setEnableState();
    }

    public void focusGained(FocusEvent fe) {
        this.bHasFocus = true;
        this.feMostRecentFocusGainEvent = fe;
        this.setEnableState();
    }
}

