/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.details.ChangeHelper;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.common.ui.flatui.FlatFormLayout;
import org.eclipse.bpel.ui.BPELTabbedPropertySheetPage;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.adapters.IVirtualCopyRuleSide;
import org.eclipse.bpel.ui.commands.util.UpdateModelCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.IAssignCategory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AssignCategoryBase
extends BPELPropertySection
implements IAssignCategory {
    protected BPELPropertySection fOwnerSection;
    protected Composite fComposite;
    protected ChangeHelper fChangeHelper;
    protected Composite fParent;
    protected IVirtualCopyRuleSide fCopyRuleSide;

    protected AssignCategoryBase(BPELPropertySection ownerSection) {
        this.fOwnerSection = ownerSection;
    }

    protected abstract void load(IVirtualCopyRuleSide var1);

    protected abstract void store(IVirtualCopyRuleSide var1);

    protected String getLabelFlatFormatString() {
        return IBPELUIConstants.FORMAT_CMD_SELECT;
    }

    protected ChangeHelper getChangeHelper() {
        return this.fChangeHelper;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isCategoryForModel(EObject model) {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected Command wrapInShowContextCommand(Command inner) {
        return super.wrapInShowContextCommand(inner, this.fOwnerSection);
    }

    protected boolean isToOrFromAffected(Notification n) {
        return true;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new BatchedMultiObjectAdapter[]{new BatchedMultiObjectAdapter(){
            boolean bUpdate = false;

            @Override
            public void notify(Notification n) {
                this.bUpdate = AssignCategoryBase.this.isToOrFromAffected(n);
            }

            @Override
            public void finish() {
                if (this.bUpdate) {
                    AssignCategoryBase.this.updateCategoryWidgets();
                    this.bUpdate = false;
                }
            }
        }};
    }

    @Override
    public Composite getComposite() {
        return this.fParent;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        ICommandFramework commandFramework = ((BPELTabbedPropertySheetPage)aTabbedPropertySheetPage).getEditor().getCommandFramework();
        this.fChangeHelper = new ChangeHelper(commandFramework){

            public String getLabel() {
                return BPELUtil.formatString(AssignCategoryBase.this.getLabelFlatFormatString(), AssignCategoryBase.this.getName());
            }

            public Command createApplyCommand() {
                return AssignCategoryBase.this.wrapInShowContextCommand(AssignCategoryBase.this.newStoreModelCommand());
            }

            public void restoreOldState() {
                AssignCategoryBase.this.updateCategoryWidgets();
            }
        };
        super.createControls(parent, aTabbedPropertySheetPage);
        this.fParent = parent;
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        this.fCopyRuleSide = BPELUtil.adapt((Object)newInput, IVirtualCopyRuleSide.class);
        super.basicSetInput(newInput);
    }

    protected void updateCategoryWidgets() {
        this.load(this.fCopyRuleSide);
    }

    public Command newStoreModelCommand() {
        return new UpdateModelCommand(this.fCopyRuleSide.getCopyRuleSide(), "Modify ..!"){

            @Override
            public void doExecute() {
                AssignCategoryBase.this.store(AssignCategoryBase.this.fCopyRuleSide);
            }
        };
    }

    protected boolean isDefaultCompositeOpaque() {
        return true;
    }

    @Override
    protected final void createClient(Composite parent) {
        FlatFormLayout layout = new FlatFormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.createClient2(parent);
    }

    protected void createClient2(Composite parent) {
        this.fComposite = this.isDefaultCompositeOpaque() ? this.fWidgetFactory.createPlainComposite(parent, 0) : this.fWidgetFactory.createComposite(parent);
        FlatFormLayout layout = new FlatFormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fComposite.setLayout((Layout)layout);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.fComposite.setLayoutData((Object)data);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateCategoryWidgets();
    }

    @Override
    public void aboutToBeHidden() {
        ChangeHelper changeHelper;
        if (this.isCreated && (changeHelper = this.getChangeHelper()) != null) {
            this.getCommandFramework().notifyChangeDone((IOngoingChange)changeHelper);
        }
        super.aboutToBeHidden();
    }

    @Override
    public void setInput(EObject model) {
        this.removeAllAdapters();
        this.basicSetInput(model);
        this.addAllAdapters();
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }
}

