/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.tree;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IJoinPredicate;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.UiPlugin;
import org.teiid.query.ui.builder.util.ElementViewerFactory;

public class QueryTreeLabelProvider
implements ILabelProvider,
UiConstants {
    private static final Image SELECT_ICON;
    private static final Image FROM_ICON;
    private static final Image WHERE_ICON;
    private static final Image EXPRESSION_ICON;
    private static final Image UNION_ICON;
    private static final Image JOIN_ICON;
    private static final String WHERE = "WHERE";
    private static final String FROM = "FROM";
    private static final String UNION = "UNION";
    private ILabelProvider delegate;

    static {
        UiPlugin plugin = UiPlugin.getDefault();
        SELECT_ICON = plugin.getImage("icons/full/obj16/select.gif");
        FROM_ICON = plugin.getImage("icons/full/obj16/from.gif");
        WHERE_ICON = plugin.getImage("icons/full/obj16/where.gif");
        EXPRESSION_ICON = plugin.getImage("icons/full/obj16/functionLangObj.gif");
        UNION_ICON = plugin.getImage("icons/full/obj16/union.gif");
        JOIN_ICON = plugin.getImage("icons/full/obj16/join.gif");
    }

    public QueryTreeLabelProvider() {
        this(ElementViewerFactory.getLabelProvider());
    }

    public QueryTreeLabelProvider(ILabelProvider metadataLabelProvider) {
        this.delegate = metadataLabelProvider != null ? metadataLabelProvider : ElementViewerFactory.getLabelProvider();
    }

    public Image getImage(Object element) {
        if (element instanceof ILanguageObject) {
            Object id;
            if (element instanceof ISetQuery) {
                switch (((ISetQuery)element).getOperation()) {
                    case INTERSECT: {
                        return null;
                    }
                    case EXCEPT: {
                        return null;
                    }
                }
                return UNION_ICON;
            }
            if (element instanceof IQuery) {
                return SELECT_ICON;
            }
            if (element instanceof ICriteria) {
                return WHERE_ICON;
            }
            if (element instanceof IFrom) {
                return FROM_ICON;
            }
            if (element instanceof IJoinPredicate) {
                return JOIN_ICON;
            }
            if (element instanceof IExpression) {
                if (element instanceof IExpressionSymbol) {
                    return EXPRESSION_ICON;
                }
                return this.delegate == null ? null : this.delegate.getImage(((IElementSymbol)element).getMetadataID());
            }
            if (element instanceof IGroupSymbol && (id = ((IGroupSymbol)element).getMetadataID()) != null) {
                return this.delegate == null ? null : this.delegate.getImage(id);
            }
            return null;
        }
        return this.delegate == null ? null : this.delegate.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ILanguageObject) {
            if (element instanceof ISetQuery) {
                return UNION;
            }
            if (element instanceof IQuery) {
                return ((IQuery)element).getSelect().toString();
            }
            if (element instanceof IFrom) {
                return FROM;
            }
            if (element instanceof ICriteria) {
                return "WHERE " + element.toString();
            }
            return element.toString();
        }
        return this.delegate == null ? null : this.delegate.getText(element);
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

