/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.sql;

import java.util.ArrayList;
import java.util.HashMap;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.UiPlugin;
import org.teiid.query.ui.sqleditor.sql.SqlFormattingConstants;

public class SqlFormattingStrategy
implements SqlFormattingConstants,
UiConstants {
    private String sInSql;
    private String sFormattedSql;
    private HashMap hmParseResult;
    private ArrayList arylKeywordInstances;

    private void init() {
        this.sInSql = null;
        this.sFormattedSql = null;
        this.hmParseResult = null;
        this.arylKeywordInstances = null;
    }

    private HashMap getParseMap() {
        if (this.hmParseResult == null) {
            this.hmParseResult = new HashMap();
        }
        return this.hmParseResult;
    }

    private ArrayList getOffsetList(String sKeyword) {
        if (this.getParseMap().get(sKeyword) == null) {
            this.getParseMap().put(sKeyword, new ArrayList());
        }
        return (ArrayList)this.getParseMap().get(sKeyword);
    }

    private ArrayList getKeywordOffsetsArray() {
        if (this.arylKeywordInstances == null) {
            this.arylKeywordInstances = new ArrayList();
        }
        return this.arylKeywordInstances;
    }

    public String format(String sInSql) {
        this.init();
        this.sInSql = sInSql;
        this.sFormattedSql = sInSql;
        if (sInSql != null && sInSql.trim().length() > 0 && this.okToProcess(sInSql)) {
            sInSql = this.filter(sInSql);
            this.parse(sInSql);
            this.markupTheKeywordInstances();
            this.sFormattedSql = this.formatTheString(sInSql);
        }
        return this.sFormattedSql;
    }

    private String filter(String s) {
        StringBuffer sbTarget = new StringBuffer(s.length());
        char chCurrentChar = ' ';
        this.okToProcess(s);
        int iPos = 0;
        while (iPos < this.sInSql.length()) {
            chCurrentChar = s.charAt(iPos);
            if (chCurrentChar != '\n' && chCurrentChar != '\t') {
                sbTarget.append(chCurrentChar);
            }
            ++iPos;
        }
        return sbTarget.toString();
    }

    private String parse(String s) {
        boolean bMatch = false;
        StringBuffer sbTarget = new StringBuffer(s.length());
        int iUnclosedParenCount = 0;
        int chCurrentChar = 32;
        int iPos = 0;
        while (iPos < s.length()) {
            chCurrentChar = s.charAt(iPos);
            if (chCurrentChar == 40) {
                ++iUnclosedParenCount;
            } else if (chCurrentChar == 41) {
                --iUnclosedParenCount;
            } else if (iUnclosedParenCount == 0 && chCurrentChar == 32) {
                int ixKeyword = 0;
                while (ixKeyword < KEYWORDS.length) {
                    String sKeyword;
                    int iWordStart = iPos - KEYWORDS[ixKeyword].length();
                    bMatch = s.regionMatches(true, iWordStart, sKeyword = KEYWORDS[ixKeyword], 0, sKeyword.length());
                    if (bMatch) {
                        ArrayList arylOffsets = this.getOffsetList(sKeyword);
                        arylOffsets.add(new Integer(iWordStart));
                        KeywordInstance kwi = new KeywordInstance(sKeyword, iWordStart);
                        this.getKeywordOffsetsArray().add(kwi);
                        break;
                    }
                    ++ixKeyword;
                }
            }
            ++iPos;
        }
        return sbTarget.toString();
    }

    private boolean okToProcess(String s) {
        boolean bOk = true;
        if (s.indexOf("CREATE VIRTUAL PROCEDURE") > -1) {
            bOk = false;
        }
        return bOk;
    }

    private void markupTheKeywordInstances() {
        for (KeywordInstance kwiTemp : this.getKeywordOffsetsArray()) {
            if (kwiTemp.sKeyword.equals("FROM") && this.getParseMap().get("SELECT") == null) continue;
            kwiTemp.setApplyFlag(true);
        }
    }

    private String formatTheString(String sSql) {
        String sResultString = null;
        StringBuffer sb = new StringBuffer(sSql);
        ArrayList arylKwis = this.getKeywordOffsetsArray();
        int iSize = arylKwis.size();
        int i = iSize - 1;
        while (i >= 0) {
            KeywordInstance kwi = (KeywordInstance)arylKwis.get(i);
            if (kwi.isApplicable()) {
                this.formatKeyword(sb, kwi);
            }
            --i;
        }
        sResultString = sb.toString();
        return sResultString;
    }

    private void formatKeyword(StringBuffer sb, KeywordInstance kwi) {
        String sNewString = "";
        if (kwi.iOffset > 0 && this.startClausesOnNewLine()) {
            sNewString = "\n";
        }
        sNewString = String.valueOf(sNewString) + kwi.sKeyword + "\n";
        if (this.startClausesOnNewLine() && this.indentClauseContent()) {
            sNewString = String.valueOf(sNewString) + "\t";
        }
        sb.replace(kwi.iOffset, kwi.iOffset + kwi.sKeyword.length(), sNewString);
    }

    private boolean startClausesOnNewLine() {
        return UiPlugin.getDefault().getPreferenceStore().getBoolean("startClausesOnNewLine");
    }

    private boolean indentClauseContent() {
        return UiPlugin.getDefault().getPreferenceStore().getBoolean("indentClauseContent");
    }

    class KeywordInstance {
        String sKeyword;
        int iOffset;
        boolean bApply;

        KeywordInstance(String sKeyword, int iOffset) {
            this.sKeyword = sKeyword;
            this.iOffset = iOffset;
        }

        public String getKeyword() {
            return this.sKeyword;
        }

        public int getOffset() {
            return this.iOffset;
        }

        public void setApplyFlag(boolean b) {
            this.bApply = b;
        }

        public boolean isApplicable() {
            return this.bApply;
        }
    }
}

