/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.util;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.query.ui.UiConstants;

public final class BuilderUtils
implements UiConstants {
    public static final Color COLOR_HIGHLIGHT = GlobalUiColorManager.getColor((RGB)new RGB(204, 204, 255));
    public static final String UNDEFINED = "<undefined>";

    private BuilderUtils() {
    }

    public static IConstant createConversionTypeConstant() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        IDataTypeManagerService dataTypeManagerService = ModelerCore.getTeiidDataTypeManagerService();
        return factory.createConstant((Object)dataTypeManagerService.getDefaultDataType(IDataTypeManagerService.DataTypeName.STRING));
    }

    public static ILanguageObject getBuilderLanguageObject(ILanguageObject theLangObj) {
        CoreArgCheck.isNotNull((Object)theLangObj);
        ILanguageObject result = theLangObj;
        if (theLangObj != null && theLangObj instanceof IFunction && ((IFunction)theLangObj).isImplicit()) {
            result = BuilderUtils.getBuilderLanguageObject((ILanguageObject)((IFunction)theLangObj).getArgs()[0]);
        }
        return result;
    }

    public static int getTextLimit(String theTextType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return service.getDataTypeLimit(theTextType);
    }

    public static String getType(IConstant theConstant) {
        Class typeClass = theConstant.getType();
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return service.getDataTypeName(typeClass);
    }

    public static Collection<String> getAllTypes() {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return service.getAllDataTypeNames();
    }

    public static Collection<String> getInvalidTypes() {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return Collections.singleton(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.NULL));
    }

    public static Class getTypeClass(String theType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return BuilderUtils.isValidType(theType) ? service.getDataTypeClass(theType) : null;
    }

    public static String getValidChars(String theTextType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return service.getDataTypeValidChars(theTextType);
    }

    public static boolean isBooleanType(String theType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theType == null ? false : theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.BOOLEAN));
    }

    public static boolean isConversionType(IConstant theConstant) {
        boolean result = false;
        if (theConstant != null && theConstant.getType().equals(String.class) && BuilderUtils.isValidType((String)theConstant.getValue())) {
            result = true;
        }
        return result;
    }

    public static boolean isConversionTypeArg(String theFunctionName, String theArgName) {
        boolean result = false;
        if ((theFunctionName.equals("CAST") || theFunctionName.equals("CONVERT")) && theArgName.equals("TARGET")) {
            result = true;
        }
        return result;
    }

    public static boolean isConversionTypeConstant(Object theObject) {
        boolean result = theObject instanceof IConstant;
        if (result) {
            IConstant constant = (IConstant)theObject;
            result = constant.getType().equals(String.class) && BuilderUtils.isValidType((String)constant.getValue());
        }
        return result;
    }

    public static boolean isDateType(String theType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theType == null ? false : theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.DATE));
    }

    public static boolean isNumberType(String theType) {
        if (theType == null) {
            return false;
        }
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.BIG_DECIMAL)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.BIG_INTEGER)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.BYTE)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.DOUBLE)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.FLOAT)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.INTEGER)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.LONG)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.SHORT));
    }

    public static boolean isNullType(String theType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theType == null ? false : theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.NULL));
    }

    public static boolean isStringType(String theType) {
        if (theType == null) {
            return false;
        }
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return BuilderUtils.isNumberType(theType) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.CHAR)) || theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.STRING));
    }

    public static boolean isTimeType(String theType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theType == null ? false : theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.TIME));
    }

    public static boolean isTimestampType(String theType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theType == null ? false : theType.equals(service.getDefaultDataType(IDataTypeManagerService.DataTypeName.TIMESTAMP));
    }

    public static boolean isValidType(String theType) {
        if (theType == null) {
            return false;
        }
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        IDataTypeManagerService.DataTypeName[] dataTypeNameArray = IDataTypeManagerService.DataTypeName.values();
        int n = dataTypeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataTypeManagerService.DataTypeName dataTypeName = dataTypeNameArray[n2];
            if (theType.equals(service.getDefaultDataType(dataTypeName))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static interface LoggingConstants {
        public static final String PREFIX = "builders_";
        public static final String DEBUG = "builders_debug";
        public static final String EVENTS = "builders_events";
        public static final String TRACING = "builders_tracing";
    }
}

