/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.CompareCriteriaEditorModel;
import org.teiid.query.ui.builder.model.CompositeLanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.IsNullCriteriaEditorModel;
import org.teiid.query.ui.builder.model.MatchCriteriaEditorModel;
import org.teiid.query.ui.builder.model.SetCriteriaEditorModel;

public class CriteriaEditorModel
extends CompositeLanguageObjectEditorModel {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CriteriaEditorModel.class);
    public static final String OPERATOR = "OPERATOR";
    private CompareCriteriaEditorModel compareModel;
    private IsNullCriteriaEditorModel isNullModel;
    private MatchCriteriaEditorModel matchModel;
    private SetCriteriaEditorModel setModel;
    private Class criteriaType;
    private Map typeModelMap = new HashMap();
    private Map typeOperatorMap = new HashMap();
    private String defaultOperator;
    private String operator;
    private String[] operators;

    public CriteriaEditorModel() {
        this(new CompareCriteriaEditorModel(), new IsNullCriteriaEditorModel(), new MatchCriteriaEditorModel(), new SetCriteriaEditorModel());
    }

    public CriteriaEditorModel(CompareCriteriaEditorModel theCompareCriteriaModel, IsNullCriteriaEditorModel theIsNullCriteriaModel, MatchCriteriaEditorModel theMatchCriteriaModel, SetCriteriaEditorModel theSetCriteriaModel) {
        super(ICriteria.class);
        this.compareModel = theCompareCriteriaModel;
        this.addModel(this.compareModel);
        this.isNullModel = theIsNullCriteriaModel;
        this.addModel(this.isNullModel);
        this.matchModel = theMatchCriteriaModel;
        this.addModel(this.matchModel);
        this.setModel = theSetCriteriaModel;
        this.addModel(this.setModel);
    }

    @Override
    public void addModel(ILanguageObjectEditorModel theModel) {
        super.addModel(theModel);
        AbstractPredicateCriteriaTypeEditorModel model = (AbstractPredicateCriteriaTypeEditorModel)theModel;
        this.typeModelMap.put(model.getModelType(), model);
        this.addOperators(model);
    }

    private void addOperators(AbstractPredicateCriteriaTypeEditorModel theModel) {
        String[] modelOperators = theModel.getOperators();
        this.typeOperatorMap.put(theModel.getModelType(), modelOperators);
        if (this.operators == null) {
            this.operators = new String[0];
        }
        String[] temp = new String[this.operators.length + modelOperators.length];
        System.arraycopy(this.operators, 0, temp, 0, this.operators.length);
        System.arraycopy(modelOperators, 0, temp, this.operators.length, modelOperators.length);
        this.operators = temp;
        if (this.defaultOperator == null) {
            this.defaultOperator = modelOperators[0];
            this.setOperator(this.defaultOperator);
        }
    }

    public CompareCriteriaEditorModel getCompareCriteriaEditorModel() {
        return this.compareModel;
    }

    public ICriteria getCriteria() {
        return (ICriteria)this.getLanguageObject();
    }

    public Class getCriteriaType() {
        return this.criteriaType;
    }

    private Class getCriteriaType(String theOperator) {
        Class result = null;
        for (Map.Entry entry : this.typeOperatorMap.entrySet()) {
            String[] operators = (String[])entry.getValue();
            if (!Arrays.asList(operators).contains(theOperator)) continue;
            result = (Class)entry.getKey();
            break;
        }
        return result;
    }

    private AbstractPredicateCriteriaTypeEditorModel getModel(String theOperator) {
        Class type = this.getCriteriaType(theOperator);
        return (AbstractPredicateCriteriaTypeEditorModel)this.typeModelMap.get(type);
    }

    public IsNullCriteriaEditorModel getIsNullCriteriaEditorModel() {
        return this.isNullModel;
    }

    public MatchCriteriaEditorModel getMatchCriteriaEditorModel() {
        return this.matchModel;
    }

    public String getOperator() {
        AbstractPredicateCriteriaTypeEditorModel model = (AbstractPredicateCriteriaTypeEditorModel)this.getCurrentModel();
        this.operator = model.getCurrentOperator();
        return this.operator;
    }

    public String[] getOperators() {
        return this.operators;
    }

    public SetCriteriaEditorModel getSetCriteriaEditorModel() {
        return this.setModel;
    }

    private boolean isValidOperator(String theOperator) {
        CoreArgCheck.isNotNull((Object)theOperator);
        CoreArgCheck.isNotEqual((int)0, (int)theOperator.length());
        boolean result = false;
        for (Map.Entry entry : this.typeOperatorMap.entrySet()) {
            String[] operators = (String[])entry.getValue();
            if (!Arrays.asList(operators).contains(theOperator)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void setCurrentModel(ILanguageObjectEditorModel theModel) {
        super.setCurrentModel(theModel);
    }

    public void setOperator(String theOperator) {
        if (this.isValidOperator(theOperator)) {
            if (this.getOperator() == null || !this.operator.equals(theOperator)) {
                this.operator = theOperator;
                AbstractPredicateCriteriaTypeEditorModel newModel = this.getModel(theOperator);
                AbstractPredicateCriteriaTypeEditorModel currentModel = (AbstractPredicateCriteriaTypeEditorModel)this.getCurrentModel();
                if (currentModel != newModel) {
                    IExpression leftExpression = currentModel.getLeftExpression();
                    IExpression rightExpression = currentModel.getRightExpression();
                    this.setCurrentModel(newModel);
                    newModel.setLeftExpression(leftExpression);
                    newModel.setRightExpression(rightExpression);
                }
                newModel.setCurrentOperator(theOperator);
            }
        } else {
            CoreArgCheck.isTrue((boolean)false, (String)Util.getString(String.valueOf(PREFIX) + "invalidOperator", new Object[]{theOperator}));
        }
    }
}

