/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.query.ui.builder.model.AbstractLanguageObjectEditorModel;
import org.teiid.query.ui.builder.util.BuilderUtils;

public class ConstantEditorModel
extends AbstractLanguageObjectEditorModel
implements BuilderUtils.LoggingConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ConstantEditorModel.class);
    private final String DEFAULT_TYPE;
    public static final String TYPE = "TYPE";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String DATE = "DATE";
    public static final String NULL = "NULL";
    public static final String TEXT = "TEXT";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    private Boolean booleanValue = null;
    private Date dateValue = null;
    private String textValue = null;
    private Time timeValue = null;
    private Timestamp timestampValue = null;
    private boolean conversionType = false;
    private String type;

    public ConstantEditorModel() {
        super(IConstant.class);
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        this.DEFAULT_TYPE = service.getDefaultDataType(IDataTypeManagerService.DataTypeName.STRING);
        this.setDefaults();
    }

    @Override
    public void clear() {
        this.setDefaults();
        this.type = this.DEFAULT_TYPE;
        this.conversionType = false;
        super.clear();
    }

    public boolean getBoolean() {
        if (!this.isBoolean()) {
            CoreArgCheck.isTrue((boolean)this.isBoolean(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"getBoolean()", this.type}));
        }
        return this.booleanValue;
    }

    public IConstant getConstant() {
        return (IConstant)this.getLanguageObject();
    }

    @Override
    public ILanguageObject getLanguageObject() {
        if (!this.isComplete() || !this.isValid()) {
            return null;
        }
        Object value = null;
        if (this.conversionType) {
            value = this.type;
        } else if (this.isText()) {
            Class typeClass = BuilderUtils.getTypeClass(this.type);
            if (Number.class.isAssignableFrom(typeClass)) {
                try {
                    Constructor constructor = typeClass.getConstructor(String.class);
                    value = constructor.newInstance(this.textValue);
                }
                catch (Exception theException) {
                    Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "invalidTextValue", new Object[]{this.textValue, typeClass}));
                }
            } else {
                value = typeClass == Character.class ? new Character(this.textValue.charAt(0)) : this.textValue;
            }
        } else if (this.isDate()) {
            value = this.getDate();
        } else if (this.isTimestamp()) {
            value = this.getTimestamp();
        } else if (this.isTime()) {
            value = this.getTime();
        } else if (this.isBoolean()) {
            value = this.booleanValue;
        }
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        return factory.createConstant(value);
    }

    public Date getDate() {
        if (!this.isDate()) {
            CoreArgCheck.isTrue((boolean)this.isDate(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"getDate()", this.type}));
        }
        return this.dateValue;
    }

    public String getText() {
        if (!this.isText()) {
            CoreArgCheck.isTrue((boolean)this.isText(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"getText()", this.type}));
        }
        return this.textValue;
    }

    public static int getTextLimit(String theTextType) {
        return BuilderUtils.getTextLimit(theTextType);
    }

    public Time getTime() {
        CoreArgCheck.isTrue((boolean)this.isTime(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"getTime()", this.type}));
        if (this.timeValue != null) {
            Calendar date = Calendar.getInstance();
            date.setTime(this.timeValue);
            date.set(13, 0);
            date.set(14, 0);
            this.timeValue = new Time(date.getTime().getTime());
        }
        return this.timeValue;
    }

    public Timestamp getTimestamp() {
        if (!this.isTimestamp()) {
            CoreArgCheck.isTrue((boolean)this.isTimestamp(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"getTimestamp()", this.type}));
        }
        if (this.timestampValue != null) {
            Calendar date = Calendar.getInstance();
            date.setTime(this.timestampValue);
            date.set(13, 0);
            date.set(14, 0);
            this.timestampValue = new Timestamp(date.getTime().getTime());
        }
        return this.timestampValue;
    }

    public String getType() {
        return this.type;
    }

    public boolean isBoolean() {
        return !this.isConversionType() && BuilderUtils.isBooleanType(this.type);
    }

    @Override
    public boolean isComplete() {
        boolean result = false;
        if (this.conversionType) {
            result = true;
        } else if (this.isText()) {
            result = this.textValue != null && this.isValid();
        } else if (this.isDate()) {
            result = this.dateValue != null;
        } else if (this.isTimestamp()) {
            result = this.timestampValue != null;
        } else if (this.isTime()) {
            result = this.timeValue != null;
        } else if (this.isBoolean()) {
            result = this.booleanValue != null;
        } else if (this.isNull()) {
            result = true;
        }
        return result;
    }

    public boolean isConversionType() {
        return this.conversionType;
    }

    public boolean isDate() {
        return !this.isConversionType() && BuilderUtils.isDateType(this.type);
    }

    public boolean isNull() {
        return !this.isConversionType() && BuilderUtils.isNullType(this.type);
    }

    public boolean isText() {
        return !this.isConversionType() && BuilderUtils.isStringType(this.type);
    }

    public boolean isTime() {
        return !this.isConversionType() && BuilderUtils.isTimeType(this.type);
    }

    public boolean isTimestamp() {
        return !this.isConversionType() && BuilderUtils.isTimestampType(this.type);
    }

    public boolean isValid() {
        return this.isText() ? this.isValidValue(this.textValue) && this.isValidNumber(this.textValue) : true;
    }

    public boolean isValidValue(String theString) {
        if (!this.isText()) {
            return true;
        }
        if (this.textValue.length() > ConstantEditorModel.getTextLimit(this.type)) {
            return false;
        }
        String validChars = BuilderUtils.getValidChars(this.type);
        if (validChars != null) {
            int length = this.textValue.length();
            int i = 0;
            while (i < length) {
                if (validChars.indexOf(this.textValue.charAt(i)) == -1) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean isValidNumber(String theString) {
        Class typeClass = BuilderUtils.getTypeClass(this.type);
        if (Number.class.isAssignableFrom(typeClass)) {
            try {
                Constructor constructor = typeClass.getConstructor(String.class);
                constructor.newInstance(theString);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String paramString() {
        return new StringBuffer().append("type=").append(this.type).append(", conversionType=").append(this.conversionType).append(", booleanValue=").append(this.booleanValue).append(", dateValue=").append(this.dateValue).append(", textValue=").append(this.textValue).append(", timeValue=").append(this.timeValue).append(", timestampValue=").append(this.timestampValue).toString();
    }

    public void setBoolean(boolean theFlag) {
        if (!this.isBoolean()) {
            CoreArgCheck.isTrue((boolean)this.isBoolean(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"setBoolean()", this.type}));
        }
        if (this.booleanValue == null || this.getBoolean() != theFlag) {
            this.booleanValue = new Boolean(theFlag);
            this.fireModelChanged(BOOLEAN);
        }
    }

    private void setConstant(IConstant theConstant) {
        if (theConstant == null && this.getConstant() == null || theConstant != null && this.getConstant() != null && theConstant.equals(this.getConstant())) {
            return;
        }
        this.notifyListeners = false;
        if (theConstant == null || theConstant.getValue() == null) {
            this.clear();
        } else {
            this.conversionType = BuilderUtils.isConversionType(theConstant);
            this.type = this.conversionType ? (String)theConstant.getValue() : BuilderUtils.getType(theConstant);
            this.setDefaults();
            if (!this.conversionType) {
                if (this.isText()) {
                    this.setText(theConstant.getValue().toString());
                } else if (this.isBoolean()) {
                    Boolean value = (Boolean)theConstant.getValue();
                    this.setBoolean(value);
                } else if (this.isNull()) {
                    this.setNull();
                } else if (this.isDate()) {
                    Date value = (Date)theConstant.getValue();
                    this.setDate(value);
                } else if (this.isTimestamp()) {
                    Timestamp value = (Timestamp)theConstant.getValue();
                    this.setTimestamp(value);
                } else if (this.isTime()) {
                    Time value = (Time)theConstant.getValue();
                    this.setTime(value);
                } else {
                    this.type = this.DEFAULT_TYPE;
                    this.setText(theConstant.getValue().toString());
                }
            }
        }
        this.notifyListeners = true;
        this.fireModelChanged("SAVED");
    }

    public void setDate(Date theDate) {
        if (!this.isDate()) {
            CoreArgCheck.isTrue((boolean)this.isDate(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"setDate()", this.type}));
        }
        if (this.dateValue == null || !this.dateValue.equals(theDate)) {
            this.dateValue = theDate;
            this.fireModelChanged(DATE);
        }
    }

    private void setDefaults() {
        this.type = this.DEFAULT_TYPE;
        this.booleanValue = new Boolean(true);
        this.dateValue = new Date(Calendar.getInstance().getTime().getTime());
        this.textValue = "";
        this.timeValue = new Time(Calendar.getInstance().getTime().getTime());
        this.timestampValue = new Timestamp(Calendar.getInstance().getTime().getTime());
    }

    @Override
    public void setLanguageObject(ILanguageObject theLangObj) {
        super.setLanguageObject(theLangObj);
        this.setConstant((IConstant)theLangObj);
    }

    public void setNull() {
        if (!this.isNull()) {
            CoreArgCheck.isTrue((boolean)this.isNull(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"setNull()", this.type}));
        }
    }

    public void setText(String theText) {
        if (!this.isText()) {
            CoreArgCheck.isTrue((boolean)this.isText(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"setText()", this.type}));
        }
        if (this.textValue == null || !this.getText().equals(theText)) {
            this.textValue = theText;
            this.fireModelChanged(TEXT);
        }
    }

    public void setTime(Time theTime) {
        if (!this.isTime()) {
            CoreArgCheck.isTrue((boolean)this.isTime(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"setTime()", this.type}));
        }
        if (this.timeValue == null || !this.timeValue.equals(theTime)) {
            this.timeValue = theTime;
            this.fireModelChanged(TIME);
        }
    }

    public void setTimestamp(Timestamp theTimestamp) {
        if (!this.isTimestamp()) {
            CoreArgCheck.isTrue((boolean)this.isTimestamp(), (String)Util.getString(String.valueOf(PREFIX) + "invalidRequest", new Object[]{"setTimestamp()", this.type}));
        }
        if (this.timestampValue == null || !this.timestampValue.equals(theTimestamp)) {
            this.timestampValue = theTimestamp;
            this.fireModelChanged(TIMESTAMP);
        }
    }

    public void setType(String theType) {
        boolean changed = false;
        if (BuilderUtils.isValidType(theType)) {
            if (!this.type.equals(theType)) {
                this.type = theType;
                changed = true;
            }
        } else {
            this.type = this.DEFAULT_TYPE;
            changed = true;
        }
        if (changed) {
            this.fireModelChanged(TYPE);
        }
    }
}

