/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fusesource.ide.fabric8.core.dto.SshHostConfigurationDTO;

public class SshConfigurationDTO {
    private List<SshHostConfigurationDTO> hosts = new ArrayList<SshHostConfigurationDTO>();
    private String defaultPath;
    private Integer defaultPort;
    private String defaultUsername;
    private String defaultPassword;
    private List<String> fallbackRepositories;
    private String defaultPassPhrase;
    private String defaultPrivateKeyFile;

    public SshHostConfigurationDTO getHost(String hostName) {
        if (this.hosts != null) {
            for (SshHostConfigurationDTO host : this.hosts) {
                if (!hostName.equals(host.getHostName())) continue;
                return host;
            }
        }
        return null;
    }

    public void addHost(SshHostConfigurationDTO configuration) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<SshHostConfigurationDTO>();
        }
        this.hosts.add(configuration);
    }

    public SshHostConfigurationDTO host(String hostName) {
        SshHostConfigurationDTO answer = this.getHost(hostName);
        if (answer == null) {
            answer = new SshHostConfigurationDTO(hostName);
            this.addHost(answer);
        }
        return answer;
    }

    public SshConfigurationDTO defaultPort(Integer defaultPort) {
        this.setDefaultPort(defaultPort);
        return this;
    }

    public SshConfigurationDTO defaultPath(String defaultPath) {
        this.setDefaultPath(defaultPath);
        return this;
    }

    public SshConfigurationDTO defaultUsername(String defaultUsername) {
        this.defaultUsername = defaultUsername;
        return this;
    }

    public SshConfigurationDTO defaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
        return this;
    }

    public SshConfigurationDTO defaultPassPhrase(String defaultPassPhrase) {
        this.defaultPassPhrase = defaultPassPhrase;
        return this;
    }

    public SshConfigurationDTO defaultPrivateKeyFile(String defaultPrivateKeyFile) {
        this.defaultPrivateKeyFile = defaultPrivateKeyFile;
        return this;
    }

    public SshConfigurationDTO fallbackRepositories(List<String> fallbackRepositories) {
        this.fallbackRepositories = fallbackRepositories;
        return this;
    }

    public SshConfigurationDTO fallbackRepositories(String ... fallbackRepositories) {
        return this.fallbackRepositories(Arrays.asList(fallbackRepositories));
    }

    public List<SshHostConfigurationDTO> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<SshHostConfigurationDTO> hosts) {
        this.hosts = hosts;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(Integer defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getDefaultUsername() {
        return this.defaultUsername;
    }

    public void setDefaultUsername(String defaultUsername) {
        this.defaultUsername = defaultUsername;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public List<String> getFallbackRepositories() {
        return this.fallbackRepositories;
    }

    public void setFallbackRepositories(List<String> fallbackRepositories) {
        this.fallbackRepositories = fallbackRepositories;
    }

    public String getDefaultPassPhrase() {
        return this.defaultPassPhrase;
    }

    public void setDefaultPassPhrase(String defaultPassPhrase) {
        this.defaultPassPhrase = defaultPassPhrase;
    }

    public String getDefaultPrivateKeyFile() {
        return this.defaultPrivateKeyFile;
    }

    public void setDefaultPrivateKeyFile(String defaultPrivateKeyFile) {
        this.defaultPrivateKeyFile = defaultPrivateKeyFile;
    }
}

