/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileRequirementsDTO;
import org.fusesource.ide.fabric8.core.dto.SshConfigurationDTO;
import org.fusesource.ide.fabric8.core.dto.SshHostConfigurationDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class RequirementsDTO
extends BaseDTO {
    public static final String JSON_PROFILE_REQS = "profileRequirements";
    public static final String JSON_VERSION = "version";
    private Map<String, ProfileRequirementsDTO> profileRequirements = new HashMap<String, ProfileRequirementsDTO>();
    private SshConfigurationDTO sshConfiguration;

    public RequirementsDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    public void addProfileRequirement(ProfileRequirementsDTO profileRequirement) {
        if (!this.profileRequirements.containsKey(profileRequirement.getProfile())) {
            this.profileRequirements.put(profileRequirement.getProfile(), profileRequirement);
        }
    }

    @Override
    public void create() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void update() {
    }

    public SshConfigurationDTO getSshConfiguration() {
        return this.sshConfiguration;
    }

    public void setSshConfiguration(SshConfigurationDTO sshConfiguration) {
        this.sshConfiguration = sshConfiguration;
    }

    public List<SshHostConfigurationDTO> getSshHosts() {
        if (this.sshConfiguration != null) {
            return this.sshConfiguration.getHosts();
        }
        return new ArrayList<SshHostConfigurationDTO>();
    }

    public SshHostConfigurationDTO sshHost(String hostName) {
        List<SshHostConfigurationDTO> hosts;
        SshConfigurationDTO config = this.getSshConfiguration();
        if (config == null) {
            config = new SshConfigurationDTO();
            this.setSshConfiguration(config);
        }
        if ((hosts = config.getHosts()) == null) {
            hosts = new ArrayList<SshHostConfigurationDTO>();
            config.setHosts(hosts);
        }
        return config.host(hostName);
    }

    public ProfileRequirementsDTO profile(String profileId) {
        return this.getOrCreateProfileRequirement(profileId);
    }

    public SshConfigurationDTO sshConfiguration() {
        SshConfigurationDTO answer = this.getSshConfiguration();
        if (answer == null) {
            answer = new SshConfigurationDTO();
            this.setSshConfiguration(answer);
        }
        return answer;
    }

    public ProfileRequirementsDTO findProfileRequirements(String profileId) {
        return this.profileRequirements.get(profileId);
    }

    public void removeProfileRequirements(String profileId) {
        if (this.profileRequirements.containsKey(profileId)) {
            this.profileRequirements.remove(profileId);
        }
    }

    public ProfileRequirementsDTO getOrCreateProfileRequirement(String profileId) {
        if (!this.profileRequirements.containsKey(profileId)) {
            this.profileRequirements.put(profileId, ProfileRequirementsDTO.createEmpty(this.fabric8, profileId));
        }
        return this.profileRequirements.get(profileId);
    }

    public void addOrUpdateProfileRequirements(ProfileRequirementsDTO profileReqs) {
        if (this.profileRequirements.containsKey(profileReqs.getProfile())) {
            ProfileRequirementsDTO toBeUpdated = this.findProfileRequirements(profileReqs.getProfile());
            toBeUpdated.setDependentProfiles(profileReqs.getDependentProfiles());
            toBeUpdated.setMinimumInstances(profileReqs.getMinimumInstances());
            toBeUpdated.setMaximumInstances(profileReqs.getMaximumInstances());
        } else {
            this.profileRequirements.put(profileReqs.getProfile(), profileReqs);
        }
    }

    public ModelNode toJSon() {
        ModelNode root = new ModelNode();
        root.get(JSON_VERSION).set((String)this.getFieldValue(JSON_VERSION));
        ModelNode listNode = root.get(JSON_PROFILE_REQS).setEmptyList();
        for (ProfileRequirementsDTO pr : this.profileRequirements.values()) {
            listNode.add(pr.toJson());
        }
        return root;
    }

    public static RequirementsDTO fromJson(Fabric8Facade fabricFacade, ModelNode rootNode) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String version = JsonHelper.getAsString(rootNode, JSON_VERSION);
        if (version != null) {
            data.put(JSON_VERSION, version);
        }
        List<ModelNode> depProfsNodes = JsonHelper.getAsList(rootNode, JSON_PROFILE_REQS);
        RequirementsDTO requirements = new RequirementsDTO(fabricFacade, data);
        for (ModelNode n : depProfsNodes) {
            Map<String, Object> map = JsonHelper.getAsMap(n);
            ProfileRequirementsDTO profReq = new ProfileRequirementsDTO(fabricFacade, map);
            requirements.addProfileRequirement(profReq);
        }
        return requirements;
    }

    public static RequirementsDTO fromJson(Fabric8Facade fabricFacade, List<ModelNode> nodes) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        RequirementsDTO ro = new RequirementsDTO(fabricFacade, data);
        for (ModelNode mn : nodes) {
            if (!mn.getType().equals((Object)ModelType.PROPERTY)) continue;
            Property p = mn.asProperty();
            if (p.getName().equalsIgnoreCase(JSON_VERSION)) {
                ro.getJsonAttributes().put(JSON_VERSION, p.getValue().asString());
                continue;
            }
            List<ModelNode> nl = JsonHelper.getAsList(mn, p.getName());
            for (ModelNode n : nl) {
                ProfileRequirementsDTO profReq = ProfileRequirementsDTO.fromJson(fabricFacade, n);
                ro.addProfileRequirement(profReq);
            }
        }
        return ro;
    }
}

