/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileRequirementsDTO;
import org.fusesource.ide.fabric8.core.dto.RequirementsDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;

public class ProfileStatusDTO
extends BaseDTO {
    private static final String JSON_PROFILE_ID = "profile";
    private static final String JSON_MIN_INSTANCES = "minimumInstances";
    private static final String JSON_MAX_INSTANCES = "maximumInstances";
    private static final String JSON_COUNT = "count";
    private static final String JSON_DEP_PROFILES = "dependentProfiles";
    private static final String JSON_HEALTH = "health";
    private ProfileRequirementsDTO reqs;

    public ProfileStatusDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    @Override
    public void update() {
    }

    @Override
    public void create() {
    }

    @Override
    public void delete() {
    }

    public String getProfile() {
        return (String)this.getFieldValue(JSON_PROFILE_ID);
    }

    public BigInteger getMinimumInstances() {
        return (BigInteger)this.getFieldValue(JSON_MIN_INSTANCES);
    }

    public BigInteger getMaximumInstances() {
        return (BigInteger)this.getFieldValue(JSON_MAX_INSTANCES);
    }

    public BigInteger getCount() {
        return (BigInteger)this.getFieldValue(JSON_COUNT);
    }

    public List<String> getDependentProfiles() {
        return (List)this.getFieldValue(JSON_DEP_PROFILES);
    }

    public BigDecimal getHealth(BigInteger count) {
        return (BigDecimal)this.getFieldValue(JSON_HEALTH);
    }

    public synchronized ProfileRequirementsDTO getRequirements() {
        if (this.reqs == null) {
            RequirementsDTO r = this.fabric8.getRequirements();
            this.reqs = r.findProfileRequirements(this.getProfile());
        }
        return this.reqs;
    }

    public static ProfileStatusDTO fromJson(Fabric8Facade fabricFacade, ModelNode root) {
        String profileId = (String)root.keys().iterator().next();
        Map<String, Object> vals = JsonHelper.getAsMap(root.get(profileId));
        ProfileStatusDTO ps = new ProfileStatusDTO(fabricFacade, vals);
        return ps;
    }
}

