/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.core.dto.CreateContainerMetadataDTO;
import org.jboss.dmr.ModelNode;

public class CreateContainerOptionsDTO<T extends CreateContainerOptionsDTO> {
    private static final String JSON_ZK_SERVER_PORT = "zooKeeperServerPort";
    private static final String JSON_ZK_SERVER_CONNECTION_PORT = "zooKeeperServerConnectionPort";
    private static final String JSON_ZK_SERVER_TICK = "zooKeeperServerTickTime";
    private static final String JSON_ZK_SERVER_INIT_LIMIT = "zooKeeperServerInitLimit";
    private static final String JSON_ZK_SERVER_SYNC_LIMIT = "zooKeeperServerSyncLimit";
    private static final String JSON_ZK_SERVER_DATA_DIR = "zooKeeperServerDataDir";
    private static final String JSON_ZK_PASSWORD = "zookeeperPassword";
    private static final String JSON_ENSEMBLE_START = "ensembleStart";
    private static final String JSON_AGENT_ENABLED = "agentEnabled";
    private static final String JSON_WAIT_FOR_PROVISION = "waitForProvision";
    private static final String JSON_BOOTSTRAP_TIMEOUT = "bootstrapTimeout";
    private static final String JSON_MIGRATION_TIMEOUT = "migrationTimeout";
    private static final String JSON_AUTO_IMPORT_ENABLED = "autoImportEnabled";
    private static final String JSON_IMPORT_PATH = "importPath";
    private static final String JSON_CLEAN = "clean";
    private static final String JSON_USERS = "users";
    private static final String JSON_JMX_USER = "jmxUser";
    private static final String JSON_JMX_PASSWORD = "jmxPassword";
    private static final String JSON_NAME = "name";
    private static final String JSON_PARENT = "parent";
    private static final String JSON_PROVIDER_TYPE = "providerType";
    private static final String JSON_ENSEMBLE_SERVER = "ensembleServer";
    private static final String JSON_PREFERRED_ADDRESS = "preferredAddress";
    private static final String JSON_NUMBER = "number";
    private static final String JSON_PROXY_URI = "proxyUri";
    private static final String JSON_ZK_URL = "zookeeperUrl";
    private static final String JSON_JVM_OPTS = "jvmOpts";
    private static final String JSON_ADMIN_ACCESS = "adminAccess";
    private static final String JSON_SYSTEM_PROPERTIES = "systemProperties";
    private static final String JSON_META_DATA_MAP = "metadataMap";
    private static final String JSON_BIND_ADDRESS = "bindAddress";
    private static final String JSON_RESOLVER = "resolver";
    private static final String JSON_GLOBAL_RESOLVER = "globalResolver";
    private static final String JSON_MANUAL_IP = "manualIp";
    private static final String JSON_MIN_PORT = "minimumPort";
    private static final String JSON_MAX_PORT = "maximumPort";
    private static final String JSON_VERSION = "version";
    private static final String JSON_PROFILES = "profiles";
    private static final String JSON_DATA_STORE_PROPS = "dataStoreProperties";
    public static final String AGENT_AUTOSTART = "agent.auto.start";
    public static final String ENSEMBLE_AUTOSTART = "ensemble.auto.start";
    public static final String PROFILES_AUTOIMPORT = "profiles.auto.import";
    public static final String PROFILES_AUTOIMPORT_PATH = "profiles.auto.import.path";
    public static final String DEFAULT_IMPORT_PATH = "fabric" + File.separatorChar + "import";
    public static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    public static final String ZOOKEEPER_SERVER_PORT = "zookeeper.server.port";
    public static final String ZOOKEEPER_SERVER_CONNECTION_PORT = "zookeeper.server.connection.port";
    public static final String ROLE_DELIMITER = ",";
    public static final long DEFAULT_MIGRATION_TIMEOUT = 120000L;
    public static final int DEFAULT_TICKTIME = 2000;
    public static final int DEFAULT_INIT_LIMIT = 10;
    public static final int DEFAULT_SYNC_LIMIT = 5;
    public static final String DEFAULT_DATA_DIR = "data/zookeeper";
    public static final String BIND_ADDRESS = "bind.address";
    public static final String PROFILES = "profiles";
    public static final String VERSION = "version";
    public static final String DEFAULT_VERSION = "1.0";
    private BigInteger zooKeeperServerPort;
    private BigInteger zooKeeperServerConnectionPort;
    private BigInteger zooKeeperServerTickTime;
    private BigInteger zooKeeperServerInitLimit;
    private BigInteger zooKeeperServerSyncLimit;
    private String zooKeeperServerDataDir;
    private String zookeeperPassword;
    private Boolean ensembleStart;
    private Boolean agentEnabled;
    private Boolean waitForProvision;
    private Long bootstrapTimeout;
    private Long migrationTimeout;
    private Boolean autoImportEnabled;
    private String importPath;
    private Boolean clean;
    private Map<String, String> users;
    private String jmxUser;
    private String jmxPassword;
    private String name;
    private String parent;
    private String providerType;
    private Boolean ensembleServer;
    private String preferredAddress;
    private Integer number;
    private URI proxyUri;
    private String zookeeperUrl;
    private String jvmOpts;
    private Boolean adminAccess;
    private Map<String, Properties> systemProperties;
    private Map<String, CreateContainerMetadataDTO> metadataMap = new HashMap<String, CreateContainerMetadataDTO>();
    private String bindAddress;
    private String resolver;
    private String globalResolver;
    private String manualIp;
    private BigInteger minimumPort;
    private BigInteger maximumPort;
    private String version;
    private Set<String> profiles;
    private Map<String, String> dataStoreProperties;

    public CreateContainerOptionsDTO(String bindAddress, String resolver, String globalResolver, String manualIp, BigInteger minimumPort, BigInteger maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, BigInteger getZooKeeperServerPort, BigInteger zooKeeperServerConnectionPort, String zookeeperPassword, Boolean ensembleStart, Boolean agentEnabled, Boolean waitForProvision, Long provisionTimeout, Boolean autoImportEnabled, String importPath, Map<String, String> users, String name, String parent, String providerType, Boolean ensembleServer, String preferredAddress, Map<String, Properties> systemProperties, Integer number, URI proxyUri, String zookeeperUrl, String jvmOpts, Boolean adminAccess, Boolean clean, String jmxUser, String jmxPassword) {
        this.bindAddress = bindAddress;
        this.resolver = resolver;
        this.globalResolver = globalResolver;
        this.manualIp = manualIp;
        this.minimumPort = minimumPort;
        this.maximumPort = maximumPort;
        this.version = version;
        this.profiles = profiles;
        this.dataStoreProperties = dataStoreProperties != null ? dataStoreProperties : Collections.emptyMap();
        this.zooKeeperServerPort = getZooKeeperServerPort;
        this.zooKeeperServerConnectionPort = zooKeeperServerConnectionPort;
        this.zooKeeperServerTickTime = BigInteger.valueOf(2000L);
        this.zooKeeperServerInitLimit = BigInteger.valueOf(10L);
        this.zooKeeperServerSyncLimit = BigInteger.valueOf(5L);
        this.zooKeeperServerDataDir = DEFAULT_DATA_DIR;
        this.zookeeperPassword = zookeeperPassword;
        this.ensembleStart = ensembleStart;
        this.agentEnabled = agentEnabled;
        this.waitForProvision = waitForProvision;
        this.bootstrapTimeout = provisionTimeout;
        this.migrationTimeout = 120000L;
        this.autoImportEnabled = autoImportEnabled;
        this.importPath = importPath;
        this.users = users != null ? Collections.unmodifiableMap(new HashMap<String, String>(users)) : new HashMap<String, String>();
        this.clean = clean;
        this.name = name;
        this.parent = parent;
        this.providerType = providerType;
        this.ensembleServer = ensembleServer;
        this.preferredAddress = preferredAddress;
        this.number = number;
        this.proxyUri = proxyUri;
        this.zookeeperUrl = zookeeperUrl;
        this.jvmOpts = jvmOpts;
        this.adminAccess = adminAccess;
        this.systemProperties = systemProperties;
        this.jmxUser = jmxUser;
        this.jmxPassword = jmxPassword;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public Boolean isEnsembleServer() {
        return this.ensembleServer;
    }

    public String getPreferredAddress() {
        return this.preferredAddress;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getResolver() {
        return this.resolver;
    }

    public String getManualIp() {
        return this.manualIp;
    }

    public BigInteger getMinimumPort() {
        return this.minimumPort;
    }

    public BigInteger getMaximumPort() {
        return this.maximumPort;
    }

    public Map<String, Properties> getSystemProperties() {
        return this.systemProperties;
    }

    public Integer getNumber() {
        return this.number;
    }

    public URI getProxyUri() {
        return this.proxyUri;
    }

    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    public String getJvmOpts() {
        return this.jvmOpts;
    }

    public Boolean isAdminAccess() {
        return this.adminAccess;
    }

    public Map<String, CreateContainerMetadataDTO> getMetadataMap() {
        return this.metadataMap;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public String getJmxUser() {
        return this.jmxUser;
    }

    public String getJmxPassword() {
        return this.jmxPassword;
    }

    public BigInteger getZooKeeperServerPort() {
        return this.zooKeeperServerPort;
    }

    public BigInteger getZooKeeperServerConnectionPort() {
        return this.zooKeeperServerConnectionPort;
    }

    public Boolean getEnsembleStart() {
        return this.ensembleStart;
    }

    public Boolean getAgentEnabled() {
        return this.agentEnabled;
    }

    public Boolean getWaitForProvision() {
        return this.waitForProvision;
    }

    public Long getBootstrapTimeout() {
        return this.bootstrapTimeout;
    }

    public Boolean getAutoImportEnabled() {
        return this.autoImportEnabled;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public Boolean getClean() {
        return this.clean;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public Boolean getEnsembleServer() {
        return this.ensembleServer;
    }

    public String getGlobalResolver() {
        return this.globalResolver;
    }

    public Map<String, String> getDataStoreProperties() {
        return this.dataStoreProperties;
    }

    public String getZooKeeperServerDataDir() {
        return this.zooKeeperServerDataDir;
    }

    public BigInteger getZooKeeperServerTickTime() {
        return this.zooKeeperServerTickTime;
    }

    public BigInteger getZooKeeperServerInitLimit() {
        return this.zooKeeperServerInitLimit;
    }

    public BigInteger getZooKeeperServerSyncLimit() {
        return this.zooKeeperServerSyncLimit;
    }

    public Long getMigrationTimeout() {
        return this.migrationTimeout;
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public CreateContainerOptionsDTO updateCredentials(String newJmxUser, String newJmxPassword) {
        return new CreateContainerOptionsDTO<T>(this.bindAddress, this.resolver, this.globalResolver, this.manualIp, this.minimumPort, this.maximumPort, this.profiles, this.version, this.dataStoreProperties, this.zooKeeperServerPort, this.zooKeeperServerConnectionPort, this.zookeeperPassword, this.ensembleStart, this.agentEnabled, this.waitForProvision, this.bootstrapTimeout, this.autoImportEnabled, this.importPath, this.users, this.name, this.parent, "child", this.ensembleServer, this.preferredAddress, this.systemProperties, this.number, this.proxyUri, this.zookeeperUrl, this.jvmOpts, this.adminAccess, this.clean, newJmxUser != null ? newJmxUser : this.jmxUser, newJmxPassword != null ? newJmxPassword : this.jmxPassword);
    }

    public static Builder<? extends Builder<?>> builder() {
        return new Builder();
    }

    public ModelNode toJson() {
        ModelNode root = new ModelNode();
        if (!Strings.isBlank((String)this.getName())) {
            root.get(JSON_NAME).set(this.getName());
        }
        if (!Strings.isBlank((String)this.getParent())) {
            root.get(JSON_PARENT).set(this.getParent());
        }
        if (!Strings.isBlank((String)this.getVersion())) {
            root.get("version").set(this.getVersion());
        }
        if (!Strings.isBlank((String)this.getZookeeperUrl())) {
            root.get(JSON_ZK_URL).set(this.getZookeeperUrl());
        }
        if (!Strings.isBlank((String)this.getZookeeperPassword())) {
            root.get(JSON_ZK_PASSWORD).set(this.getZookeeperPassword());
        }
        if (!Strings.isBlank((String)this.getJmxUser())) {
            root.get(JSON_JMX_USER).set(this.getJmxUser());
        }
        if (!Strings.isBlank((String)this.getJmxPassword())) {
            root.get(JSON_JMX_PASSWORD).set(this.getJmxPassword());
        }
        if (this.getProxyUri() != null) {
            root.get(JSON_PROXY_URI).set(this.getProxyUri().toString());
        }
        if (this.getZooKeeperServerTickTime() != null) {
            root.get(JSON_ZK_SERVER_TICK).set(this.getZooKeeperServerTickTime());
        }
        if (this.getZooKeeperServerInitLimit() != null) {
            root.get(JSON_ZK_SERVER_INIT_LIMIT).set(this.getZooKeeperServerInitLimit());
        }
        if (this.getZooKeeperServerSyncLimit() != null) {
            root.get(JSON_ZK_SERVER_SYNC_LIMIT).set(this.getZooKeeperServerSyncLimit());
        }
        if (!Strings.isBlank((String)this.getZooKeeperServerDataDir())) {
            root.get(JSON_ZK_SERVER_DATA_DIR).set(this.getZooKeeperServerDataDir());
        }
        if (this.getMigrationTimeout() != null) {
            root.get(JSON_MIGRATION_TIMEOUT).set(this.getMigrationTimeout().longValue());
        }
        if (!Strings.isBlank((String)this.getProviderType())) {
            root.get(JSON_PROVIDER_TYPE).set(this.getProviderType());
        }
        if (this.getAdminAccess() != null) {
            root.get(JSON_ADMIN_ACCESS).set(this.getAdminAccess().booleanValue());
        }
        ModelNode listNode = root.get("profiles").setEmptyList();
        for (String entry : this.getProfiles()) {
            listNode.add(entry);
        }
        return root;
    }

    public Map<String, Object> asMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo info = Introspector.getBeanInfo(this.getClass());
        PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object val;
            Method reader;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (!pd.getName().equalsIgnoreCase("class") && (reader = pd.getReadMethod()) != null && (val = reader.invoke((Object)this, new Object[0])) != null) {
                map.put(pd.getName(), val);
            }
            ++n2;
        }
        return map;
    }

    public static class Builder<B extends Builder<?>> {
        private BigInteger zooKeeperServerPort;
        private BigInteger zooKeeperServerConnectionPort;
        private BigInteger zooKeeperServerTickTime;
        private BigInteger zooKeeperServerInitLimit;
        private BigInteger zooKeeperServerSyncLimit;
        private String zooKeeperServerDataDir;
        private String zookeeperPassword;
        private Boolean ensembleStart;
        private Boolean agentEnabled;
        private Boolean waitForProvision;
        private Long bootstrapTimeout;
        private Long migrationTimeout;
        private Boolean autoImportEnabled;
        private String importPath;
        private Boolean clean;
        private Map<String, String> users;
        private String jmxUser;
        private String jmxPassword;
        private String name;
        private String parent;
        private String providerType;
        private Boolean ensembleServer;
        private String preferredAddress;
        private Integer number;
        private URI proxyUri;
        private String zookeeperUrl;
        private String jvmOpts;
        private Boolean adminAccess;
        private Map<String, Properties> systemProperties;
        private Map<String, CreateContainerMetadataDTO> metadataMap = new HashMap<String, CreateContainerMetadataDTO>();
        private String bindAddress;
        private String resolver;
        private String globalResolver;
        private String manualIp;
        private BigInteger minimumPort;
        private BigInteger maximumPort;
        private String version;
        private Set<String> profiles;
        private Map<String, String> dataStoreProperties;

        public BigInteger getZooKeeperServerConnectionPort() {
            return this.zooKeeperServerConnectionPort;
        }

        public BigInteger getZooKeeperServerTickTime() {
            return this.zooKeeperServerTickTime;
        }

        public BigInteger getZooKeeperServerInitLimit() {
            return this.zooKeeperServerInitLimit;
        }

        public BigInteger getZooKeeperServerSyncLimit() {
            return this.zooKeeperServerSyncLimit;
        }

        public String getZooKeeperServerDataDir() {
            return this.zooKeeperServerDataDir;
        }

        public Boolean getEnsembleStart() {
            return this.ensembleStart;
        }

        public Boolean getAgentEnabled() {
            return this.agentEnabled;
        }

        public Boolean getWaitForProvision() {
            return this.waitForProvision;
        }

        public Long getBootstrapTimeout() {
            return this.bootstrapTimeout;
        }

        public Long getMigrationTimeout() {
            return this.migrationTimeout;
        }

        public Boolean getAutoImportEnabled() {
            return this.autoImportEnabled;
        }

        public String getImportPath() {
            return this.importPath;
        }

        public Boolean getClean() {
            return this.clean;
        }

        public Map<String, String> getUsers() {
            return this.users;
        }

        public Boolean getEnsembleServer() {
            return this.ensembleServer;
        }

        public Boolean getAdminAccess() {
            return this.adminAccess;
        }

        public String getBindAddress() {
            return this.bindAddress;
        }

        public String getResolver() {
            return this.resolver;
        }

        public String getGlobalResolver() {
            return this.globalResolver;
        }

        public String getManualIp() {
            return this.manualIp;
        }

        public BigInteger getMinimumPort() {
            return this.minimumPort;
        }

        public BigInteger getMaximumPort() {
            return this.maximumPort;
        }

        public Map<String, String> getDataStoreProperties() {
            return this.dataStoreProperties;
        }

        public B preferredAddress(String preferredAddress) {
            this.preferredAddress = preferredAddress;
            return (B)this;
        }

        public B ensembleServer(boolean ensembleServer) {
            this.ensembleServer = ensembleServer;
            return (B)this;
        }

        public B number(int number) {
            this.number = number;
            return (B)this;
        }

        public B name(String name) {
            this.name = name;
            return (B)this;
        }

        public B parent(String parent) {
            this.parent = parent;
            return (B)this;
        }

        public B providerType(String providerType) {
            this.providerType = providerType;
            return (B)this;
        }

        public B zookeeperUrl(String zookeeperUrl) {
            this.zookeeperUrl = zookeeperUrl;
            return (B)this;
        }

        public B proxyUri(URI proxyUri) {
            this.proxyUri = proxyUri;
            return (B)this;
        }

        public B proxyUri(String proxyUri) throws URISyntaxException {
            this.proxyUri = new URI(proxyUri);
            return (B)this;
        }

        public B jvmOpts(String jvmOpts) {
            this.jvmOpts = jvmOpts;
            return (B)this;
        }

        public B adminAccess(boolean adminAccess) {
            this.adminAccess = adminAccess;
            return (B)this;
        }

        public String getName() {
            return this.name;
        }

        public String getParent() {
            return this.parent;
        }

        public String getProviderType() {
            return this.providerType;
        }

        public Boolean isEnsembleServer() {
            return this.ensembleServer;
        }

        public String getPreferredAddress() {
            return this.preferredAddress;
        }

        public Map<String, Properties> getSystemProperties() {
            return this.systemProperties;
        }

        public Integer getNumber() {
            return this.number;
        }

        public URI getProxyUri() {
            return this.proxyUri;
        }

        public String getZookeeperUrl() {
            return this.zookeeperUrl;
        }

        public String getJvmOpts() {
            return this.jvmOpts;
        }

        public Boolean isAdminAccess() {
            return this.adminAccess;
        }

        public Map<String, CreateContainerMetadataDTO> getMetadataMap() {
            return this.metadataMap;
        }

        public B jmxUser(String jmxUser) {
            this.jmxUser = jmxUser;
            return (B)this;
        }

        public B jmxPassword(String jmxPassword) {
            this.jmxPassword = jmxPassword;
            return (B)this;
        }

        public String getJmxUser() {
            return this.jmxUser;
        }

        public String getJmxPassword() {
            return this.jmxPassword;
        }

        public BigInteger getZooKeeperServerPort() {
            return this.zooKeeperServerPort;
        }

        public B version(String version) {
            this.version = version;
            return (B)this;
        }

        public String getVersion() {
            return this.version;
        }

        public B profiles(Set<String> profiles) {
            this.profiles = profiles;
            return (B)this;
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public String getZookeeperPassword() {
            return this.zookeeperPassword;
        }

        public B zookeeperPassword(String password) {
            this.zookeeperPassword = password;
            return (B)this;
        }

        public B resolver(String resolver) {
            this.resolver = resolver;
            return (B)this;
        }

        public CreateContainerOptionsDTO build() {
            return new CreateContainerOptionsDTO(this.bindAddress, this.resolver, this.globalResolver, this.manualIp, this.minimumPort, this.maximumPort, this.profiles, this.version, this.dataStoreProperties, this.zooKeeperServerPort, this.zooKeeperServerConnectionPort, this.zookeeperPassword, this.ensembleStart, this.agentEnabled, this.waitForProvision, this.bootstrapTimeout, this.autoImportEnabled, this.importPath, this.users, this.name, this.parent, "child", this.ensembleServer, this.preferredAddress, this.systemProperties, this.number, this.proxyUri, this.zookeeperUrl, this.jvmOpts, true, this.clean, this.jmxUser, this.jmxPassword);
        }
    }
}

