/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.connector;

import io.fabric8.api.CreateContainerOptions;
import io.fabric8.insight.log.LogFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.Fabric8CorePlugin;
import org.fusesource.ide.fabric8.core.connector.Fabric8ConnectorType;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.connector.JolokiaHelpers;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerMetadataDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerOptionsDTO;
import org.fusesource.ide.fabric8.core.dto.FabricStatusDTO;
import org.fusesource.ide.fabric8.core.dto.LogResultsDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.RequirementsDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pWriteRequest;

public class JolokiaFabric8Connector
implements Fabric8ConnectorType {
    private static final String FABRIC_MBEAN_URL = "io.fabric8:type=Fabric";
    private static final String PROFILEMGMT_MBEAN_URL = "io.fabric8:type=ProfileManagement";
    private static final String INSIGHT_MBEAN_URL = "io.fabric8.insight:type=LogQuery";
    private J4pClient j4p;
    private String userName;
    private String password;
    private String url;
    private Fabric8Facade fabricFacade;

    public static JolokiaFabric8Connector getFabric8Connector(String user, String password, String url) {
        JolokiaFabric8Connector rc = new JolokiaFabric8Connector();
        rc.setUserName(user);
        rc.setPassword(password);
        rc.setUrl(url);
        return rc;
    }

    @Override
    public void connect() throws IOException {
        if (this.j4p != null || this.fabricFacade != null) {
            this.disconnect();
        }
        this.j4p = J4pClient.url((String)this.url).user(this.userName).password(this.password).build();
        this.fabricFacade = new Fabric8Facade(this);
    }

    @Override
    public void disconnect() {
        if (this.j4p != null) {
            this.j4p = null;
        }
        if (this.fabricFacade != null) {
            this.fabricFacade = null;
        }
    }

    @Override
    public boolean isConnected() {
        if (this.fabricFacade != null) {
            List<ContainerDTO> containers = this.fabricFacade.getContainers();
            return containers != null && !containers.isEmpty();
        }
        return false;
    }

    @Override
    public Fabric8Facade getFabricFacade() {
        return this.fabricFacade;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public J4pClient getJolokiaClient() {
        return this.j4p;
    }

    public <T> T read(String attribute) {
        try {
            J4pReadRequest request = JolokiaHelpers.createReadRequest(FABRIC_MBEAN_URL, attribute);
            J4pReadResponse response = (J4pReadResponse)this.j4p.execute((J4pRequest)request);
            return (T)response.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read " + attribute, e);
        }
    }

    @Override
    public List<ContainerDTO> getContainers() {
        ArrayList<ContainerDTO> containers = new ArrayList<ContainerDTO>();
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "containers()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            List values = (List)response.getValue();
            for (Map value : values) {
                containers.add(new ContainerDTO(this.fabricFacade, value));
            }
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch containers from fabric8.", (Throwable)e);
        }
        return containers;
    }

    @Override
    public ContainerDTO getContainer(String containerId) {
        ContainerDTO container = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "getContainer(java.lang.String)", containerId);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            container = new ContainerDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch container with ID '" + containerId + "' from fabric8.", (Throwable)e);
        }
        return container;
    }

    @Override
    public ContainerDTO getCurrentContainer() {
        ContainerDTO container = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "currentContainer()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            container = new ContainerDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch current container from fabric8.", (Throwable)e);
        }
        return container;
    }

    @Override
    public void startContainer(String containerId) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "startContainer(java.lang.String)", containerId);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to start container with id '" + containerId + "'.", (Throwable)e);
        }
    }

    @Override
    public void stopContainer(String containerId) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "stopContainer(java.lang.String)", containerId);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to stop container with id '" + containerId + "'.", (Throwable)e);
        }
    }

    @Override
    public void destroyContainer(String containerId) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "destroyContainer(java.lang.String)", containerId);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to destroy container with id '" + containerId + "'.", (Throwable)e);
        }
    }

    @Override
    public VersionDTO createVersion(String versionId) {
        VersionDTO version = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "createVersion()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            version = new VersionDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to create version with id '" + versionId + "'.", (Throwable)e);
        }
        return version;
    }

    @Override
    public void deleteVersion(String versionId) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "deleteVersion(java.lang.String)", versionId);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to delete version with id '" + versionId + "'.", (Throwable)e);
        }
    }

    @Override
    public List<VersionDTO> getVersions() {
        ArrayList<VersionDTO> versions = new ArrayList<VersionDTO>();
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "versions()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            List values = (List)response.getValue();
            for (Map value : values) {
                VersionDTO v = new VersionDTO(this.fabricFacade, value);
                if (v.getId().equalsIgnoreCase("master")) continue;
                versions.add(new VersionDTO(this.fabricFacade, value));
            }
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch containers from fabric8.", (Throwable)e);
        }
        return versions;
    }

    @Override
    public String getGitUrl() {
        String gitUrl = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "gitUrl()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            gitUrl = (String)response.getValue();
        }
        catch (Exception ex) {
            if (ex instanceof J4pRemoteException && ((J4pRemoteException)ex).getErrorType().equalsIgnoreCase("javax.management.InstanceNotFoundException")) {
                Fabric8CorePlugin.getLogger().error("The Fabric8 runtime is not compatible with this tooling version.", (Throwable)ex);
            }
            Fabric8CorePlugin.getLogger().error("Failed to fetch git url from fabric8.", (Throwable)ex);
        }
        return gitUrl;
    }

    @Override
    public String getMavenProxyDownloadUrl() {
        String url = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "mavenProxyDownloadUrl()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            url = (String)response.getValue();
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch maven proxy download url from fabric8.", (Throwable)e);
        }
        return url;
    }

    @Override
    public String getMavenProxyUploadUrl() {
        String url = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "mavenProxyUploadUrl()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            url = (String)response.getValue();
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch maven proxy upload url from fabric8.", (Throwable)e);
        }
        return url;
    }

    @Override
    public String getWebUrl() {
        String url = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "webConsoleUrl()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            url = (String)response.getValue();
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch web console url from fabric8.", (Throwable)e);
        }
        return url;
    }

    @Override
    public List<ProfileDTO> getProfiles(String versionId) {
        ArrayList<ProfileDTO> profiles = new ArrayList<ProfileDTO>();
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "getProfiles(java.lang.String)", versionId);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            List values = (List)response.getValue();
            for (Map value : values) {
                ProfileDTO p = new ProfileDTO(this.fabricFacade, value);
                if (p.isHidden().booleanValue()) continue;
                profiles.add(p);
            }
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch containers from fabric8.", (Throwable)e);
        }
        return profiles;
    }

    @Override
    public ProfileDTO getProfile(String versionId, String profileId) {
        ProfileDTO profile = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "getProfile(java.lang.String, java.lang.String)", versionId, profileId);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            profile = new ProfileDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch profile with id '" + profileId + "' and version id '" + versionId + "'.", (Throwable)e);
        }
        return profile;
    }

    @Override
    public ProfileDTO createProfile(String versionId, String profileId) {
        ProfileDTO profile = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "createProfile(java.lang.String, java.lang.String)", versionId, profileId);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            profile = new ProfileDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to create profile with id '" + profileId + "' and version id '" + versionId + "'.", (Throwable)e);
        }
        return profile;
    }

    @Override
    public void deleteProfile(String versionId, String profileId) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "deleteProfile(java.lang.String, java.lang.String)", versionId, profileId);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to delete profile with id '" + profileId + "' and version id '" + versionId + "'.", (Throwable)e);
        }
    }

    @Override
    public VersionDTO createVersion(String parentVersionId, String versionId) {
        VersionDTO version = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "createVersion(java.lang.String, java.lang.String)", parentVersionId, versionId);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            version = new VersionDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to create subversion with id '" + versionId + "' under version '" + parentVersionId + "'.", (Throwable)e);
        }
        return version;
    }

    @Override
    public VersionDTO getDefaultVersion() {
        VersionDTO version = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "defaultVersion()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            Map values = (Map)response.getValue();
            version = new VersionDTO(this.fabricFacade, values);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch current container from fabric8.", (Throwable)e);
        }
        return version;
    }

    @Override
    public void setDefaultVersion(String versionId) {
        try {
            J4pWriteRequest request = JolokiaHelpers.createWriteRequest(FABRIC_MBEAN_URL, "DefaultVersion", versionId);
            this.j4p.execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set default version for container to '" + versionId + "'.", (Throwable)e);
        }
    }

    @Override
    public void setVersionForContainer(String containerId, String versionId) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "applyVersionToContainers(java.lang.String, java.util.List)", versionId, JolokiaHelpers.toList(containerId));
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set version of container '" + containerId + "' to '" + versionId + "'", (Throwable)e);
        }
    }

    @Override
    public void addProfilesToContainer(String containerId, String ... profileIds) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "addProfilesToContainer(java.lang.String, java.util.List)", containerId, profileIds);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to add profiles to container '" + containerId + "'", (Throwable)e);
        }
    }

    @Override
    public void removeProfilesFromContainer(String containerId, String ... profileIds) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "removeProfilesFromContainer(java.lang.String, java.util.List)", containerId, profileIds);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to remove profiles from container '" + containerId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfilesForContainer(String containerId, String versionId, List<String> profileIds) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "applyProfilesToContainers(java.lang.String, java.util.List, java.util.List)", versionId, profileIds, JolokiaHelpers.toList(containerId));
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set profiles for container '" + containerId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileBundles(String versionId, String profileId, List<String> bundles) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "setProfileBundles(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, bundles);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set bundles for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileFabs(String versionId, String profileId, List<String> fabs) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "setProfileFabs(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, fabs);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set fabs for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileFeatures(String versionId, String profileId, List<String> features) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "setProfileFeatures(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, features);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set features for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileOptionals(String versionId, String profileId, List<String> optionals) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "setProfileOptionals(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, optionals);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set optionals for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileOverrides(String versionId, String profileId, List<String> overrides) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "setProfileOverrides(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, overrides);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set overrides for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileParentIds(String versionId, String profileId, List<String> parentIds) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "changeProfileParents(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, parentIds);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to change parent ids for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public void setProfileRepositories(String versionId, String profileId, List<String> repositories) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "setProfileRepositories(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, repositories);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set repositories for profile '" + profileId + "'", (Throwable)e);
        }
    }

    @Override
    public String getMavenRepoURI() {
        return (String)this.read("MavenRepoURI");
    }

    @Override
    public String getZookeeperUrl() {
        return (String)this.read("ZookeeperUrl");
    }

    @Override
    public RequirementsDTO getRequirements() {
        RequirementsDTO requirements = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "requirementsAsJson()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            String json = (String)response.getValue();
            ModelNode rootNode = JsonHelper.getModelNode(json);
            requirements = RequirementsDTO.fromJson(this.fabricFacade, rootNode);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch requirements", (Throwable)e);
        }
        return requirements;
    }

    @Override
    public void setRequirements(RequirementsDTO requirements) {
        try {
            String json = requirements.toJSon().toJSONString(true);
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "requirementsJson(java.lang.String)", json);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to set requirements", (Throwable)e);
        }
    }

    @Override
    public FabricStatusDTO getFabricStatus() {
        FabricStatusDTO status = null;
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "fabricStatusAsJson()", new Object[0]);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            String json = (String)response.getValue();
            ModelNode rootNode = JsonHelper.getModelNode(json);
            status = FabricStatusDTO.fromJson(this.fabricFacade, rootNode);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to fetch fabric status", (Throwable)e);
        }
        return status;
    }

    @Override
    public CreateContainerMetadataDTO[] createContainers(CreateContainerOptionsDTO options) {
        try {
            Map<String, Object> optionsMap = options.asMap();
            this.doCreateContainer(optionsMap);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to create container", (Throwable)e);
        }
        return new CreateContainerMetadataDTO[0];
    }

    @Override
    public CreateContainerMetadataDTO[] createContainers(CreateContainerOptions options) {
        try {
            Map<String, Object> optionsMap = JsonHelper.asMap(options);
            this.doCreateContainer(optionsMap);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to create container", (Throwable)e);
        }
        return new CreateContainerMetadataDTO[0];
    }

    protected CreateContainerMetadataDTO[] doCreateContainer(Map<String, Object> optionsMap) {
        try {
            J4pExecRequest request = JolokiaHelpers.createExecRequest(FABRIC_MBEAN_URL, "createContainers(java.util.Map)", optionsMap);
            this.getJolokiaClient().execute((J4pRequest)request);
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to create container", (Throwable)e);
        }
        return new CreateContainerMetadataDTO[0];
    }

    @Override
    public LogResultsDTO queryLog(LogFilter filter) {
        try {
            String filterJson = JsonHelper.convertToJson(filter);
            J4pExecRequest request = JolokiaHelpers.createExecRequest(INSIGHT_MBEAN_URL, "filterLogEvents(java.lang.String)", filterJson);
            J4pExecResponse response = (J4pExecResponse)this.getJolokiaClient().execute((J4pRequest)request);
            String json = (String)response.getValue();
            ModelNode rootNode = JsonHelper.getModelNode(json);
            LogResultsDTO result = LogResultsDTO.fromJson(rootNode);
            return result;
        }
        catch (Exception e) {
            Fabric8CorePlugin.getLogger().error("Failed to query the logs", (Throwable)e);
            return null;
        }
    }
}

