/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ddl.importer.ui.DdlImportDifferencesPage;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.wizard.ExportDDLToWorkspaceDialog;
import org.teiid.designer.teiidimporter.ui.wizard.TeiidImportManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class ShowDDLPage
extends AbstractWizardPage
implements UiConstants {
    private final String EMPTY = "";
    private final int GROUP_HEIGHT_190 = 190;
    private Text ddlContentsBox;
    private Button exportDDLToFileSystemButton;
    private Button exportDDLToWorkspaceButton;
    private TeiidImportManager importManager;

    public ShowDDLPage(TeiidImportManager importManager) {
        super(ShowDDLPage.class.getSimpleName(), Messages.ShowDDLPage_title);
        this.importManager = importManager;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        mainPanel.setLayoutData((Object)new GridData());
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        this.createButtonPanel(mainPanel);
        this.createDDLDisplayGroup(mainPanel);
        this.setPageComplete(false);
    }

    private void createDDLDisplayGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.ShowDDLPage_DDLContentsGroup, (int)0, (int)1, (int)1);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 190;
        groupGD.widthHint = 400;
        theGroup.setLayoutData((Object)groupGD);
        this.ddlContentsBox = WidgetFactory.createTextBox((Composite)theGroup);
        this.ddlContentsBox.setEditable(false);
        this.ddlContentsBox.setBackground(Display.getCurrent().getSystemColor(19));
    }

    public void setDDL(String ddlText) {
        this.ddlContentsBox.setText(ddlText);
    }

    public String getDDL() {
        return this.ddlContentsBox.getText();
    }

    private void createButtonPanel(Composite parent) {
        Composite buttonPanel = new Composite(parent, 0);
        buttonPanel.setLayout((Layout)new GridLayout(2, false));
        buttonPanel.setLayoutData((Object)new GridData());
        this.exportDDLToFileSystemButton = new Button(buttonPanel, 8);
        this.exportDDLToFileSystemButton.setText(Messages.ShowDDLPage_exportDDLToFileSystemButton);
        this.exportDDLToFileSystemButton.setToolTipText(Messages.ShowDDLPage_exportDDLToFileSystemButtonTooltip);
        this.exportDDLToFileSystemButton.setLayoutData((Object)new GridData());
        this.exportDDLToFileSystemButton.setEnabled(false);
        this.exportDDLToFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDDLPage.this.handleExportDDLToFileSystem();
            }
        });
        this.exportDDLToWorkspaceButton = new Button(buttonPanel, 8);
        this.exportDDLToWorkspaceButton.setText(Messages.ShowDDLPage_exportDDLToWorkspaceButton);
        this.exportDDLToWorkspaceButton.setToolTipText(Messages.ShowDDLPage_exportDDLToWorkspaceButtonTooltip);
        this.exportDDLToWorkspaceButton.setLayoutData((Object)new GridData());
        this.exportDDLToWorkspaceButton.setEnabled(false);
        this.exportDDLToWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDDLPage.this.handleExportDDLToWorkspace();
            }
        });
    }

    public void handleExportDDLToFileSystem() {
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.*"});
        dlg.setText(Messages.ShowDDLPage_exportDDLDialogTitle);
        dlg.setFileName(Messages.ShowDDLPage_exportDDLDialogDefaultFileName);
        String fileStr = dlg.open();
        this.exportDDLToFile(fileStr);
    }

    private void handleExportDDLToWorkspace() {
        ExportDDLToWorkspaceDialog dialog = new ExportDDLToWorkspaceDialog(this.getShell());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            IContainer targetContainer = dialog.getTargetContainer();
            String fileName = dialog.getFileName();
            this.createDDLFile(targetContainer, fileName);
        }
    }

    private void createDDLFile(final IContainer targetContainer, final String ddlFileName) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        IFile ddlFileToCreate = targetContainer.getFile((IPath)new Path(ddlFileName));
                        String ddl = ShowDDLPage.this.getDDL();
                        ByteArrayInputStream istream = new ByteArrayInputStream(ddl.getBytes());
                        ddlFileToCreate.create((InputStream)istream, false, monitor);
                        targetContainer.refreshLocal(2, monitor);
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, op);
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            ModelerCore.Util.log(4, err, err.getMessage());
            WidgetUtil.showError((String)Messages.ShowDDLPage_exportDDLDialogExportToWorkspaceErrorMsg);
        }
    }

    private void exportDDLToFile(String fileStr) {
        block19: {
            if (fileStr != null && fileStr.indexOf(46) == -1) {
                fileStr = String.valueOf(fileStr) + "." + Messages.ShowDDLPage_exportDDLDialogDefaultFileExt;
            }
            if (fileStr != null) {
                FileWriter fw = null;
                BufferedWriter out = null;
                PrintWriter pw = null;
                try {
                    try {
                        fw = new FileWriter(fileStr);
                        out = new BufferedWriter(fw);
                        pw = new PrintWriter(out);
                        String ddl = this.getDDL();
                        pw.write(ddl);
                    }
                    catch (Exception e) {
                        UTIL.log(4, (Throwable)e, Messages.ShowDDLPage_exportDDLDialogExportErrorMsg);
                        pw.close();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    pw.close();
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                pw.close();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setButtonStates() {
        boolean enableExportButton = this.importManager.isVdbDeployed();
        this.exportDDLToFileSystemButton.setEnabled(enableExportButton);
        this.exportDDLToWorkspaceButton.setEnabled(enableExportButton);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IWizard wizard = this.getWizard();
            IWizardPage differencesPage = wizard.getPage("DdlImportDifferencesPage");
            if (differencesPage instanceof DdlImportDifferencesPage) {
                ((DdlImportDifferencesPage)differencesPage).setPageComplete(false);
            }
            if (this.importManager.isVdbDeployed() && this.importManager.shouldRedeploy()) {
                this.importManager.undeployDynamicVdb();
                this.importManager.deleteDdlTempFile();
                this.importManager.setRedeploy(false);
            }
            if (this.importManager.isVdbDeployed()) {
                String ddl = this.importManager.getDdl();
                if (ddl == null) {
                    ddl = "";
                }
                this.ddlContentsBox.setText(ddl);
            } else {
                IStatus deployStatus = this.importManager.deployDynamicVdb();
                if (deployStatus == null) {
                    this.ddlContentsBox.setText(Messages.ShowDDLPage_vdbDeploymentErrorMsg);
                } else if (!deployStatus.isOK()) {
                    StringBuffer sb = new StringBuffer(deployStatus.getMessage());
                    sb.append("\n\n" + Messages.ShowDDLPage_vdbDeploymentCheckServerLogMsg);
                    this.ddlContentsBox.setText(sb.toString());
                } else {
                    String ddl = this.importManager.getDdl();
                    if (ddl == null) {
                        ddl = Messages.TeiidImportManager_getDdlErrorMsg;
                    }
                    this.ddlContentsBox.setText(ddl);
                    this.ddlContentsBox.setTopIndex(0);
                }
            }
            this.setButtonStates();
            this.validatePage();
            this.getControl().setVisible(visible);
        } else {
            super.setVisible(visible);
        }
    }

    private boolean validatePage() {
        if (!this.importManager.isVdbDeployed()) {
            IStatus deployStatus = this.importManager.getVdbDeploymentStatus();
            String errorMsg = deployStatus != null ? deployStatus.getMessage() : Messages.ShowDDLPage_vdbDeploymentErrorMsg;
            this.setThisPageComplete(errorMsg, 2);
            return false;
        }
        String ddlStr = this.getDDL();
        if (ddlStr == null || ddlStr.trim().equals(Messages.TeiidImportManager_getDdlErrorMsg)) {
            this.setThisPageComplete(Messages.TeiidImportManager_getDdlErrorMsg, 2);
            return false;
        }
        this.setThisPageComplete("", 0);
        return true;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }
}

