/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.DataSourceItem;
import org.teiid.designer.teiidimporter.ui.panels.DataSourceManager;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.wizard.CopyDataSourceDialog;
import org.teiid.designer.teiidimporter.ui.wizard.CreateDataSourceDialog;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;

public final class DataSourcePanel
extends Composite
implements UiConstants {
    private final TableViewerBuilder dataSourcesViewer;
    private ITeiidImportServer teiidImportServer;
    private DataSourceManager dataSourceManager;
    private List<DataSourceItem> dataSourceObjList = new ArrayList<DataSourceItem>();
    private int visibleTableRows = 4;
    private final int GROUP_HEIGHT_160 = 120;
    private List<DataSourcePanelListener> listeners = new ArrayList<DataSourcePanelListener>();
    private Button newSourceButton;
    private Button deleteSourceButton;
    private Button editSourceButton;
    private Button copySourceButton;

    public DataSourcePanel(Composite parent, int visibleTableRows, ITeiidImportServer teiidImportServer) {
        super(parent, 0);
        this.teiidImportServer = teiidImportServer;
        this.visibleTableRows = visibleTableRows;
        this.dataSourceManager = new DataSourceManager(this.teiidImportServer);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.createButtonsPanel(this);
        this.dataSourcesViewer = new TableViewerBuilder((Composite)this, 66304);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dataSourcesViewer.getTableViewer());
        this.dataSourcesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DataSourcePanel.this.getDataSources();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.dataSourcesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                DataSourceItem ds1 = (DataSourceItem)e1;
                DataSourceItem ds2 = (DataSourceItem)e2;
                return super.compare(viewer, (Object)ds1.getName(), (Object)ds2.getName());
            }
        });
        Table table = this.dataSourcesViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn column = this.dataSourcesViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.dataSourcePanel_nameColText);
        column.setLabelProvider((CellLabelProvider)new DataSourceLabelProvider(0));
        column = this.dataSourcesViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.dataSourcePanel_jndiNameColText);
        column.setLabelProvider((CellLabelProvider)new DataSourceLabelProvider(1));
        column = this.dataSourcesViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.dataSourcePanel_typeColText);
        column.setLabelProvider((CellLabelProvider)new DataSourceLabelProvider(2));
        this.dataSourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSourcePanel.this.handleDataSourceSelected(event);
            }
        });
        this.refreshDataSourceList();
        this.dataSourcesViewer.setInput((Object)this);
        this.packTable();
    }

    private void createButtonsPanel(Composite parent) {
        Composite panel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        panel.setLayout((Layout)new GridLayout(1, false));
        GridData groupGD = new GridData();
        groupGD.heightHint = 120;
        panel.setLayoutData((Object)groupGD);
        this.newSourceButton = new Button(panel, 8);
        this.newSourceButton.setText(Messages.dataSourcePanel_newButtonText);
        this.newSourceButton.setToolTipText(Messages.dataSourcePanel_newButtonTooltip);
        this.newSourceButton.setLayoutData((Object)new GridData(768));
        this.newSourceButton.setEnabled(true);
        this.newSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourcePanel.this.handleCreateSource();
            }
        });
        this.deleteSourceButton = new Button(panel, 8);
        this.deleteSourceButton.setText(Messages.dataSourcePanel_deleteButtonText);
        this.deleteSourceButton.setToolTipText(Messages.dataSourcePanel_deleteButtonTooltip);
        this.deleteSourceButton.setLayoutData((Object)new GridData(768));
        this.deleteSourceButton.setEnabled(false);
        this.deleteSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourcePanel.this.handleDeleteSource();
            }
        });
        this.editSourceButton = new Button(panel, 8);
        this.editSourceButton.setText(Messages.dataSourcePanel_editButtonText);
        this.editSourceButton.setToolTipText(Messages.dataSourcePanel_editButtonTooltip);
        this.editSourceButton.setLayoutData((Object)new GridData(768));
        this.editSourceButton.setEnabled(false);
        this.editSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourcePanel.this.handleEditSource();
            }
        });
        this.copySourceButton = new Button(panel, 8);
        this.copySourceButton.setText(Messages.dataSourcePanel_copyButtonText);
        this.copySourceButton.setToolTipText(Messages.dataSourcePanel_copyButtonTooltip);
        this.copySourceButton.setLayoutData((Object)new GridData(768));
        this.copySourceButton.setEnabled(false);
        this.copySourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourcePanel.this.handleCopySource();
            }
        });
    }

    private void setTableSelection(String dsName) {
        int selIndex = 0;
        TableItem[] items = this.dataSourcesViewer.getTable().getItems();
        if (dsName == null && items.length > 0) {
            this.dataSourcesViewer.getTable().select(selIndex);
        } else {
            int i = 0;
            while (i < items.length) {
                String itemName = items[i].getText();
                if (itemName != null && itemName.trim().equals(dsName)) {
                    selIndex = i;
                    break;
                }
                ++i;
            }
            this.dataSourcesViewer.getTable().select(selIndex);
        }
    }

    private void handleCreateSource() {
        CreateDataSourceDialog dialog = new CreateDataSourceDialog(this.getShell(), this.teiidImportServer, null);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Properties dsProperties;
            String dsDriver;
            String dsName = dialog.getDataSourceName();
            IStatus createStatus = this.dataSourceManager.createDataSource(dsName, dsDriver = dialog.getDataSourceDriverName(), dsProperties = dialog.getDataSourceProperties());
            if (!createStatus.isOK()) {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dataSourcePanel_createErrorTitle, (String)createStatus.getMessage(), (IStatus)createStatus);
            }
            this.refreshDataSourceList();
            this.dataSourcesViewer.refresh();
            this.packTable();
            this.setTableSelection(dsName);
            this.fireSelectionChanged(this.getSelectedDataSourceName());
        }
    }

    private void handleDeleteSource() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.dataSourcePanel_deleteSourceDialogTitle, (String)Messages.dataSourcePanel_deleteSourceDialogMsg)) {
            String dsName = this.getSelectedDataSourceName();
            IStatus deleteStatus = this.dataSourceManager.deleteDataSource(dsName);
            if (!deleteStatus.isOK()) {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dataSourcePanel_deleteErrorTitle, (String)deleteStatus.getMessage(), (IStatus)deleteStatus);
            }
            this.refreshDataSourceList();
            this.dataSourcesViewer.refresh();
            this.packTable();
            this.setTableSelection(null);
            this.setButtonEnabledStates();
            this.fireSelectionChanged(this.getSelectedDataSourceName());
        }
    }

    private void handleEditSource() {
        String dataSourceName = this.getSelectedDataSourceName();
        CreateDataSourceDialog dialog = new CreateDataSourceDialog(this.getShell(), this.teiidImportServer, dataSourceName);
        dialog.open();
        if (dialog.getReturnCode() == 0 && dialog.hasPropertyChanges()) {
            Properties dsProps;
            String dsDriver;
            String sourceName = dialog.getDataSourceName();
            IStatus deleteCreateStatus = this.dataSourceManager.deleteAndCreateDataSource(sourceName, sourceName, dsDriver = dialog.getDataSourceDriverName(), dsProps = dialog.getDataSourceProperties());
            if (!deleteCreateStatus.isOK()) {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dataSourcePanel_editErrorTitle, (String)deleteCreateStatus.getMessage(), (IStatus)deleteCreateStatus);
            }
            this.refreshDataSourceList();
            this.dataSourcesViewer.refresh();
            this.packTable();
            this.setTableSelection(sourceName);
            this.setButtonEnabledStates();
            this.fireSelectionChanged(this.getSelectedDataSourceName());
        }
    }

    private void handleCopySource() {
        CopyDataSourceDialog dialog = new CopyDataSourceDialog(this.getShell(), this.teiidImportServer);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String newDsName;
            String dsToCopyDriver;
            String dsToCopyName = this.getSelectedDataSourceName();
            IStatus copyStatus = this.dataSourceManager.copyDataSource(dsToCopyName, dsToCopyDriver = this.getSelectedDataSourceDriver(), newDsName = dialog.getNewDataSourceName());
            if (!copyStatus.isOK()) {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dataSourcePanel_copyErrorTitle, (String)copyStatus.getMessage(), (IStatus)copyStatus);
            }
            this.refreshDataSourceList();
            this.dataSourcesViewer.refresh();
            this.packTable();
            this.setTableSelection(newDsName);
            this.setButtonEnabledStates();
            this.fireSelectionChanged(this.getSelectedDataSourceName());
        }
    }

    private void packTable() {
        TableColumn[] cols = this.dataSourcesViewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
    }

    public void addListener(DataSourcePanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DataSourcePanelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void fireSelectionChanged(String selectedSourceName) {
        for (DataSourcePanelListener listener : this.listeners) {
            listener.selectionChanged(selectedSourceName);
        }
    }

    private Object[] getDataSources() {
        return this.dataSourceObjList.toArray();
    }

    private void refreshDataSourceList() {
        Collection<ITeiidDataSource> dataSources;
        this.dataSourceObjList.clear();
        try {
            dataSources = this.teiidImportServer.getDataSources();
        }
        catch (Exception ex) {
            dataSources = new ArrayList<ITeiidDataSource>();
            UTIL.log((Throwable)ex);
        }
        Map<String, String> classNameDriverNameMap = this.dataSourceManager.getClassNameDriverNameMap(dataSources);
        for (ITeiidDataSource dataSource : dataSources) {
            DataSourceItem dsObj = new DataSourceItem();
            String name = dataSource.getName();
            dsObj.setName(name);
            String sourceJndiName = dataSource.getPropertyValue("jndi-name");
            if (sourceJndiName != null) {
                dsObj.setJndiName(sourceJndiName);
            } else {
                dsObj.setJndiName("java:/" + name);
            }
            String dsDriver = this.dataSourceManager.getDataSourceDriver(name, classNameDriverNameMap);
            dsObj.setDriver(dsDriver);
            this.dataSourceObjList.add(dsObj);
        }
    }

    public String getSelectedDataSourceName() {
        DataSourceItem selectedDS = this.getSelectedDataSource();
        return selectedDS == null ? null : selectedDS.getName();
    }

    public String getSelectedDataSourceJndiName() {
        DataSourceItem selectedDS = this.getSelectedDataSource();
        return selectedDS == null ? null : selectedDS.getJndiName();
    }

    public String getSelectedDataSourceDriver() {
        DataSourceItem selectedDS = this.getSelectedDataSource();
        return selectedDS == null ? null : selectedDS.getDriver();
    }

    private DataSourceItem getSelectedDataSource() {
        IStructuredSelection selection = (IStructuredSelection)this.dataSourcesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (DataSourceItem)selection.getFirstElement();
    }

    void handleDataSourceSelected(SelectionChangedEvent event) {
        this.setButtonEnabledStates();
        this.fireSelectionChanged(this.getSelectedDataSourceName());
    }

    private void setButtonEnabledStates() {
        String selectedDS = this.getSelectedDataSourceName();
        if (CoreStringUtil.isEmpty((String)selectedDS)) {
            if (this.deleteSourceButton.isEnabled()) {
                this.deleteSourceButton.setEnabled(false);
            }
            if (this.editSourceButton.isEnabled()) {
                this.editSourceButton.setEnabled(false);
            }
            if (this.copySourceButton.isEnabled()) {
                this.copySourceButton.setEnabled(false);
            }
        } else {
            if (!this.deleteSourceButton.isEnabled()) {
                this.deleteSourceButton.setEnabled(true);
            }
            if (!this.editSourceButton.isEnabled()) {
                this.editSourceButton.setEnabled(true);
            }
            if (!this.copySourceButton.isEnabled()) {
                this.copySourceButton.setEnabled(true);
            }
        }
    }

    public void refresh() {
        this.dataSourcesViewer.setInput((Object)this);
        this.dataSourcesViewer.refresh();
    }

    class DataSourceLabelProvider
    extends ColumnLabelProvider {
        public int NAME_COL = 0;
        public int JNDI_COL = 1;
        public int DRIVER_COL = 2;
        private int cType;

        public DataSourceLabelProvider(int colType) {
            this.cType = colType;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            DataSourceItem dataSourceItem = (DataSourceItem)element;
            if (this.cType == this.NAME_COL) {
                return dataSourceItem.getName();
            }
            if (this.cType == this.JNDI_COL) {
                return dataSourceItem.getJndiName();
            }
            return dataSourceItem.getDriver();
        }

        public String getToolTipText(Object element) {
            DataSourceItem dataSourceItem = (DataSourceItem)element;
            if (this.cType == this.NAME_COL) {
                return dataSourceItem.getName();
            }
            if (this.cType == this.JNDI_COL) {
                return dataSourceItem.getJndiName();
            }
            return String.valueOf(Messages.dataSourcePanel_driverTooltipPrefix) + dataSourceItem.getName();
        }
    }
}

