/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;
import org.teiid.designer.ui.common.util.WidgetUtil;

public final class DataSourceDriversPanel
extends Composite
implements UiConstants {
    private static final String BLANK = " ";
    private String selectedDriver;
    private final TableViewer driversViewer;
    private ITeiidImportServer teiidImportServer;
    private List<String> driverList = new ArrayList<String>();
    private int visibleTableRows = 4;
    private List<DataSourcePanelListener> listeners = new ArrayList<DataSourcePanelListener>();

    public DataSourceDriversPanel(Composite parent, int visibleTableRows, ITeiidImportServer teiidImportServer) {
        super(parent, 0);
        this.teiidImportServer = teiidImportServer;
        this.visibleTableRows = visibleTableRows;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createAddHyperlink(this);
        this.driversViewer = new TableViewer((Composite)this, 66304);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.driversViewer);
        this.driversViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DataSourceDriversPanel.this.getTemplates();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.driversViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = (String)e1;
                String name2 = (String)e2;
                return super.compare(viewer, (Object)name1, (Object)name2);
            }
        });
        Table table = this.driversViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * this.visibleTableRows;
        TableViewerColumn column = new TableViewerColumn(this.driversViewer, 16384);
        column.getColumn().setText(Messages.dataSourceDriversPanel_colText);
        column.setLabelProvider((CellLabelProvider)new DriverLabelProvider());
        this.driversViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSourceDriversPanel.this.handleDriverSelected(event);
            }
        });
        this.refreshDriverList();
        this.driversViewer.setInput((Object)this);
        this.packTable();
    }

    private void createAddHyperlink(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Hyperlink addDriverLink = toolkit.createHyperlink(parent, Messages.dataSourceDriversPanelAddHyperlinkTxt, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addDriverLink);
        addDriverLink.setBackground(parent.getBackground());
        addDriverLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DataSourceDriversPanel.this.handleAddDriver();
            }
        });
    }

    private void setTableSelection(String templateName) {
        this.selectedDriver = templateName;
        int selIndex = 0;
        TableItem[] items = this.driversViewer.getTable().getItems();
        if (templateName == null && items.length > 0) {
            this.driversViewer.getTable().select(selIndex);
        } else {
            int i = 0;
            while (i < items.length) {
                String itemName = items[i].getText();
                if (itemName != null && itemName.trim().equals(templateName)) {
                    selIndex = i;
                    break;
                }
                ++i;
            }
            this.driversViewer.getTable().select(selIndex);
        }
    }

    public void addListener(DataSourcePanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DataSourcePanelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void fireSelectionChanged(String selectedSourceName) {
        for (DataSourcePanelListener listener : this.listeners) {
            listener.selectionChanged(selectedSourceName);
        }
    }

    private void handleAddDriver() {
        File theFile = this.chooseFileFromFileSystem(this.getShell());
        if (theFile == null) {
            return;
        }
        String fileShortName = theFile.getName();
        boolean isDuplicate = this.isDuplicateDriverName(fileShortName);
        if (isDuplicate) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.dataSourceDriversPanelAddDialogErrorTitle, (String)Messages.dataSourceDriversPanelAddDialogErrorDuplicateNameMsg);
            return;
        }
        this.deployJarOrRar(theFile);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        this.refreshDriverList();
        this.driversViewer.refresh();
        this.packTable();
        this.setTableSelection(fileShortName);
        this.fireSelectionChanged(fileShortName);
    }

    private boolean deployJarOrRar(final File deployFile) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask(Messages.TeiidImportWizard_DeployDriverMsg, 100);
                    monitor.worked(50);
                    try {
                        try {
                            DataSourceDriversPanel.this.teiidImportServer.deployDriver(deployFile);
                        }
                        catch (Exception err) {
                            throw new InvocationTargetException(err);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Throwable error) {
            if (error instanceof InvocationTargetException) {
                error = ((InvocationTargetException)error).getTargetException();
            }
            error.printStackTrace();
            WidgetUtil.showError((Throwable)error);
            return false;
        }
        return true;
    }

    private File chooseFileFromFileSystem(Shell shell) {
        File fileResult = null;
        FileDialog dlg = new FileDialog(shell);
        dlg.setFilterExtensions(new String[]{"*.jar", "*.rar", "*.*"});
        dlg.setFilterNames(new String[]{"jar", "rar", "all files"});
        String fileFullName = dlg.open();
        if (fileFullName != null) {
            fileResult = new File(fileFullName);
        }
        return fileResult;
    }

    private boolean isDuplicateDriverName(String driverName) {
        return this.driverList.contains(driverName);
    }

    private void packTable() {
        TableColumn[] cols = this.driversViewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
    }

    private Object[] getTemplates() {
        return this.driverList.toArray();
    }

    private void refreshDriverList() {
        Set names;
        this.driverList.clear();
        try {
            names = this.teiidImportServer.getDataSourceTemplateNames();
        }
        catch (Exception ex) {
            names = Collections.EMPTY_SET;
            UTIL.log((Throwable)ex);
        }
        this.driverList.addAll(names);
    }

    public String getSelectedDriverName() {
        return this.selectedDriver;
    }

    void handleDriverSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.selectedDriver = !selection.isEmpty() ? (String)selection.getFirstElement() : null;
        this.fireSelectionChanged(this.selectedDriver);
    }

    public IStatus getStatus() {
        String selectedDriver = this.getSelectedDriverName();
        if (selectedDriver == null || selectedDriver.isEmpty()) {
            return new Status(4, PLUGIN_ID, Messages.dataSourceDriversPanelErrorNoSelection);
        }
        return new Status(0, PLUGIN_ID, Messages.dataSourceDriversPanelOk);
    }

    public void refresh() {
        this.driversViewer.setInput((Object)this);
        this.driversViewer.refresh();
    }

    class DriverLabelProvider
    extends ColumnLabelProvider {
        public Image getImage(Object element) {
            Image image = null;
            return image;
        }

        public String getText(Object element) {
            String driverName = (String)element;
            if (driverName.equals("teiid-connector-file.rar")) {
                driverName = "FlatFile";
            } else if (driverName.equals("teiid-connector-google.rar")) {
                driverName = "Google";
            } else if (driverName.equals("teiid-connector-infinispan.rar")) {
                driverName = "Infinispan";
            } else if (driverName.equals("teiid-connector-ldap.rar")) {
                driverName = "LDAP";
            } else if (driverName.equals("teiid-connector-salesforce.rar")) {
                driverName = "Salesforce";
            } else if (driverName.equals("teiid-connector-ws.rar")) {
                driverName = "WebService";
            }
            return driverName;
        }

        public String getToolTipText(Object element) {
            return String.valueOf(Messages.dataSourceDriversPanelItemTooltip) + DataSourceDriversPanel.BLANK + (String)element;
        }
    }
}

