/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.fusesource.ide.server.karaf.core.server.subsystems.Karaf2xStartupLaunchConfigurator;

public class Karaf3xStartupLaunchConfigurator
extends Karaf2xStartupLaunchConfigurator {
    public Karaf3xStartupLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    @Override
    protected String getVMArguments(String karafInstallDir) {
        return this.get3xVMArguments(karafInstallDir);
    }

    protected String get2xVMArguments(String karafInstallDir) {
        return super.getVMArguments(karafInstallDir);
    }

    protected String get3xVMArguments(String karafInstallDir) {
        StringBuilder vmArguments = new StringBuilder();
        String endorsedDirs = System.getProperty("java.endorsed.dirs");
        String extDirs = System.getProperty("java.ext.dirs");
        IKarafRuntime runtime = null;
        if (this.server.getRuntime() != null) {
            runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
            File vmLoc = runtime.getVM().getInstallLocation();
            endorsedDirs = String.format("%s%sjre%slib%sendorsed%s%s%slib%sendorsed%s%s%slib%sendorsed", vmLoc.getPath(), SEPARATOR, SEPARATOR, SEPARATOR, File.pathSeparator, vmLoc.getPath(), SEPARATOR, SEPARATOR, File.pathSeparator, karafInstallDir, SEPARATOR, SEPARATOR);
            extDirs = String.format("%s%sjre%slib%sext%s%s%slib%sext%s%s%slib%sext", vmLoc.getPath(), SEPARATOR, SEPARATOR, SEPARATOR, File.pathSeparator, vmLoc.getPath(), SEPARATOR, SEPARATOR, File.pathSeparator, karafInstallDir, SEPARATOR, SEPARATOR);
        }
        vmArguments.append("-Xms128M");
        vmArguments.append(" -Xmx512M");
        vmArguments.append(" -XX:+UnlockDiagnosticVMOptions");
        vmArguments.append(" -XX:+UnsyncloadClass");
        vmArguments.append(" -server ");
        vmArguments.append(" -Dcom.sun.management.jmxremote");
        vmArguments.append(" -Djava.endorsed.dirs=\"" + endorsedDirs + "\"");
        vmArguments.append(" -Djava.ext.dirs=\"" + extDirs + "\"");
        vmArguments.append(" -Dkaraf.startLocalConsole=false");
        vmArguments.append(" -Dkaraf.startRemoteShell=true");
        vmArguments.append(" -Dkaraf.home=\"" + karafInstallDir + "\"");
        vmArguments.append(" -Dkaraf.base=\"" + karafInstallDir + "\"");
        vmArguments.append(" -Dkaraf.instances=\"" + karafInstallDir + SEPARATOR + "instances" + "\"");
        vmArguments.append(" -Dkaraf.data=\"" + karafInstallDir + SEPARATOR + "data" + "\"");
        vmArguments.append(" -Dkaraf.etc=\"" + karafInstallDir + SEPARATOR + "etc" + "\"");
        vmArguments.append(" -Djava.io.tmpdir=\"" + karafInstallDir + SEPARATOR + "tmp" + "\"");
        vmArguments.append(" -Djava.util.logging.config.file=\"" + karafInstallDir + SEPARATOR + "etc" + SEPARATOR + "java.util.logging.properties" + "\"");
        vmArguments.append(" -Djavax.management.builder.initial=org.apache.karaf.management.boot.KarafMBeanServerBuilder\"");
        return vmArguments.toString();
    }
}

