/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.jbossds;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;

public class JBossDsConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    @Override
    public String getDataSourcePasswordPropertyKey() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return "JBossDs";
    }

    @Override
    public String getPasswordPropertyKey() {
        return "bogus_xxxx";
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        Properties connectionProps = new Properties();
        Properties props = connectionProfile.getBaseProperties();
        String jndi = props.getProperty("JBossDsJndi");
        if (jndi != null) {
            connectionProps.setProperty("JBossDsJndi", jndi);
        }
        return connectionProps;
    }

    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String result = props.getProperty("JBossDsJndi");
        if (result != null) {
            connectionProps.setProperty("connection:JBossDsJndi", result);
        }
        if ((result = props.getProperty("JBossDsTranslator")) != null) {
            connectionProps.setProperty("translator:name", result);
        }
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    @Override
    public Properties getCommonProfileProperties(IConnectionProfile profile) {
        return super.getCommonProfileProperties(profile);
    }

    @Override
    public String getTranslatorName(ModelResource modelResource) {
        String translatorName = null;
        Properties translatorProps = null;
        try {
            translatorProps = this.getHelper().getProperties(modelResource, "translator:");
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        if (translatorProps != null && !translatorProps.isEmpty()) {
            translatorName = translatorProps.getProperty("translator:name");
        }
        if (translatorName != null && !translatorName.isEmpty()) {
            return translatorName;
        }
        return "unknown";
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return false;
    }
}

