/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.metadata.Capabilities;
import org.teiid.designer.jdbc.metadata.DatabaseInfo;
import org.teiid.designer.jdbc.metadata.Includes;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcNodeVisitor;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.JdbcTableType;
import org.teiid.designer.jdbc.metadata.impl.CapabilitiesImpl;
import org.teiid.designer.jdbc.metadata.impl.DatabaseInfoImpl;
import org.teiid.designer.jdbc.metadata.impl.IncludesImpl;
import org.teiid.designer.jdbc.metadata.impl.InternalJdbcDatabase;
import org.teiid.designer.jdbc.metadata.impl.JdbcCatalogImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeCache;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeSelections;
import org.teiid.designer.jdbc.metadata.impl.JdbcProcedureTypeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcSchemaImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcTableTypeImpl;

public class JdbcDatabaseImpl
extends JdbcNodeImpl
implements JdbcDatabase,
InternalJdbcDatabase {
    private final Connection connection;
    private DatabaseMetaData metadata;
    private Capabilities capabilities;
    private DatabaseInfo databaseInfo;
    private final JdbcNodeCache cache;
    private final JdbcNodeSelections selections;
    private final IncludesImpl includes;
    private final Object capabilitiesLock = new Object();
    private final Object databaseInfoLock = new Object();

    public JdbcDatabaseImpl(Connection connection, String name) {
        this(connection, name, new JdbcNodeSelections());
    }

    public JdbcDatabaseImpl(Connection connection, String name, JdbcNodeSelections selections) {
        super(101, name, null);
        CoreArgCheck.isNotNull((Object)connection);
        this.connection = connection;
        this.includes = new IncludesImpl(this);
        this.cache = new JdbcNodeCache();
        this.cache.put(this);
        this.selections = selections;
        this.doSetSelectionMode(2);
    }

    @Override
    public void accept(JdbcNodeVisitor theVisitor, int theDepth) throws JdbcException {
        if (theVisitor instanceof SelectSchemasAndCatalogs) {
            if (theDepth != 1) {
                super.accept(theVisitor, 1);
            }
            if (!((SelectSchemasAndCatalogs)theVisitor).foundMatch()) {
                super.accept(theVisitor, theDepth);
            }
        } else {
            super.accept(theVisitor, theDepth);
        }
    }

    @Override
    public JdbcNodeSelections getJdbcNodeSelections() {
        return this.selections;
    }

    @Override
    public IPath getPathInSource() {
        return null;
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    @Override
    public boolean isDatabaseObject() {
        return false;
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this;
    }

    @Override
    public JdbcNodeCache getJdbcNodeCache() {
        return this.cache;
    }

    @Override
    public JdbcNode findJdbcNode(IPath path) {
        return this.cache.get(path);
    }

    @Override
    public JdbcNode findJdbcNode(String path) {
        return this.findJdbcNode((IPath)new Path(path));
    }

    @Override
    public JdbcNode[] getSelectedChildren() throws JdbcException {
        ArrayList<JdbcNode> selectedNodes = new ArrayList<JdbcNode>();
        JdbcNode[] nodes = this.getChildren();
        int ndx = 0;
        while (ndx < nodes.length) {
            JdbcNode node = nodes[ndx];
            if (node.getSelectionMode() != 0) {
                selectedNodes.add(node);
            }
            ++ndx;
        }
        if (selectedNodes.size() > 0) {
            JdbcNode[] nodeArray = new JdbcNode[selectedNodes.size()];
            int iNode = 0;
            Iterator iter = selectedNodes.iterator();
            while (iter.hasNext()) {
                nodeArray[iNode] = (JdbcNode)iter.next();
                ++iNode;
            }
            return nodeArray;
        }
        return new JdbcNode[0];
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData() throws JdbcException {
        if (this.metadata == null) {
            try {
                this.metadata = this.connection.getMetaData();
            }
            catch (SQLException e) {
                throw new JdbcException((Throwable)e, JdbcPlugin.Util.getString("JdbcDatabaseImpl.Error_while_getting_the_database_metadata_component", new Object[0]));
            }
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Capabilities getCapabilities() throws JdbcException {
        if (this.capabilities == null) {
            Object object = this.capabilitiesLock;
            synchronized (object) {
                if (this.capabilities == null) {
                    this.capabilities = this.loadCapabilities(this.getDatabaseMetaData());
                }
            }
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseInfo getDatabaseInfo() throws JdbcException {
        if (this.databaseInfo == null) {
            Object object = this.databaseInfoLock;
            synchronized (object) {
                if (this.databaseInfo == null) {
                    this.databaseInfo = this.loadDatabaseInfo(this.getDatabaseMetaData());
                }
            }
        }
        return this.databaseInfo;
    }

    @Override
    public String getTypeName() {
        return JdbcPlugin.Util.getString("JdbcDatabaseImpl.DatabaseTypeName", new Object[0]);
    }

    @Override
    protected JdbcNode[] computeChildren() throws JdbcException {
        ArrayList<JdbcNodeImpl> children;
        DatabaseMetaData metadata;
        boolean supportsSchemas;
        boolean supportsCatalogs;
        block52: {
            String msg;
            Object[] params;
            String catalogName;
            ResultSet resultSet;
            block51: {
                Capabilities capabilities = this.getCapabilities();
                supportsCatalogs = false;
                try {
                    supportsCatalogs = capabilities.supportsCatalogs();
                }
                catch (Throwable t) {
                    Object[] params2 = new Object[]{this.getConnection()};
                    String msg2 = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_discovering_support_for_catalogs", params2);
                    JdbcPlugin.Util.log(2, t, msg2);
                }
                supportsSchemas = false;
                try {
                    supportsSchemas = capabilities.supportsSchemas();
                }
                catch (Throwable t) {
                    Object[] params3 = new Object[]{this.getConnection()};
                    String msg3 = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_discovering_support_for_schemas", params3);
                    JdbcPlugin.Util.log(2, t, msg3);
                }
                metadata = this.getDatabaseMetaData();
                children = new ArrayList<JdbcNodeImpl>();
                if (supportsCatalogs) {
                    resultSet = null;
                    try {
                        resultSet = metadata.getCatalogs();
                        while (resultSet.next()) {
                            catalogName = resultSet.getString(1);
                            if (catalogName == null || catalogName.length() <= 0) continue;
                            children.add(new JdbcCatalogImpl(this, catalogName));
                        }
                        if (children.isEmpty()) {
                            supportsCatalogs = false;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        supportsCatalogs = false;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e) {
                                JdbcPlugin.Util.log((Throwable)e);
                            }
                        }
                        break block51;
                    }
                    catch (Throwable t) {
                        try {
                            params = new Object[]{metadata.getClass().getName(), this.getConnection()};
                            msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getCatalogs()_and_processing_results", params);
                            JdbcPlugin.Util.log(2, t, msg);
                            supportsCatalogs = false;
                            break block51;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (SQLException e) {
                                    JdbcPlugin.Util.log((Throwable)e);
                                }
                            }
                        }
                    }
                    if (resultSet == null) break block51;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
            }
            if (supportsSchemas && !supportsCatalogs) {
                resultSet = null;
                try {
                    resultSet = metadata.getSchemas();
                    while (resultSet.next()) {
                        catalogName = resultSet.getString(1);
                        children.add(new JdbcSchemaImpl(this, catalogName));
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    supportsSchemas = false;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            JdbcPlugin.Util.log((Throwable)e);
                        }
                    }
                    break block52;
                }
                catch (Throwable t) {
                    try {
                        params = new Object[]{metadata.getClass().getName(), this.getConnection()};
                        msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getSchemas()_and_processing_results", params);
                        JdbcPlugin.Util.log(2, t, msg);
                        supportsSchemas = false;
                        break block52;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e) {
                                JdbcPlugin.Util.log((Throwable)e);
                            }
                        }
                    }
                }
                if (resultSet == null) break block52;
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
            }
        }
        if (!supportsSchemas && !supportsCatalogs) {
            try {
                String[] tableTypes = this.getJdbcDatabase().getIncludes().getIncludedTableTypes();
                if (tableTypes == null) {
                    tableTypes = this.getJdbcDatabase().getCapabilities().getTableTypes();
                }
                int i = 0;
                while (i < tableTypes.length) {
                    children.add(new JdbcTableTypeImpl(this, tableTypes[i]));
                    ++i;
                }
            }
            catch (Throwable t) {
                Object[] params = new Object[]{metadata.getClass().getName(), this.getConnection()};
                String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getTableTypes()_and_processing_results", params);
                JdbcPlugin.Util.log(2, t, msg);
            }
            if (this.getIncludes().includeProcedures()) {
                String procTerm = null;
                try {
                    procTerm = this.getCapabilities().getProcedureTerm();
                }
                catch (Throwable throwable) {
                    procTerm = JdbcPlugin.Util.getString("JdbcDatabaseImpl.ProcedureTypeName", new Object[0]);
                }
                children.add(new JdbcProcedureTypeImpl(this, procTerm));
            }
        }
        return children.toArray(new JdbcNode[children.size()]);
    }

    @Override
    public String getFullyQualifiedName() {
        return "";
    }

    public Capabilities loadCapabilities(DatabaseMetaData metadata) {
        return new CapabilitiesImpl(metadata);
    }

    public DatabaseInfo loadDatabaseInfo(DatabaseMetaData metadata) throws JdbcException {
        Status status;
        CoreArgCheck.isNotNull((Object)metadata);
        DatabaseInfoImpl obj = new DatabaseInfoImpl();
        ArrayList<Status> statuses = new ArrayList<Status>();
        try {
            obj.setProductName(metadata.getDatabaseProductName());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_product_name", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setProductVersion(metadata.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_product_version", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        obj.setDriverMajorVersion(metadata.getDriverMajorVersion());
        obj.setDriverMinorVersion(metadata.getDriverMinorVersion());
        try {
            obj.setDriverName(metadata.getDriverName());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_driver_name", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setDriverVersion(metadata.getDriverVersion());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_driver_version", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setDatabaseURL(metadata.getURL());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_database_URL", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setReadOnly(metadata.isReadOnly());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_database_read-only_mode", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setUserName(metadata.getUserName());
        }
        catch (SQLException e) {
            status = new Status(4, "org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_username", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        if (statuses.size() != 0) {
            MultiStatus mstatus = new MultiStatus("org.teiid.designer.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Error_while_processing_database_information", (Object)metadata), null);
            for (IStatus iStatus : statuses) {
                mstatus.add(iStatus);
            }
            throw new JdbcException((IStatus)mstatus);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object;
        super.refresh();
        if (this.capabilities != null) {
            object = this.capabilitiesLock;
            synchronized (object) {
                this.capabilities = null;
            }
        }
        if (this.databaseInfo != null) {
            object = this.databaseInfoLock;
            synchronized (object) {
                this.databaseInfo = null;
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" - ");
        try {
            String url = this.connection.getMetaData().getURL();
            sb.append(url);
        }
        catch (SQLException sQLException) {}
        return super.toString();
    }

    @Override
    public Includes getIncludes() {
        return this.includes;
    }

    public IStatus selectDefaultNodes(String username) {
        try {
            Object[] params;
            String temp;
            String driverName = this.getDatabaseInfo().getDriverName();
            if (driverName != null && driverName.toUpperCase().contains("TEIID")) {
                return Status.OK_STATUS;
            }
            boolean isExcelOrAccess = false;
            String productName = this.getDatabaseInfo().getProductName();
            if (productName != null && (productName.equalsIgnoreCase("excel") || productName.equalsIgnoreCase("access"))) {
                isExcelOrAccess = true;
            }
            String user = username == null ? this.getDatabaseInfo().getUserName() : username;
            SelectSchemasAndCatalogs visitor = new SelectSchemasAndCatalogs(user, true, isExcelOrAccess);
            this.accept(visitor, 2);
            if (!visitor.foundMatch() && username == null && !(temp = this.getDatabaseInfo().getUserName()).equals(user)) {
                user = temp;
                visitor = new SelectSchemasAndCatalogs(user, true, isExcelOrAccess);
                this.accept(visitor, 2);
            }
            if (!visitor.foundMatch()) {
                params = new Object[]{username == null ? user : username};
                String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unable_to_select_any_database_objects", params);
                return new Status(4, "org.teiid.designer.jdbc", 3, msg, null);
            }
            params = new Object[]{new Integer(1)};
            String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Selected_database_objects", params);
            return new Status(0, "org.teiid.designer.jdbc", 0, msg, null);
        }
        catch (JdbcException e) {
            String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Error_while_selecting_default_database_objects", new Object[0]);
            return new Status(4, "org.teiid.designer.jdbc", 0, msg, (Throwable)((Object)e));
        }
    }

    public IStatus selectDefaultNodes() {
        return this.selectDefaultNodes(null);
    }

    protected class SelectSchemasAndCatalogs
    implements JdbcNodeVisitor {
        private final String matchName;
        private final boolean ignoreCase;
        private final boolean isExcelOrAccess;
        private boolean match = false;

        public SelectSchemasAndCatalogs(String matchName, boolean ignoreCase, boolean isExcelOrAccess) {
            CoreArgCheck.isNotNull((Object)matchName);
            this.matchName = matchName;
            this.ignoreCase = ignoreCase;
            this.isExcelOrAccess = isExcelOrAccess;
        }

        public boolean foundMatch() {
            return this.match;
        }

        @Override
        public boolean visit(JdbcNode node) {
            if (this.foundMatch()) {
                return false;
            }
            if (node instanceof JdbcDatabase) {
                return true;
            }
            if (node instanceof JdbcCatalog || node instanceof JdbcSchema || this.isExcelOrAccess && node instanceof JdbcTableType) {
                if (this.isExcelOrAccess) {
                    this.match = true;
                } else {
                    String name = node.getName();
                    boolean bl = this.match = this.ignoreCase ? this.matchName.equalsIgnoreCase(name) : this.matchName.equals(name);
                }
                if (this.match) {
                    node.setSelected(true);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

