/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.metadata.Capabilities;

public class CapabilitiesImpl
implements Capabilities {
    private final DatabaseMetaData metadata;
    private String[] tableTypes;

    public CapabilitiesImpl(DatabaseMetaData metadata) {
        CoreArgCheck.isNotNull((Object)metadata);
        this.metadata = metadata;
    }

    protected DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean supportsCatalogs() throws SQLException {
        return this.supportsCatalogsInTableDefinitions() || this.supportsCatalogsInDataManipulation() || this.supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsSchemas() throws SQLException {
        return this.supportsSchemasInDataManipulation() || this.supportsSchemasInTableDefinitions();
    }

    @Override
    public String[] getTableTypes() throws SQLException {
        if (this.tableTypes == null) {
            ArrayList<String> results = new ArrayList<String>();
            ResultSet resultSet = this.getMetadata().getTableTypes();
            try {
                while (resultSet.next()) {
                    String tableType = resultSet.getString(1);
                    results.add(tableType);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
            }
            this.tableTypes = results.toArray(new String[results.size()]);
        }
        return this.tableTypes;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.getMetadata().allProceduresAreCallable();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.getMetadata().allTablesAreSelectable();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getMetadata().dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getMetadata().dataDefinitionIgnoredInTransactions();
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return this.getMetadata().deletesAreDetected(type);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getMetadata().doesMaxRowSizeIncludeBlobs();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.getMetadata().getCatalogSeparator();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.getMetadata().getCatalogTerm();
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.getMetadata().getExtraNameCharacters();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.getMetadata().getIdentifierQuoteString();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getMetadata().getMaxBinaryLiteralLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMetadata().getMaxCatalogNameLength();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.getMetadata().getMaxCharLiteralLength();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMetadata().getMaxColumnNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getMetadata().getMaxColumnsInGroupBy();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMetadata().getMaxColumnsInIndex();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getMetadata().getMaxColumnsInOrderBy();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.getMetadata().getMaxColumnsInSelect();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.getMetadata().getMaxColumnsInTable();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.getMetadata().getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMetadata().getMaxCursorNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.getMetadata().getMaxIndexLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMetadata().getMaxProcedureNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.getMetadata().getMaxRowSize();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMetadata().getMaxSchemaNameLength();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.getMetadata().getMaxStatementLength();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.getMetadata().getMaxStatements();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMetadata().getMaxTableNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.getMetadata().getMaxTablesInSelect();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMetadata().getMaxUserNameLength();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.getMetadata().getNumericFunctions();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.getMetadata().getProcedureTerm();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.getMetadata().getSchemaTerm();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.getMetadata().getSearchStringEscape();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.getMetadata().getSQLKeywords();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.getMetadata().getStringFunctions();
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.getMetadata().getSystemFunctions();
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.getMetadata().getTimeDateFunctions();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getMetadata().getTypeInfo();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return this.getMetadata().insertsAreDetected(type);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.getMetadata().isCatalogAtStart();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getMetadata().isReadOnly();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getMetadata().nullPlusNonNullIsNull();
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getMetadata().nullsAreSortedAtEnd();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getMetadata().nullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getMetadata().nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.getMetadata().nullsAreSortedLow();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.getMetadata().othersDeletesAreVisible(type);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.getMetadata().othersInsertsAreVisible(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.getMetadata().othersUpdatesAreVisible(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.getMetadata().ownDeletesAreVisible(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.getMetadata().ownInsertsAreVisible(type);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.getMetadata().ownUpdatesAreVisible(type);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getMetadata().storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getMetadata().storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getMetadata().storesMixedCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getMetadata().storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getMetadata().storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getMetadata().storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.getMetadata().supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.getMetadata().supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.getMetadata().supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.getMetadata().supportsANSI92FullSQL();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.getMetadata().supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.getMetadata().supportsBatchUpdates();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.getMetadata().supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.getMetadata().supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.getMetadata().supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.getMetadata().supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.getMetadata().supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.getMetadata().supportsColumnAliasing();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.getMetadata().supportsConvert();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.getMetadata().supportsConvert(fromType, toType);
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.getMetadata().supportsCoreSQLGrammar();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.getMetadata().supportsCorrelatedSubqueries();
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.getMetadata().supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.getMetadata().supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getMetadata().supportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getMetadata().supportsExpressionsInOrderBy();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getMetadata().supportsExtendedSQLGrammar();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.getMetadata().supportsFullOuterJoins();
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.getMetadata().supportsGroupBy();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.getMetadata().supportsGroupByBeyondSelect();
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getMetadata().supportsGroupByUnrelated();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getMetadata().supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getMetadata().supportsLikeEscapeClause();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.getMetadata().supportsLimitedOuterJoins();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.getMetadata().supportsMinimumSQLGrammar();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getMetadata().supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getMetadata().supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.getMetadata().supportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.getMetadata().supportsMultipleTransactions();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getMetadata().supportsNonNullableColumns();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getMetadata().supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.getMetadata().supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.getMetadata().supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.getMetadata().supportsOpenStatementsAcrossRollback();
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.getMetadata().supportsOrderByUnrelated();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.getMetadata().supportsOuterJoins();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.getMetadata().supportsPositionedDelete();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.getMetadata().supportsPositionedUpdate();
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.getMetadata().supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return this.getMetadata().supportsResultSetType(type);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.getMetadata().supportsSchemasInDataManipulation();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.getMetadata().supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.getMetadata().supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.getMetadata().supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.getMetadata().supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.getMetadata().supportsSelectForUpdate();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.getMetadata().supportsStoredProcedures();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.getMetadata().supportsSubqueriesInComparisons();
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.getMetadata().supportsSubqueriesInExists();
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.getMetadata().supportsSubqueriesInIns();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.getMetadata().supportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getMetadata().supportsTableCorrelationNames();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.getMetadata().supportsTransactionIsolationLevel(level);
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.getMetadata().supportsTransactions();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.getMetadata().supportsUnion();
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.getMetadata().supportsUnionAll();
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return this.getMetadata().updatesAreDetected(type);
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getMetadata().usesLocalFilePerTable();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.getMetadata().usesLocalFiles();
    }
}

