/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcUtil;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.data.Response;

public class QueryRequest
extends Request {
    private final String sql;

    public QueryRequest(String name, Connection connection, String sql) {
        super(name, connection);
        CoreArgCheck.isNotNull((Object)sql);
        CoreArgCheck.isNotZeroLength((String)sql);
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    protected IStatus performInvocation(Response results) {
        ArrayList<IStatus> statuses;
        Connection conn;
        block52: {
            Statement statement;
            block58: {
                conn = (Connection)this.getTarget();
                statuses = new ArrayList<IStatus>();
                statement = null;
                ResultSet resultSet = null;
                try {
                    statement = conn.createStatement();
                    boolean isResultSet = statement.execute(this.sql);
                    if (isResultSet) {
                        resultSet = statement.getResultSet();
                        Response.addResults(results, resultSet, this.isMetadataRequested());
                    } else {
                        try {
                            int updateCount = statement.getUpdateCount();
                            Integer value = new Integer(updateCount);
                            Response.addResults(results, value, true);
                        }
                        catch (SQLException e) {
                            statuses.add(JdbcUtil.createIStatus(e));
                        }
                    }
                    SQLWarning warning = statement.getWarnings();
                    while (warning != null) {
                        statuses.add(JdbcUtil.createIStatus(warning));
                        warning = warning.getNextWarning();
                    }
                }
                catch (SQLException e) {
                    block51: {
                        statuses.add(JdbcUtil.createIStatus(e));
                        if (resultSet != null) {
                            try {
                                try {
                                    resultSet.close();
                                }
                                catch (SQLException e2) {
                                    statuses.add(JdbcUtil.createIStatus(e2));
                                    resultSet = null;
                                    break block51;
                                }
                            }
                            catch (Throwable throwable) {
                                resultSet = null;
                                throw throwable;
                            }
                            resultSet = null;
                        }
                    }
                    if (statement == null) break block52;
                    try {
                        try {
                            statement.close();
                        }
                        catch (SQLException e3) {
                            statuses.add(JdbcUtil.createIStatus(e3));
                            statement = null;
                            break block52;
                        }
                    }
                    catch (Throwable throwable) {
                        statement = null;
                        throw throwable;
                    }
                    statement = null;
                    break block52;
                }
                catch (Throwable e) {
                    try {
                        statuses.add(JdbcUtil.createIStatus(e));
                        break block52;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block57: {
                            block55: {
                                if (resultSet != null) {
                                    try {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (SQLException e4) {
                                            statuses.add(JdbcUtil.createIStatus(e4));
                                            resultSet = null;
                                            break block55;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        resultSet = null;
                                        throw throwable;
                                    }
                                    resultSet = null;
                                }
                            }
                            if (statement != null) {
                                try {
                                    try {
                                        statement.close();
                                    }
                                    catch (SQLException e5) {
                                        statuses.add(JdbcUtil.createIStatus(e5));
                                        statement = null;
                                        break block57;
                                    }
                                }
                                catch (Throwable throwable) {
                                    statement = null;
                                    throw throwable;
                                }
                                statement = null;
                            }
                        }
                    }
                }
                if (resultSet == null) break block58;
                try {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        statuses.add(JdbcUtil.createIStatus(e));
                        resultSet = null;
                        break block58;
                    }
                }
                catch (Throwable throwable) {
                    resultSet = null;
                    throw throwable;
                }
                resultSet = null;
            }
            if (statement != null) {
                try {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        statuses.add(JdbcUtil.createIStatus(e));
                        statement = null;
                        break block52;
                    }
                }
                catch (Throwable throwable) {
                    statement = null;
                    throw throwable;
                }
                statement = null;
            }
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        if (statuses.size() > 1) {
            String text = JdbcPlugin.Util.getString("QueryRequest.Error_while_processing_sql_against_connection", new Object[]{this.sql, conn});
            return JdbcUtil.createIStatus(statuses, text);
        }
        return null;
    }
}

