/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcFactory;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcManagerImpl;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.metadata.Includes;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.impl.ImportSettingsSelectionVisitor;
import org.teiid.designer.jdbc.metadata.impl.JdbcDatabaseImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeSelections;

public class JdbcPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.jdbc";
    public static final String PACKAGE_ID = JdbcPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final PluginUtil Util = new PluginUtilImpl("org.teiid.designer.jdbc", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    private static final ResourceLocator RESOURCE_LOCATOR = new ResourceLocator(){

        public URL getBaseURL() {
            if (INSTANCE != null) {
                URL baseUrl;
                try {
                    baseUrl = FileLocator.resolve((URL)INSTANCE.getBundle().getEntry("/"));
                }
                catch (IOException iOException) {
                    baseUrl = null;
                }
                return baseUrl;
            }
            try {
                URI uri = URI.createURI((String)this.getClass().getResource("plugin.properties").toString());
                URL baseUrl = new URL(String.valueOf(uri.trimSegments(1).toString()) + "/");
                return baseUrl;
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
        }

        public Object getImage(String key) {
            try {
                URL baseUrl = this.getBaseURL();
                URL url = new URL(baseUrl + "icons/" + key + ".gif");
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (MalformedURLException exception) {
                throw new WrappedException((Exception)exception);
            }
            catch (IOException iOException) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
            }
        }

        public String getString(String key) {
            return Util.getString(key, new Object[0]);
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions) {
            return Util.getString(key, substitutions);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key, substitutions);
        }
    };
    static JdbcPlugin INSTANCE = null;
    private static JdbcManagerImpl jdbcMgr;
    public static boolean DEBUG;

    static {
        DEBUG = false;
    }

    public static JdbcManager getJdbcManager() {
        if (jdbcMgr == null) {
            jdbcMgr = new JdbcManagerImpl(Util.getString("jdbcManagerName", new Object[0]));
            jdbcMgr.start();
        }
        return jdbcMgr;
    }

    public static JdbcImportSettings ensureNonNullImportSettings(JdbcSource source) {
        CoreArgCheck.isNotNull((Object)source);
        JdbcImportSettings settings = source.getImportSettings();
        if (settings == null) {
            settings = JdbcFactory.eINSTANCE.createJdbcImportSettings();
            source.setImportSettings(settings);
        }
        return settings;
    }

    public static JdbcDatabase getJdbcDatabase(JdbcSource source, Connection connection) {
        IStatus status;
        CoreArgCheck.isNotNull((Object)source);
        CoreArgCheck.isNotNull((Object)connection);
        JdbcNodeSelections selectionsCache = new JdbcNodeSelections();
        JdbcImportSettings settings = source.getImportSettings();
        if (settings != null) {
            selectionsCache.initialize(settings);
        }
        boolean existingSelections = selectionsCache.hasSelectionModes();
        JdbcDatabaseImpl result = new JdbcDatabaseImpl(connection, source.getName(), selectionsCache);
        if (!existingSelections && (status = result.selectDefaultNodes(source.getUsername())).getSeverity() == 4) {
            Util.log(status);
        }
        if (settings != null) {
            Includes includes = result.getIncludes();
            EList includedTableTypes = settings.getIncludedTableTypes();
            String[] typesToInclude = includedTableTypes.toArray(new String[includedTableTypes.size()]);
            includes.setIncludedTableTypes(typesToInclude);
            includes.setApproximateIndexes(settings.isIncludeApproximateIndexes());
            includes.setIncludeForeignKeys(settings.isIncludeForeignKeys());
            includes.setIncludeIndexes(settings.isIncludeIndexes());
            includes.setIncludeProcedures(settings.isIncludeProcedures());
            includes.setUniqueIndexesOnly(settings.isIncludeUniqueIndexes());
        }
        return result;
    }

    public static ResourceLocator getPluginResourceLocator() {
        return RESOURCE_LOCATOR;
    }

    public static void recordJdbcDatabaseSelections(JdbcSource source, JdbcDatabase database) throws JdbcException {
        CoreArgCheck.isNotNull((Object)source);
        CoreArgCheck.isNotNull((Object)database);
        JdbcImportSettings settings = JdbcPlugin.ensureNonNullImportSettings(source);
        ImportSettingsSelectionVisitor visitor = new ImportSettingsSelectionVisitor(settings);
        database.accept(visitor, 2);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        JdbcManager mgr = JdbcManagerImpl.get();
        if (mgr != null && mgr instanceof JdbcManagerImpl) {
            ((JdbcManagerImpl)mgr).shutdown();
        }
        if (jdbcMgr != null) {
            jdbcMgr.shutdown();
        }
        super.stop(context);
    }
}

