/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.emf.common.util.EList;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.jdbc.JdbcDriver;
import org.teiid.designer.jdbc.JdbcDriverContainer;
import org.teiid.designer.jdbc.JdbcDriverProperty;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcFactory;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.JdbcSourceContainer;
import org.teiid.designer.jdbc.JdbcSourceProperty;
import org.teiid.designer.jdbc.impl.JdbcFactoryImpl;

public class JdbcManagerImpl
implements JdbcManager {
    public static final int MISSING_DRIVER_CLASS = 1001;
    public static final int VALID_SOURCE = 1002;
    public static final int NAME_NOT_SPECIFIED = 1003;
    public static final int NAME_MUST_BEGIN_WITH_LETTER_OR_NUMBER = 1004;
    public static final int NO_AVAILABLE_DRIVER_CLASS_NAMES = 1005;
    public static final int PREFERRED_NOT_SPECIFIED = 1006;
    public static final int PREFERRED_NOT_IN_AVAILABLE = 1007;
    public static final int NO_JARS_SPECIFIED = 1008;
    public static final int VALID_DRIVER = 1009;
    public static final int ILLEGAL_CHAR_AT_START_OF_CLASS_NAME = 1010;
    public static final int ILLEGAL_CHAR_IN_CLASS_NAME = 1011;
    public static final int JAR_FILE_URI_NOT_SPECIFIED = 1012;
    public static final int JAR_FILE_DOESNT_EXIST = 1013;
    public static final int MALFORMED_URL = 1014;
    public static final int PROPERTY_NAME_MISSING = 1015;
    public static final int PROPERTY_VALUE_MISSING = 1016;
    public static final int ERROR_BUILDING_CLASSLOADER = 1017;
    public static final int UNABLE_TO_FIND_DRIVER = 1018;
    public static final int ERROR_CHECKING_DRIVER_CLASS = 1019;
    public static final int URL_NOT_SPECIFIED = 1020;
    public static final int URL_MUST_START_WITH_JDBC = 1021;
    public static final int ERROR_FINDING_DRIVER_CLASS = 1022;
    public static final int MALFORMED_URL_SYNTAX = 1023;
    public static final int INVALID_CONNECTION_PROFILE = 1024;
    public static final int MISSING_CONNECTION_PROFILE = 1025;
    public static final int AVAILABLE_CLASSES_COMPLETE = 1100;
    public static final int AVAILABLE_CLASSES_WITH_WARNINGS = 1102;
    public static final int AVAILABLE_CLASSES_WITH_ERRORS = 1103;
    public static final int AVAILABLE_CLASSES_WITH_WARNINGS_AND_ERRORS = 1104;
    private static final String DATATOOLS_ORACLE_CP = "org.eclipse.datatools.enablement.oracle.connectionProfile";
    private static final String DATATOOLS_CONNECTION_PROPS_KEY = "org.eclipse.datatools.connectivity.db.connectionProperties";
    private static final String ORACLE_INCLUDE_SYNONYMS_PROP = "includeSynonyms";
    public static final String JDBC_MODEL = "jdbcModel.xmi";
    private static JdbcManager shared;
    private final String name;
    private JdbcDriverContainer drivers;
    private JdbcSourceContainer sources;
    private final Object driversLock = new Object();
    private final Object sourcesLock = new Object();
    private ProfileManager profileManager;
    private DriverManager driverManager;
    private boolean sourcesUpdated;
    private boolean driversUpdated;
    private ProfileListener profileListener;

    public static JdbcManager create(String name) {
        if (shared == null) {
            JdbcManagerImpl mgr = new JdbcManagerImpl(name);
            mgr.start();
            shared = mgr;
        }
        return shared;
    }

    public static JdbcManager get() {
        return shared;
    }

    public JdbcManagerImpl(String name) {
        CoreArgCheck.isNotNull((Object)name);
        CoreArgCheck.isNotZeroLength((String)name);
        this.name = name;
    }

    protected IStatus checkClassNameForError(String className) {
        if (className == null || className.trim().length() == 0) {
            return this.createError(1003, JdbcPlugin.Util.getString("JdbcManagerImpl.The_class_name_is_empty", new Object[0]));
        }
        if (!Character.isJavaIdentifierStart(className.charAt(0))) {
            Object[] params = new Object[]{new Character(className.charAt(0))};
            return this.createError(1010, JdbcPlugin.Util.getString("JdbcManagerImpl.A_Java_class_may_not_begin_with_the_{0}_character", (Object)params));
        }
        StringCharacterIterator iter = new StringCharacterIterator(className);
        char c = iter.next();
        while ((c = iter.next()) != '\uffff') {
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            Object[] params = new Object[]{new Character(className.charAt(0))};
            return this.createError(1011, JdbcPlugin.Util.getString("JdbcManagerImpl.A_Java_class_may_not_contain_the_{0}_character", (Object)params));
        }
        return null;
    }

    @Override
    public Connection createConnection(JdbcSource jdbcSource, String password) throws JdbcException, SQLException {
        IConnection connection;
        Connection sqlConnection;
        IConnectionProfile profile = this.profileManager.getProfileByName(jdbcSource.getName());
        if (profile == null) {
            throw new JdbcException(JdbcPlugin.Util.getString("JdbcManagerImpl.ConnectionProfile_{0}_cannot_be_found", new Object[0]));
        }
        String factoryId = profile.getProvider().getConnectionFactory("java.sql.Connection").getId();
        String providerId = profile.getProviderId();
        if (providerId != null && providerId.equalsIgnoreCase(DATATOOLS_ORACLE_CP)) {
            Properties baseProps = profile.getBaseProperties();
            String connectionProps = baseProps.getProperty(DATATOOLS_CONNECTION_PROPS_KEY);
            if (CoreStringUtil.isEmpty((String)connectionProps)) {
                baseProps.setProperty(DATATOOLS_CONNECTION_PROPS_KEY, "includeSynonyms=true");
                profile.setBaseProperties(baseProps);
            } else if (connectionProps.indexOf(ORACLE_INCLUDE_SYNONYMS_PROP) == -1) {
                connectionProps = String.valueOf(connectionProps) + "," + ORACLE_INCLUDE_SYNONYMS_PROP + "=true";
                baseProps.setProperty(DATATOOLS_CONNECTION_PROPS_KEY, connectionProps);
                profile.setBaseProperties(baseProps);
            }
        }
        if ((sqlConnection = (Connection)(connection = profile.createConnection(factoryId)).getRawConnection()) == null || sqlConnection.isClosed()) {
            Throwable e = connection.getConnectException();
            throw new JdbcException(e == null ? JdbcPlugin.Util.getString("JdbcManagerImpl.Unspecified_connection_error", new Object[0]) : e.getMessage());
        }
        return (Connection)connection.getRawConnection();
    }

    @Override
    public Connection createConnection(JdbcSource jdbcSource, String password, IProgressMonitor monitor) throws JdbcException, SQLException {
        return this.createConnection(jdbcSource, password);
    }

    protected IStatus createError(int code, String msg) {
        return new Status(4, "org.teiid.designer.jdbc", code, msg, null);
    }

    protected IStatus createOK(int code, String msg) {
        return new Status(0, "org.teiid.designer.jdbc", code, msg, null);
    }

    protected Properties createProperties(JdbcSource jdbcSource) {
        Properties props = new Properties();
        for (JdbcSourceProperty prop : jdbcSource.getProperties()) {
            props.put(prop.getName().toLowerCase(), prop.getValue());
        }
        return props;
    }

    protected IStatus createWarning(int code, String msg) {
        return new Status(2, "org.teiid.designer.jdbc", code, msg, null);
    }

    protected IStatus createWarning(int code, Throwable t, String msg) {
        return new Status(2, "org.teiid.designer.jdbc", code, msg, t);
    }

    @Override
    public JdbcDriver[] findDrivers(String driverName) {
        ArrayList<JdbcDriver> result = new ArrayList<JdbcDriver>();
        List instances = this.getJdbcDrivers();
        for (JdbcDriver instance : instances) {
            if (!instance.getName().equalsIgnoreCase(driverName)) continue;
            result.add(instance);
        }
        return result.toArray(new JdbcDriver[result.size()]);
    }

    @Override
    public JdbcSource[] findSources(String sourceName) {
        ArrayList<JdbcSource> result = new ArrayList<JdbcSource>();
        List instances = this.getJdbcSources();
        for (JdbcSource instance : instances) {
            if (!instance.getName().equalsIgnoreCase(sourceName)) continue;
            result.add(instance);
        }
        return result.toArray(new JdbcSource[result.size()]);
    }

    @Override
    public JdbcFactory getFactory() {
        return JdbcFactory.eINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getJdbcDrivers() {
        if (this.driversUpdated) {
            Object object = this.driversLock;
            synchronized (object) {
                DriverInstance[] tempDrivers;
                this.driversUpdated = false;
                JdbcFactoryImpl factory = new JdbcFactoryImpl();
                this.drivers = factory.createJdbcDriverContainer();
                DriverInstance[] driverInstanceArray = tempDrivers = this.driverManager.getDriverInstancesByCategory("org.eclipse.datatools.connectivity.db.category");
                int n = tempDrivers.length;
                int n2 = 0;
                while (n2 < n) {
                    DriverInstance driverInstance = driverInstanceArray[n2];
                    JdbcDriver driver = factory.createJdbcDriver();
                    driver.setName(driverInstance.getName());
                    driver.setPreferredDriverClassName(driverInstance.getNamedPropertyByID("org.eclipse.datatools.connectivity.db.driverClass"));
                    driver.setUrlSyntax(driverInstance.getNamedPropertyByID("org.eclipse.datatools.connectivity.db.URL"));
                    driver.setJdbcDriverContainer(this.drivers);
                    this.drivers.getJdbcDrivers().add((Object)driver);
                    ++n2;
                }
            }
        }
        return this.drivers.getJdbcDrivers();
    }

    @Override
    public JdbcSource getJdbcSource(IConnectionProfile profile) {
        JdbcSource source = new JdbcFactoryImpl().createJdbcSource();
        source.setName(profile.getName());
        Properties props = profile.getBaseProperties();
        source.setDriverClass(props.getProperty("org.eclipse.datatools.connectivity.db.driverClass"));
        source.setUsername(props.getProperty("org.eclipse.datatools.connectivity.db.username"));
        source.setUrl(props.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        String password = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        if (password != null) {
            source.setPassword(password);
        }
        String driverID = props.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        DriverInstance driver = this.driverManager.getDriverInstanceByID(driverID);
        source.setDriverName(driver.getName());
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getJdbcSources() {
        if (this.sourcesUpdated) {
            Object object = this.sourcesLock;
            synchronized (object) {
                this.sourcesUpdated = false;
                JdbcFactoryImpl factory = new JdbcFactoryImpl();
                this.sources = factory.createJdbcSourceContainer();
                IConnectionProfile[] tempProfiles = this.profileManager.getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
                if (this.sourcesUpdated) {
                    return this.getJdbcSources();
                }
                IConnectionProfile[] iConnectionProfileArray = tempProfiles;
                int n = tempProfiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionProfile profile = iConnectionProfileArray[n2];
                    JdbcSource source = this.getJdbcSource(profile);
                    source.setJdbcSourceContainer(this.sources);
                    this.sources.getJdbcSources().add((Object)source);
                    ++n2;
                }
            }
        }
        return this.sources.getJdbcSources();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected JdbcDriverProperty[] getPropertyDescriptions(DataSource dataSource, JdbcSource jdbcSource) {
        Method[] methods = dataSource.getClass().getMethods();
        ArrayList<JdbcDriverProperty> props = new ArrayList<JdbcDriverProperty>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterTypes().length == 1) {
                String name = methodName.substring(3);
                String desc = null;
                String[] allowableValues = null;
                JdbcDriverProperty prop = new JdbcDriverProperty(name, desc, allowableValues, true);
                props.add(prop);
            }
            ++n2;
        }
        return props.toArray(new JdbcDriverProperty[props.size()]);
    }

    protected JdbcDriverProperty[] getPropertyDescriptions(Driver driver, JdbcSource jdbcSource) throws SQLException {
        CoreArgCheck.isNotNull((Object)driver);
        CoreArgCheck.isNotNull((Object)jdbcSource);
        DriverPropertyInfo[] propInfo = null;
        String url = jdbcSource.getUrl() != null ? jdbcSource.getUrl() : "";
        try {
            propInfo = driver.getPropertyInfo(url, null);
        }
        catch (RuntimeException runtimeException) {
            try {
                propInfo = driver.getPropertyInfo(url, new Properties());
            }
            catch (RuntimeException runtimeException2) {}
        }
        if (propInfo == null || propInfo.length == 0) {
            return new JdbcDriverProperty[0];
        }
        ArrayList<JdbcDriverProperty> props = new ArrayList<JdbcDriverProperty>(propInfo.length);
        DriverPropertyInfo[] driverPropertyInfoArray = propInfo;
        int n = propInfo.length;
        int n2 = 0;
        while (n2 < n) {
            DriverPropertyInfo info = driverPropertyInfoArray[n2];
            JdbcDriverProperty prop = new JdbcDriverProperty(info);
            props.add(prop);
            ++n2;
        }
        return props.toArray(new JdbcDriverProperty[props.size()]);
    }

    @Override
    public boolean hasChanges() {
        return true;
    }

    @Override
    public IStatus isValid(JdbcDriver driver) {
        CoreArgCheck.isNotNull((Object)driver);
        return this.isValid(driver, true);
    }

    protected IStatus isValid(JdbcDriver driver, boolean checkDriverClasses) {
        CoreArgCheck.isNotNull((Object)driver);
        String name = driver.getName();
        if (name == null || name.trim().length() == 0) {
            return this.createError(1003, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_is_empty", new Object[0]));
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            return this.createError(1004, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_must_begin_with_a_letter_or_digit", new Object[0]));
        }
        if (checkDriverClasses) {
            IStatus error;
            EList availableClasses = driver.getAvailableDriverClassNames();
            if (availableClasses.isEmpty()) {
                return this.createError(1005, JdbcPlugin.Util.getString("JdbcManagerImpl.No_java.sql.Driver_or_javax.sql.DataSource_classes_were_found", (Object)name));
            }
            for (String className : availableClasses) {
                error = this.checkClassNameForError(className);
                if (error == null) continue;
                return error;
            }
            String preferred = driver.getPreferredDriverClassName();
            if (preferred == null || preferred.trim().length() == 0) {
                return this.createError(1006, JdbcPlugin.Util.getString("JdbcManagerImpl.A_preferred_driver_class_must_be_chosen", (Object)name));
            }
            error = this.checkClassNameForError(preferred);
            if (error != null) {
                return error;
            }
            if (!availableClasses.contains(preferred)) {
                return this.createError(1007, JdbcPlugin.Util.getString("JdbcManagerImpl.The_preferred_driver_class_is_not_available", (Object)name));
            }
        }
        if (driver.getJarFileUris().isEmpty()) {
            return this.createWarning(1008, JdbcPlugin.Util.getString("JdbcManagerImpl.There_are_no_JAR_files_specified.__Only_the_system_classpath_will_be_used", (Object)name));
        }
        for (String jarFileUri : driver.getJarFileUris()) {
            boolean validUrl;
            block30: {
                if (jarFileUri == null || jarFileUri.trim().length() == 0) {
                    return this.createError(1012, JdbcPlugin.Util.getString("JdbcManagerImpl.The_jar_file_uri_is_empty", (Object)name));
                }
                validUrl = false;
                InputStream stream = null;
                try {
                    try {
                        URL url = new URL(jarFileUri);
                        stream = url.openStream();
                        validUrl = true;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!validUrl) {
                try {
                    File jarFile = new File(jarFileUri);
                    if (!jarFile.exists()) {
                        String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Supplied_path_does_not_exist", new Object[]{name, jarFileUri});
                        return this.createError(1013, msg);
                    }
                    jarFile.toURI().toURL();
                    validUrl = true;
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (validUrl) continue;
            String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Unable_to_create_class_loader_for_the_driver", (Object)name);
            return this.createError(1014, msg);
        }
        String urlSyntax = driver.getUrlSyntax();
        if (urlSyntax != null && urlSyntax.trim().length() != 0 && !urlSyntax.startsWith("jdbc:")) {
            String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.malformedUrlSyntax", (Object)name);
            return this.createWarning(1023, msg);
        }
        return this.createOK(1009, JdbcPlugin.Util.getString("JdbcManagerImpl.The_driver_specification_is_valid", (Object)name));
    }

    @Override
    public IStatus isValid(JdbcSource jdbcSource) {
        CoreArgCheck.isNotNull((Object)jdbcSource);
        String name = jdbcSource.getName();
        if (name == null || name.trim().length() == 0) {
            return this.createError(1003, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_is_empty", new Object[0]));
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            return this.createError(1004, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_must_begin_with_a_letter_or_digit", new Object[0]));
        }
        String driverClass = jdbcSource.getDriverClass();
        if (driverClass == null || driverClass.trim().length() == 0) {
            return this.createError(1001, JdbcPlugin.Util.getString("JdbcManagerImpl.A_driver_class_must_be_specified", (Object)jdbcSource.getName()));
        }
        IStatus error = this.checkClassNameForError(driverClass);
        if (error != null) {
            return error;
        }
        for (JdbcSourceProperty prop : jdbcSource.getProperties()) {
            String propName = prop.getName();
            String value = prop.getValue();
            if (propName == null || propName.trim().length() == 0) {
                return this.createError(1015, JdbcPlugin.Util.getString("JdbcManagerImpl.Property_names_may_not_be_null_or_empty", new Object[0]));
            }
            if (value != null && value.trim().length() != 0) continue;
            return this.createError(1016, JdbcPlugin.Util.getString("JdbcManagerImpl.Property_values_may_not_be_null_or_empty", new Object[0]));
        }
        IConnectionProfile profile = this.profileManager.getProfileByName(jdbcSource.getName());
        if (profile == null) {
            return this.createError(1025, JdbcPlugin.Util.getString("JdbcManagerImpl.Missing_connection_profile", (Object)jdbcSource.getName()));
        }
        if (!profile.arePropertiesComplete()) {
            return this.createError(1024, JdbcPlugin.Util.getString("JdbcManagerImpl.Invalid_connection_profile", (Object)jdbcSource.getName()));
        }
        return this.createOK(1002, JdbcPlugin.Util.getString("JdbcManagerImpl.The_data_source_is_valid", new Object[0]));
    }

    @Override
    public void reload(IProgressMonitor monitor) {
        this.sourcesUpdated = true;
        this.driversUpdated = true;
    }

    @Override
    public void saveChanges(IProgressMonitor monitor) {
        if (!this.hasChanges()) {
            return;
        }
    }

    protected void setProperties(Properties props, DataSource dataSource) throws JdbcException {
        Method[] methods;
        Method[] methodArray = methods = dataSource.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName;
            String propertyValue;
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterTypes().length == 1 && (propertyValue = (String)props.get((propertyName = methodName.substring(3)).toLowerCase())) != null) {
                Class<?> argType = method.getParameterTypes()[0];
                Object[] params = new Object[1];
                if (argType == Integer.TYPE) {
                    params[0] = Integer.decode(propertyValue);
                } else if (argType == Boolean.TYPE) {
                    params[0] = Boolean.valueOf(propertyValue);
                } else if (argType == String.class) {
                    params[0] = propertyValue;
                }
                try {
                    method.invoke((Object)dataSource, params);
                }
                catch (Throwable throwable) {
                    Object[] msgParams = new Object[]{propertyName, propertyValue};
                    String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Unable_to_set_property_to_value", msgParams);
                    throw new JdbcException(msg);
                }
            }
            ++n2;
        }
    }

    @Override
    public IConnectionProfile getConnectionProfile(String profileName) {
        IConnectionProfile[] tempProfiles;
        IConnectionProfile[] iConnectionProfileArray = tempProfiles = this.profileManager.getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        int n = tempProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile profile = iConnectionProfileArray[n2];
            if (profile.getName().equals(profileName)) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    public void shutdown() {
        this.profileManager.removeProfileListener((IProfileListener)this.profileListener);
        this.profileManager = null;
        this.driverManager = null;
        this.sources = null;
        this.drivers = null;
    }

    public void start() {
        this.setProfileManager(ProfileManager.getInstance());
        this.profileListener = new ProfileListener();
        this.profileManager.addProfileListener((IProfileListener)this.profileListener);
        this.driverManager = DriverManager.getInstance();
        this.sourcesUpdated = true;
        this.driversUpdated = true;
    }

    protected void setProfileManager(ProfileManager profManager) {
        this.profileManager = profManager;
    }

    public class ProfileListener
    implements IProfileListener {
        public void profileAdded(IConnectionProfile arg0) {
            JdbcManagerImpl.this.reload((IProgressMonitor)new NullProgressMonitor());
        }

        public void profileChanged(IConnectionProfile arg0) {
            JdbcManagerImpl.this.reload((IProgressMonitor)new NullProgressMonitor());
        }

        public void profileDeleted(IConnectionProfile arg0) {
            JdbcManagerImpl.this.reload((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

