/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.model;

import java.util.Collection;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.model.MedModelNode;

public class MedLabelProvider
extends ColumnLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof MedModelNode) {
            MedModelNode node = (MedModelNode)element;
            if (node.isDescription() || node.isMetamodelUri() || node.isModelTypes() || node.isNamespacePrefix() || node.isNamespaceUri() || node.isVersion()) {
                return Activator.getDefault().getImage("icons/med-attribute.gif");
            }
            if (node.isMed()) {
                return Activator.getDefault().getImage("icons/med.png");
            }
            if (node.isMetaclass()) {
                return Activator.getDefault().getImage("icons/metaclass.png");
            }
            if (node.isPropertyDefinition()) {
                return Activator.getDefault().getImage("icons/property-definition.png");
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof MedModelNode) {
            MedModelNode node = (MedModelNode)element;
            if (node.isNamespacePrefix()) {
                return Messages.namespacePrefixNodeLabel;
            }
            if (node.isNamespaceUri()) {
                return Messages.namespaceUriNodeLabel;
            }
            if (node.isMetamodelUri()) {
                return Messages.metamodelUriNodeLabel;
            }
            if (node.isModelTypes()) {
                return Messages.modelTypesNodeLabel;
            }
            if (node.isDescription()) {
                return Messages.descriptionNodeLabel;
            }
            if (node.isVersion()) {
                return Messages.versionNodeLabel;
            }
            if (node.isMed()) {
                return Messages.medNodeLabel;
            }
            if (node.isPropertyDefinition()) {
                ModelExtensionPropertyDefinition propDefn = (ModelExtensionPropertyDefinition)node.getData();
                String id = propDefn.getSimpleId();
                return CoreStringUtil.isEmpty((String)id) ? Messages.missingPropertyIdNodeLabel : id;
            }
            if (node.isMetaclass()) {
                return node.getData().toString();
            }
        }
        return null;
    }

    public Image getToolTipImage(Object object) {
        if (CoreStringUtil.isEmpty((String)this.getToolTipText(object))) {
            return null;
        }
        return this.getImage(object);
    }

    public String getToolTipText(Object element) {
        if (element instanceof MedModelNode) {
            MedModelNode node = (MedModelNode)element;
            Object data = node.getData();
            if (node.isDescription()) {
                return CoreStringUtil.isEmpty((String)((String)data)) ? Messages.descriptionNodeNoValueToolTip : NLS.bind((String)Messages.descriptionNodeToolTip, (Object)data);
            }
            if (node.isMetamodelUri()) {
                return CoreStringUtil.isEmpty((String)((String)data)) ? Messages.metamodelUriNodeNoValueToolTip : NLS.bind((String)Messages.metamodelUriNodeToolTip, (Object)data);
            }
            if (node.isModelTypes()) {
                Collection modelTypes = (Collection)data;
                if (modelTypes.isEmpty()) {
                    return Messages.modelTypesNodeNoValueToolTip;
                }
                StringBuilder text = new StringBuilder();
                boolean firstTime = true;
                for (String modelType : modelTypes) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        text.append(", ");
                    }
                    text.append(Activator.getDefault().getModelTypeName(modelType));
                }
                return NLS.bind((String)Messages.modelTypesNodeToolTip, (Object)data);
            }
            if (node.isNamespacePrefix()) {
                return CoreStringUtil.isEmpty((String)((String)data)) ? Messages.namespacePrefixNodeNoValueToolTip : NLS.bind((String)Messages.namespacePrefixNodeToolTip, (Object)data);
            }
            if (node.isNamespaceUri()) {
                return CoreStringUtil.isEmpty((String)((String)data)) ? Messages.namespaceUriNodeNoValueToolTip : NLS.bind((String)Messages.namespaceUriNodeToolTip, (Object)data);
            }
            if (node.isVersion()) {
                return NLS.bind((String)Messages.versionNodeToolTip, (Object)data);
            }
            if (node.isMetaclass()) {
                String metaclass = node.getMetaclass();
                int index = metaclass.lastIndexOf(46);
                return NLS.bind((String)Messages.metaclassNodeToolTip, (Object)metaclass.substring(index + 1));
            }
            if (node.isPropertyDefinition()) {
                String metaclass = node.getMetaclass();
                int index = metaclass.lastIndexOf(46);
                ModelExtensionPropertyDefinition propDefn = node.getPropertyDefinition();
                return NLS.bind((String)Messages.propertyNodeToolTip, (Object)metaclass.substring(index + 1), (Object)propDefn.getSimpleId());
            }
        }
        return null;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 2000;
    }
}

