/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.teiid.designer.core.builder.AbstractTeiidProjectBuilder;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;

public final class ModelExtensionDefinitionBuilder
extends AbstractTeiidProjectBuilder {
    private static final boolean VISIT_MODELS = true;
    private static final String SAX_ERR_PREFIX = "cvc-";
    private static final String MED_VALIDATION_MSG = "MED Validation: ";
    private static final String SEE_DETAILS_MSG = " (See log for details)";
    private static final String LEGACY_CLASSNAME_PREFIX = "com.metamatrix";
    public static final String HAS_LEGACY_NAMES = "hasLegacyNames";
    public static final String HAS_OLD_REST_PREFIX = "hasOldRestPrefix";
    private ModelExtensionAssistantAggregator aggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
    private ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();

    protected IProject[] buildInternal(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        MedVisitor visitor = new MedVisitor();
        if (6 == kind || this.getDelta(project) == null) {
            this.getProject().accept((IResourceVisitor)visitor);
        } else {
            IResourceDelta delta = this.getDelta(project);
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        Collection<IFile> medFilesToBuild = visitor.getMedFiles();
        Collection<IFile> modelFilesToBuild = visitor.getModelFiles();
        monitor.beginTask(Messages.medBuildTaskName, medFilesToBuild.size() + modelFilesToBuild.size());
        if (!medFilesToBuild.isEmpty()) {
            File medSchema = null;
            try {
                medSchema = ExtensionPlugin.getInstance().getMedSchema();
            }
            catch (Exception e) {
                Status status = new Status(4, ExtensionConstants.PLUGIN_ID, Messages.medSchemaNotFoundMsg, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            ModelExtensionDefinitionParser parser = new ModelExtensionDefinitionParser(medSchema);
            MultiStatus status = new MultiStatus(ExtensionConstants.PLUGIN_ID, 4, Messages.medFileParseProblemMsg, null);
            for (IFile medFile : medFilesToBuild) {
                monitor.subTask(NLS.bind((String)Messages.medBuildSubTaskName, (Object)medFile.getName()));
                try {
                    try {
                        medFile.deleteMarkers(null, true, 2);
                        ModelExtensionDefinition med = parser.parse(medFile.getContents(), (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
                        this.createMarkers(medFile, med, parser.getErrors(), parser.getWarnings(), parser.getInfos());
                    }
                    catch (Exception e) {
                        Status parseStatus = new Status(4, ExtensionConstants.PLUGIN_ID, NLS.bind((String)Messages.medFileParseErrorMsg, (Object)medFile.getName()), (Throwable)e);
                        status.add((IStatus)parseStatus);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    throw throwable;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(1);
            }
            if (!status.isOK()) {
                UiConstants.UTIL.log((IStatus)status);
            }
        }
        if (!modelFilesToBuild.isEmpty()) {
            MultiStatus status = new MultiStatus(ExtensionConstants.PLUGIN_ID, 4, Messages.modelFilesBuildProblemMsg, null);
            for (IFile modelFile : modelFilesToBuild) {
                monitor.subTask(NLS.bind((String)Messages.modelBuildSubTaskName, (Object)modelFile.getName()));
                try {
                    try {
                        if (modelFile.exists()) {
                            modelFile.deleteMarkers(UiConstants.ExtensionIds.PROBLEM_MARKER, true, 2);
                            this.refreshModelFileMarkers(modelFile);
                        }
                    }
                    catch (Exception e) {
                        Status modelStatus = new Status(4, ExtensionConstants.PLUGIN_ID, NLS.bind((String)Messages.modelFileBuildErrorMsg, (Object)modelFile.getName()), (Throwable)e);
                        status.add((IStatus)modelStatus);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    throw throwable;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(1);
            }
            if (!status.isOK()) {
                UiConstants.UTIL.log((IStatus)status);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        MedVisitor visitor = new MedVisitor();
        this.getProject().accept((IResourceVisitor)visitor);
        try {
            Collection<IFile> medFilesToClean = visitor.getMedFiles();
            Collection<IFile> modelFilesToClean = visitor.getModelFiles();
            monitor.beginTask(Messages.medCleanTaskName, medFilesToClean.size() + modelFilesToClean.size());
            for (IFile medFile : medFilesToClean) {
                try {
                    monitor.subTask(NLS.bind((String)Messages.medCleanSubTaskName, (Object)medFile.getName()));
                    medFile.deleteMarkers(null, true, 2);
                }
                finally {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                }
            }
            for (IFile modelFile : modelFilesToClean) {
                try {
                    monitor.subTask(NLS.bind((String)Messages.medCleanSubTaskName, (Object)modelFile.getName()));
                    modelFile.deleteMarkers(UiConstants.ExtensionIds.PROBLEM_MARKER, true, 2);
                }
                finally {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createMarker(IFile file, int severity, String message, String markerId, boolean hasLegacyNames) {
        assert (file != null) : "file is null";
        assert (message != null && !message.isEmpty()) : "message is empty";
        if (severity == 2) {
            String originalMessage = message;
            if (message.trim().startsWith(SAX_ERR_PREFIX)) {
                int index1 = message.indexOf(58);
                int index2 = message.indexOf(46, index1);
                StringBuffer sb = new StringBuffer(MED_VALIDATION_MSG);
                sb.append(message.substring(index1 + 1, index2 + 1));
                sb.append(SEE_DETAILS_MSG);
                message = sb.toString();
            }
            UiConstants.UTIL.log(4, MED_VALIDATION_MSG + originalMessage);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("severity", severity);
        attributes.put("message", message);
        if (hasLegacyNames) {
            attributes.put(HAS_LEGACY_NAMES, true);
        }
        if (message.indexOf("\"rest\"") > -1 && message.indexOf("is not registered in workspace") > -1) {
            attributes.put(HAS_OLD_REST_PREFIX, true);
        }
        try {
            MarkerUtilities.createMarker((IResource)file, attributes, (String)markerId);
        }
        catch (CoreException e) {
            UiConstants.UTIL.log((Throwable)e);
        }
    }

    private void createMarkers(IFile medFile, ModelExtensionDefinition med, Collection<String> errors, Collection<String> warnings, Collection<String> infos) throws Exception {
        assert (medFile != null) : "medFile is null";
        assert (errors != null) : "errors is null";
        assert (warnings != null) : "warnings is null";
        assert (infos != null) : "infos is null";
        for (String message : errors) {
            this.createMarker(medFile, 2, message, UiConstants.ExtensionIds.PROBLEM_MARKER, false);
        }
        for (String message : warnings) {
            this.createMarker(medFile, 1, message, UiConstants.ExtensionIds.PROBLEM_MARKER, false);
        }
        for (String message : infos) {
            this.createMarker(medFile, 0, message, UiConstants.ExtensionIds.PROBLEM_MARKER, false);
        }
        if (this.medHasLegacyClassnames(med)) {
            this.createMarker(medFile, 2, Messages.medFileHasLegacyClassnames, UiConstants.ExtensionIds.PROBLEM_MARKER, true);
        }
    }

    private boolean medsAreEqual(ModelExtensionDefinition thisMed, ModelExtensionDefinition thatMed) {
        return thisMed.equals((Object)thatMed);
    }

    private boolean medHasLegacyClassnames(ModelExtensionDefinition theMed) {
        boolean hasLegacyClassnames = false;
        Map propMap = theMed.getPropertyDefinitions();
        Set mapKeys = propMap.keySet();
        for (String mapKey : mapKeys) {
            if (!mapKey.startsWith(LEGACY_CLASSNAME_PREFIX)) continue;
            hasLegacyClassnames = true;
            break;
        }
        return hasLegacyClassnames;
    }

    void refreshModelFileMarkers(IFile modelFile) throws Exception {
        for (String namespacePrefix : this.aggregator.getSupportedNamespacePrefixes((Object)modelFile)) {
            ModelExtensionAssistant temp = this.registry.getModelExtensionAssistant(namespacePrefix);
            if (temp == null || !(temp instanceof ModelObjectExtensionAssistant)) {
                this.createMarker(modelFile, 1, NLS.bind((String)Messages.modelMedNotFoundInRegistry, (Object)namespacePrefix), UiConstants.ExtensionIds.PROBLEM_MARKER, false);
                continue;
            }
            ModelObjectExtensionAssistant registryAssistant = (ModelObjectExtensionAssistant)temp;
            ModelExtensionDefinition registryMed = registryAssistant.getModelExtensionDefinition();
            ModelObjectExtensionAssistant modelAssistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant(namespacePrefix);
            ModelExtensionDefinition modelMed = modelAssistant.getModelExtensionDefinition((Object)modelFile);
            if (this.medHasLegacyClassnames(modelMed)) {
                this.createMarker(modelFile, 2, Messages.modelMedHasLegacyClassnames, UiConstants.ExtensionIds.PROBLEM_MARKER, true);
                return;
            }
            if (this.medsAreEqual(registryMed, modelMed)) continue;
            this.createMarker(modelFile, 1, NLS.bind((String)Messages.modelMedDifferentVersionThanOneFoundInRegistry, (Object)namespacePrefix), UiConstants.ExtensionIds.PROBLEM_MARKER, false);
        }
    }

    class MedVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private Collection<IFile> medFiles = new ArrayList<IFile>();
        private Collection<IFile> modelFiles = new ArrayList<IFile>();

        MedVisitor() {
        }

        public Collection<IFile> getMedFiles() {
            return this.medFiles;
        }

        public Collection<IFile> getModelFiles() {
            return this.modelFiles;
        }

        private boolean isMedFile(IResource resource) {
            return resource.getType() == 1 && "mxd".equals(resource.getFileExtension()) && resource.exists();
        }

        private boolean isModelFile(IResource resource) {
            return ModelUtil.isModelFile((IResource)resource);
        }

        public boolean visit(IResource resource) {
            if (this.isMedFile(resource)) {
                this.medFiles.add((IFile)resource);
            } else if (this.isModelFile(resource)) {
                this.modelFiles.add((IFile)resource);
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (this.isMedFile(resource)) {
                this.medFiles.add((IFile)resource);
            } else if (this.isModelFile(resource)) {
                this.modelFiles.add((IFile)resource);
            }
            return true;
        }
    }
}

