/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.esb.core.runtime.IESBRuntimeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractESBRuntimeResolver
implements IESBRuntimeResolver {
    protected static final String JBOSSESB_ESB = "jbossesb.esb";
    protected static final String JBOSSESB_SAR = "jbossesb.sar";
    protected static final String SOAP_AS_LOCATION = "jboss-as";
    protected static final String ROSETTA_JAR = "jbossesb-rosetta.jar";
    protected static final String RIFTSAWESB_ESB = "riftsaw-esb.esb";

    @Override
    public List<IPath> getJarDirectories(String runtimeLocation, String configuration) {
        if ("".equals(configuration)) {
            configuration = "default";
        }
        ArrayList<IPath> directories = new ArrayList<IPath>();
        Path rtHome = new Path(runtimeLocation);
        IPath soapDeployPath = rtHome.append(SOAP_AS_LOCATION).append("server").append(configuration).append("deploy");
        IPath deployPath = rtHome.append("server").append(configuration).append("deploy");
        IPath esbPath = deployPath.append(JBOSSESB_ESB);
        IPath sarPath = deployPath.append(JBOSSESB_SAR);
        IPath riftsawESBPath = deployPath.append(RIFTSAWESB_ESB);
        IPath libPath = rtHome.append("lib");
        directories.add(esbPath);
        directories.add(sarPath.append("lib"));
        directories.add(riftsawESBPath.append("lib"));
        directories.add(libPath.append(JBOSSESB_ESB));
        directories.add(libPath.append(JBOSSESB_SAR).append("lib"));
        directories.add(soapDeployPath.append(JBOSSESB_ESB));
        directories.add(soapDeployPath.append(JBOSSESB_SAR).append("lib"));
        return directories;
    }

    @Override
    public File getRosettaJar(String runtimeLocation, String configuration) {
        List<File> jars = this.getAllRuntimeJars(runtimeLocation, configuration);
        for (File file : jars) {
            if (!file.getName().equals(ROSETTA_JAR)) continue;
            return file;
        }
        return null;
    }

    @Override
    public List<File> getAllRuntimeJars(String runtimeLocation, String configuration) {
        List<File> jarList = new ArrayList<File>();
        for (IPath dir : this.getJarDirectories(runtimeLocation, configuration)) {
            ArrayList<File> tmpJarList = new ArrayList();
            if (!dir.toFile().exists()) continue;
            tmpJarList = this.getJarsOfFolder(dir.toFile());
            jarList = this.mergeJarList(jarList, tmpJarList);
        }
        return jarList;
    }

    private List<File> getJarsOfFolder(File folder) {
        ArrayList<File> jars = new ArrayList<File>();
        if (folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                    jars.add(file);
                } else if (folder.isDirectory()) {
                    jars.addAll(this.getJarsOfFolder(file));
                }
                ++n2;
            }
        }
        return jars;
    }

    private List<File> mergeJarList(List<File> jarList1, List<File> jarList2) {
        ArrayList<File> duplicateList = new ArrayList<File>();
        for (File file : jarList1) {
            for (File file2 : jarList2) {
                if (!file.getName().equals(file2.getName())) continue;
                duplicateList.add(file);
            }
        }
        jarList1.removeAll(duplicateList);
        jarList1.addAll(jarList2);
        return jarList1;
    }
}

