/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.value.Value;

abstract class TreeEnumeration
implements AxisIterator,
LookaheadIterator {
    protected NodeImpl start;
    protected NodeImpl next;
    protected NodeTest nodeTest;
    protected NodeImpl current = null;
    protected int position = 0;

    public TreeEnumeration(NodeImpl origin, NodeTest nodeTest) {
        this.next = origin;
        this.start = origin;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl node) {
        if (node == null || this.nodeTest == null) {
            return true;
        }
        return this.nodeTest.matches(node);
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step();

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public boolean moveNext() {
        return this.next() != null;
    }

    @Override
    public final Item next() {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    @Override
    public final Item current() {
        return this.current;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current.iterateAxis(axis, test);
    }

    @Override
    public Value atomize() throws XPathException {
        return this.current.atomize();
    }

    @Override
    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

