/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

final class SiblingEnumeration
extends AxisIteratorImpl
implements LookaheadIterator {
    private TinyTree tree;
    private int nextNodeNr;
    private NodeTest test;
    private TinyNodeImpl startNode;
    private TinyNodeImpl parentNode;
    private boolean getChildren;
    private boolean needToAdvance = false;

    SiblingEnumeration(TinyTree tree, TinyNodeImpl node, NodeTest nodeTest, boolean getChildren) {
        this.tree = tree;
        this.test = nodeTest;
        this.startNode = node;
        this.getChildren = getChildren;
        if (getChildren) {
            this.parentNode = node;
            this.nextNodeNr = node.nodeNr + 1;
        } else {
            this.parentNode = (TinyNodeImpl)node.getParent();
            if (this.parentNode == null) {
                this.nextNodeNr = -1;
            } else {
                this.nextNodeNr = tree.next[node.nodeNr];
                while (tree.nodeKind[this.nextNodeNr] == 12) {
                    this.nextNodeNr = tree.next[this.nextNodeNr];
                }
                if (this.nextNodeNr < node.nodeNr) {
                    this.nextNodeNr = -1;
                }
            }
        }
        if (this.nextNodeNr >= 0 && nodeTest != null && !nodeTest.matches(this.tree, this.nextNodeNr)) {
            this.needToAdvance = true;
        }
    }

    @Override
    public boolean moveNext() {
        this.current = null;
        if (this.needToAdvance) {
            int thisNode = this.nextNodeNr;
            if (this.test == null) {
                do {
                    this.nextNodeNr = this.tree.next[this.nextNodeNr];
                } while (this.tree.nodeKind[this.nextNodeNr] == 12);
            } else {
                do {
                    this.nextNodeNr = this.tree.next[this.nextNodeNr];
                } while (this.nextNodeNr >= thisNode && !this.test.matches(this.tree, this.nextNodeNr));
            }
            if (this.nextNodeNr < thisNode) {
                this.nextNodeNr = -1;
                this.needToAdvance = false;
                this.current = null;
                this.position = -1;
                return false;
            }
        }
        if (this.nextNodeNr == -1) {
            return false;
        }
        this.needToAdvance = true;
        ++this.position;
        return true;
    }

    @Override
    public Item next() {
        if (this.needToAdvance) {
            int thisNode = this.nextNodeNr;
            if (this.test == null) {
                do {
                    this.nextNodeNr = this.tree.next[this.nextNodeNr];
                } while (this.tree.nodeKind[this.nextNodeNr] == 12);
            } else {
                do {
                    this.nextNodeNr = this.tree.next[this.nextNodeNr];
                } while (this.nextNodeNr >= thisNode && !this.test.matches(this.tree, this.nextNodeNr));
            }
            if (this.nextNodeNr < thisNode) {
                this.nextNodeNr = -1;
                this.needToAdvance = false;
                this.current = null;
                this.position = -1;
                return null;
            }
        }
        if (this.nextNodeNr == -1) {
            return null;
        }
        this.needToAdvance = true;
        ++this.position;
        this.current = this.tree.getNode(this.nextNodeNr);
        ((TinyNodeImpl)this.current).setParentNode(this.parentNode);
        return this.current;
    }

    @Override
    public Item current() {
        if (this.current == null) {
            if (this.nextNodeNr == -1) {
                return null;
            }
            this.current = this.tree.getNode(this.nextNodeNr);
            ((TinyNodeImpl)this.current).setParentNode(this.parentNode);
        }
        return this.current;
    }

    @Override
    public boolean hasNext() {
        int n = this.nextNodeNr;
        if (this.needToAdvance) {
            if (this.test == null) {
                while (this.tree.nodeKind[n = this.tree.next[n]] == 12) {
                }
            } else {
                while ((n = this.tree.next[n]) >= this.nextNodeNr && !this.test.matches(this.tree, n)) {
                }
            }
            if (n < this.nextNodeNr) {
                return false;
            }
        }
        return n != -1;
    }

    @Override
    public Value atomize() throws XPathException {
        byte kind;
        try {
            kind = this.tree.nodeKind[this.nextNodeNr];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NullPointerException();
        }
        switch (kind) {
            case 3: {
                return new UntypedAtomicValue(TinyTextImpl.getStringValue(this.tree, this.nextNodeNr));
            }
            case 4: {
                return new UntypedAtomicValue(WhitespaceTextImpl.getStringValueCS(this.tree, this.nextNodeNr));
            }
            case 1: {
                return this.tree.getTypedValueOfElement(this.nextNodeNr);
            }
            case 7: 
            case 8: {
                return this.tree.getAtomizedValueOfUntypedNode(this.nextNodeNr);
            }
        }
        return ((NodeInfo)this.current()).atomize();
    }

    @Override
    public CharSequence getStringValue() {
        byte kind;
        try {
            kind = this.tree.nodeKind[this.nextNodeNr];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NullPointerException();
        }
        switch (kind) {
            case 3: {
                return TinyTextImpl.getStringValue(this.tree, this.nextNodeNr);
            }
            case 4: {
                return WhitespaceTextImpl.getStringValueCS(this.tree, this.nextNodeNr);
            }
            case 1: {
                return TinyParentNodeImpl.getStringValueCS(this.tree, this.nextNodeNr);
            }
        }
        return this.current().getStringValueCS();
    }

    @Override
    public SequenceIterator getAnother() {
        return new SiblingEnumeration(this.tree, this.startNode, this.test, this.getChildren);
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

