/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.aspects.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;

public class XmlDocumentMappingHelper {
    private final List treeMappingRoots;
    private final Map xmlDocNodeToMappingClassColumn;
    private final Map xmlDocNodeToMappingClass;
    private final Map xmlDocNodeToStagingTables;

    public XmlDocumentMappingHelper(List treeMappingRoots) {
        CoreArgCheck.isNotNull((Object)treeMappingRoots);
        this.treeMappingRoots = treeMappingRoots;
        this.xmlDocNodeToMappingClassColumn = new HashMap();
        this.xmlDocNodeToMappingClass = new HashMap();
        this.xmlDocNodeToStagingTables = new HashMap();
    }

    public void initialize() {
        this.xmlDocNodeToMappingClass.clear();
        this.xmlDocNodeToMappingClassColumn.clear();
        for (TreeMappingRoot treeMappingRoot : this.treeMappingRoots) {
            this.process((Mapping)treeMappingRoot);
        }
    }

    public MappingClassColumn getMappingClassColumn(XmlDocumentEntity xmlNode) {
        return (MappingClassColumn)this.xmlDocNodeToMappingClassColumn.get(xmlNode);
    }

    public MappingClass getMappingClass(XmlDocumentEntity xmlNode) {
        return (MappingClass)this.xmlDocNodeToMappingClass.get(xmlNode);
    }

    public StagingTable[] getStagingTables(XmlDocumentEntity xmlNode) {
        return (StagingTable[])this.xmlDocNodeToStagingTables.get(xmlNode);
    }

    public MappingClass getRecusionRootMappingClass(XmlElement xmlElement) {
        MappingClass mc = (MappingClass)this.xmlDocNodeToMappingClass.get(xmlElement);
        if (mc != null && mc.isRecursionAllowed() && mc.isRecursive()) {
            XSDComponent xsdComponent = xmlElement.getXsdComponent();
            XSDTypeDefinition type = XmlDocumentUtil.findXSDType((XSDComponent)xsdComponent);
            if (xsdComponent == null) {
                return null;
            }
            EObject owner = xmlElement.eContainer();
            while (owner != null) {
                if (owner instanceof XmlElement) {
                    XSDComponent ownerXsdComponent = ((XmlElement)owner).getXsdComponent();
                    XSDTypeDefinition ownerType = XmlDocumentUtil.findXSDType((XSDComponent)ownerXsdComponent);
                    if (type != null && type == ownerType) {
                        mc = (MappingClass)this.xmlDocNodeToMappingClass.get(owner);
                        if (mc != null) {
                            return mc;
                        }
                        if (owner.eContainer() instanceof XmlContainerNode && (mc = (MappingClass)this.xmlDocNodeToMappingClass.get(owner.eContainer())) != null) {
                            return mc;
                        }
                    }
                }
                owner = owner.eContainer();
            }
        }
        return null;
    }

    protected void process(Mapping mapping) {
        EList inputs = mapping.getInputs();
        EList outputs = mapping.getOutputs();
        if (inputs.isEmpty() || outputs.isEmpty()) {
            return;
        }
        Object mcObject = inputs.get(0);
        for (Object xmlDocNode : outputs) {
            if (mcObject instanceof StagingTable) {
                this.addStagingTableToMap(xmlDocNode, (StagingTable)mcObject);
                continue;
            }
            if (mcObject instanceof MappingClass) {
                this.xmlDocNodeToMappingClass.put(xmlDocNode, mcObject);
                continue;
            }
            if (!(mcObject instanceof MappingClassColumn)) continue;
            this.xmlDocNodeToMappingClassColumn.put(xmlDocNode, mcObject);
        }
        for (Mapping nested : mapping.getNested()) {
            this.process(nested);
        }
    }

    private void addStagingTableToMap(Object xmlDocNode, StagingTable table) {
        if (xmlDocNode == null || table == null) {
            return;
        }
        StagingTable[] tables = (StagingTable[])this.xmlDocNodeToStagingTables.get(xmlDocNode);
        if (tables == null) {
            tables = new StagingTable[]{table};
        } else {
            ArrayList<StagingTable> tmp = new ArrayList<StagingTable>();
            tmp.addAll(Arrays.asList(tables));
            tmp.add(table);
            tables = new StagingTable[tmp.size()];
            tmp.toArray(tables);
        }
        this.xmlDocNodeToStagingTables.put(xmlDocNode, tables);
    }
}

