/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.datatools.connectivity.TeiidJDBCConnection;
import org.teiid.datatools.connectivity.TeiidServerJDBCURL;
import org.teiid.datatools.connectivity.ui.Activator;
import org.teiid.datatools.connectivity.ui.Messages;
import org.teiid.datatools.connectivity.ui.TeiidProfileDetailsWizardPage;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class TeiidDriverUIContributor
implements IDriverUIContributor,
Listener {
    protected String VDB_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.VDB_LBL_UI_");
    private static final String SERVER_VERSION_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.SERVER_VERSION_LBL_UI_");
    private static final String HOST_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.HOST_LBL_UI_");
    private static final String PORT_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.PORT_LBL_UI_");
    private static final String CONNECTIONURL_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.CONNECTIONURL_LBL_UI_");
    private static final String USERNAME_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.USERNAME_LBL_UI_");
    private static final String PASSWORD_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.PASSWORD_LBL_UI_");
    private static final String URL_PROPERTIES = Messages.getString("TeiidDriverUIContributor.URL_PROPERTIES_ARG_LBL_UI_");
    private static final String SSL_BTN_UI_ = Messages.getString("TeiidDriverUIContributor.SSL_BTN_UI_");
    private static final String SAVE_PASSWORD_LBL_UI_ = Messages.getString("TeiidDriverUIContributor.SAVE_PASSWORD_LBL_UI_");
    private static final String DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.database");
    private static final String HOST_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.host");
    private static final String PORT_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.port");
    private static final String USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.username");
    private static final String URL_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.url");
    private static final String SSL_SUMMARY_DATA_TEXT_ = TextProcessor.process((String)Messages.getString("TeiidDriverUIContributor.summary.protocol"));
    private static final String SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.persistpassword.label");
    private static final String TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.true");
    private static final String FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("TeiidDriverUIContributor.summary.false");
    private Label serverVersionLabel;
    private Text serverVersionText;
    private Label databaseLabel;
    private Text databaseText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label urlPropertiesLabel;
    private Text urlPropertiesText;
    private Button protocolCheck;
    private Button savePasswordButton;
    private Label urlLabel;
    private Text urlText;
    private Text validationMessageText;
    private DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private OptionalPropertiesPane optionalPropsComposite;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private boolean isReadOnly = false;

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            GridLayoutFactory.fillDefaults().applyTo((Composite)this.parentComposite);
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem generalTab = new TabItem(tabComposite, 0);
            generalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.generaltab"));
            Composite baseComposite = new Composite((Composite)tabComposite, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).applyTo(baseComposite);
            generalTab.setControl((Control)baseComposite);
            this.validationMessageText = new Text(baseComposite, 74);
            this.validationMessageText.setBackground(parent.getBackground());
            GridDataFactory.fillDefaults().span(3, 1).align(4, 1).grab(true, false).hint(190, 20).applyTo((Control)this.validationMessageText);
            this.serverVersionLabel = new Label(baseComposite, 0);
            this.serverVersionLabel.setText(SERVER_VERSION_LBL_UI_);
            GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)this.serverVersionLabel);
            this.serverVersionText = new Text(baseComposite, 0x804 | additionalStyles);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.serverVersionText);
            this.databaseLabel = new Label(baseComposite, 0);
            this.databaseLabel.setText(this.VDB_LBL_UI_);
            GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)this.databaseLabel);
            this.databaseText = new Text(baseComposite, 0x804 | additionalStyles);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.databaseText);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(HOST_LBL_UI_);
            GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)this.hostLabel);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.hostText);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(PORT_LBL_UI_);
            GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)this.portLabel);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.portText);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(USERNAME_LBL_UI_);
            GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)this.usernameLabel);
            this.usernameText = new Text(baseComposite, 0x800 | additionalStyles);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.usernameText);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(PASSWORD_LBL_UI_);
            GridDataFactory.swtDefaults().span(1, 1).align(16384, 0x1000000).applyTo((Control)this.passwordLabel);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)this.passwordText);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(SAVE_PASSWORD_LBL_UI_);
            GridDataFactory.fillDefaults().span(1, 1).align(0x1000008, 1).applyTo((Control)this.savePasswordButton);
            this.urlPropertiesLabel = new Label(baseComposite, 0);
            this.urlPropertiesLabel.setText(URL_PROPERTIES);
            GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.urlPropertiesLabel);
            this.urlPropertiesText = new Text(baseComposite, 0x804 | additionalStyles);
            GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.urlPropertiesText);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CONNECTIONURL_LBL_UI_);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.urlLabel);
            this.protocolCheck = new Button(baseComposite, 32);
            this.protocolCheck.setText(SSL_BTN_UI_);
            this.protocolCheck.setSelection(false);
            GridDataFactory.fillDefaults().span(2, 1).align(0x1000008, 1).applyTo((Control)this.protocolCheck);
            this.urlText = new Text(baseComposite, 2634);
            GridDataFactory.fillDefaults().span(3, 1).align(4, 1).grab(true, false).hint(190, 50).applyTo((Control)this.urlText);
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = new OptionalPropertiesPane((Composite)tabComposite, 0, isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    public void setConnectionInformation() {
        String newServerText = this.serverVersionText.getText().trim();
        if (newServerText == null || newServerText.isEmpty()) {
            this.setMessage(4, Messages.getString("TeiidDriverUIContributor.serverVersionCannotBeEmpty"));
        } else {
            TeiidServerVersionValidator validator = new TeiidServerVersionValidator(newServerText);
            if (validator.getSeverity() == 0) {
                this.setMessage(0, validator.getMessage());
            } else {
                this.setMessage(validator.getSeverity(), validator.getMessage());
            }
        }
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.version", this.serverVersionText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        String url = this.urlText.getText().trim();
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", url);
        try {
            String passToken = ConnectivityUtil.generateHashToken((String[])new String[]{url, this.passwordText.getText()});
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", passToken);
            String urlStorageKey = ConnectivityUtil.buildSecureStorageKey(TeiidJDBCConnection.class, (String[])new String[]{url, passToken});
            ConnectivityUtil.getSecureStorageProvider().storeInSecureStorage(urlStorageKey, "jdbc_password", this.passwordText.getText());
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    private void setMessage(int severity, String message) {
        switch (severity) {
            case 0: {
                this.validationMessageText.setText("Click OK to save profile properties");
                this.validationMessageText.setForeground(Display.getCurrent().getSystemColor(10));
                this.serverVersionLabel.setForeground(this.serverVersionLabel.getParent().getForeground());
                break;
            }
            case 2: {
                this.validationMessageText.setText(message);
                this.validationMessageText.setForeground(Display.getCurrent().getSystemColor(8));
                break;
            }
            case 4: {
                this.validationMessageText.setText(message);
                this.validationMessageText.setForeground(Display.getCurrent().getSystemColor(3));
                this.serverVersionLabel.setForeground(Display.getCurrent().getSystemColor(3));
            }
        }
    }

    public void updateURL() {
        String url = "jdbc:teiid:" + this.databaseText.getText().trim();
        url = String.valueOf(url) + "@";
        url = this.protocolCheck.getSelection() ? String.valueOf(url) + "mms://" : String.valueOf(url) + "mm://";
        if (this.hostText.getText().trim().length() > 0) {
            url = String.valueOf(url) + this.hostText.getText().trim();
        }
        if (this.portText.getText().trim().length() > 0) {
            url = String.valueOf(url) + ":" + this.portText.getText().trim();
        }
        if (this.urlPropertiesText.getText().trim().length() > 0) {
            url = String.valueOf(url) + ";" + this.urlPropertiesText.getText().trim();
        }
        this.urlText.setText(url);
    }

    private void removeListeners() {
        this.serverVersionText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.urlPropertiesText.removeListener(24, (Listener)this);
        this.protocolCheck.removeListener(13, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
    }

    private void addListeners() {
        this.serverVersionText.addListener(24, (Listener)this);
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.urlPropertiesText.addListener(24, (Listener)this);
        this.protocolCheck.addListener(13, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            } else if (event.widget == this.protocolCheck) {
                this.protocolCheck.setSelection(!this.protocolCheck.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("TeiidDriverUIContributor.VALIDATE_DATABASE_REQ_UI_"));
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("TeiidDriverUIContributor.VALIDATE_HOST_REQ_UI_"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("TeiidDriverUIContributor.VALIDATE_USERID_REQ_MSG_UI_"));
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("TeiidDriverUIContributor.VALIDATE_PORT_REQ_MSG_UI_"));
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
        if (this.parentPage instanceof TeiidProfileDetailsWizardPage) {
            ((TeiidProfileDetailsWizardPage)this.parentPage).setDriver(this.properties.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID"));
        }
    }

    public void loadProperties() {
        this.removeListeners();
        String version = this.properties.getProperty("org.eclipse.datatools.connectivity.db.version");
        if (version != null) {
            TeiidServerVersionValidator validator = new TeiidServerVersionValidator(version);
            if (validator.containsWildcards()) {
                version = TeiidServerVersion.deriveUltimateDefaultServerVersion().toString();
            }
            this.serverVersionText.setText(version);
        }
        TeiidServerJDBCURL url = new TeiidServerJDBCURL(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        this.urlPropertiesText.setText(url.getProperties());
        this.databaseText.setText(url.getDatabaseName());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if (url.isSecureProtocol()) {
            this.protocolCheck.setSelection(true);
        } else {
            this.protocolCheck.setSelection(false);
        }
        String savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD");
        if (savePassword != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        String urlString = this.urlText.getText().trim();
        String passToken = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password");
        String urlStorageKey = ConnectivityUtil.buildSecureStorageKey(TeiidJDBCConnection.class, (String[])new String[]{urlString, passToken});
        String password = null;
        try {
            password = ConnectivityUtil.getSecureStorageProvider().getFromSecureStorage(urlStorageKey, "jdbc_password");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
        if (password != null) {
            this.passwordText.setText(password);
        }
        this.addListeners();
        this.setConnectionInformation();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{SERVER_VERSION_LBL_UI_, this.serverVersionText.getText().trim()});
        summaryData.add(new String[]{HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{SSL_SUMMARY_DATA_TEXT_, this.protocolCheck.getSelection() ? TRUE_SUMMARY_DATA_TEXT_ : FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? TRUE_SUMMARY_DATA_TEXT_ : FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{URL_PROPERTIES, this.urlPropertiesText.getText().trim()});
        summaryData.add(new String[]{URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    class TeiidServerVersionValidator {
        String versionString;
        int severity = 0;
        String message = Messages.getString("TeiidDriverUIContributor.serverVersionIsValid");

        public TeiidServerVersionValidator(String versionString) {
            this.versionString = versionString;
            this.validate();
        }

        private boolean containsWildcards() {
            TeiidServerVersion version = null;
            try {
                version = new TeiidServerVersion(this.versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return version.hasWildCards();
        }

        private void validate() {
            TeiidServerVersion version = null;
            try {
                version = new TeiidServerVersion(this.versionString);
            }
            catch (IllegalArgumentException e) {
                this.message = e.getMessage();
                return;
            }
            try {
                Integer.parseInt(version.getMajor());
            }
            catch (NumberFormatException numberFormatException) {
                this.severity = 4;
                this.message = String.valueOf(Messages.getString("TeiidDriverUIContributor.majorVersionError.message")) + version.getMajor() + Messages.getString("TeiidDriverUIContributor.isNotAnInteger.message");
                return;
            }
            try {
                Integer.parseInt(version.getMinor());
            }
            catch (NumberFormatException numberFormatException) {
                this.severity = 4;
                this.message = String.valueOf(Messages.getString("TeiidDriverUIContributor.minorVersionError.message")) + version.getMinor() + Messages.getString("TeiidDriverUIContributor.isNotAnInteger.message");
                return;
            }
            try {
                Integer.parseInt(version.getMicro());
            }
            catch (NumberFormatException numberFormatException) {
                this.severity = 4;
                this.message = String.valueOf(Messages.getString("TeiidDriverUIContributor.microVersionError.message")) + version.getMicro() + Messages.getString("TeiidDriverUIContributor.isNotAnInteger.message");
                return;
            }
        }

        public int getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

