/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.util;

import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.teiid.designer.core.util.URLHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ExtendedWSDLReader
extends WSDLReaderImpl {
    public Definition readWSDL(String wsdlURI, String userName, String password) throws WSDLException {
        return this.readWSDL(null, wsdlURI, userName, password);
    }

    public Definition readWSDL(String contextURI, String wsdlURI, String userName, String password) throws WSDLException {
        try {
            if (this.verbose) {
                System.out.println("Retrieving document at '" + wsdlURI + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
            }
            URL contextURL = contextURI != null ? StringUtils.getURL(null, (String)contextURI) : null;
            URL url = StringUtils.getURL((URL)contextURL, (String)wsdlURI);
            URLConnection urlConn = url.openConnection();
            URLHelper.setCredentials((URLConnection)urlConn, (String)userName, (String)password);
            InputStream inputStream = urlConn.getInputStream();
            InputSource inputSource = new InputSource(urlConn.getInputStream());
            inputSource.setSystemId(url.toString());
            Document doc = ExtendedWSDLReader.getDocument(inputSource, url.toString());
            inputStream.close();
            Definition def = this.readWSDL(url.toString(), doc);
            return def;
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + wsdlURI + (contextURI == null ? "'." : "', relative to '" + contextURI + "'."), (Throwable)e);
        }
    }

    private static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            return doc;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", (Throwable)e);
        }
    }
}

