/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.ws.IWSProfileConstants;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.ICredentialsCommon;

public class WSSoapConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider,
IWSProfileConstants {
    public static final String WS_CLASSNAME = "class-name";
    public static final String WS_CONNECTION_FACTORY = "org.teiid.resource.adapter.ws.WSManagedConnectionFactory";

    private void addSecurityProperties(Properties source, Properties target, boolean includeNameSpace) {
        String securityTypeId = source.getProperty("SecurityType");
        ICredentialsCommon.SecurityType securityType = ICredentialsCommon.SecurityType.retrieveValue((String)securityTypeId);
        switch (securityType) {
            case HTTPBasic: {
                String username = source.getProperty("AuthUserName");
                if (username == null) {
                    username = source.getProperty("AuthUserName");
                }
                String key = includeNameSpace ? "connection:AuthUserName" : "AuthUserName";
                target.put(key, username);
                String password = source.getProperty("AuthPassword");
                if (password == null) {
                    password = source.getProperty("AuthPassword");
                }
                key = includeNameSpace ? "connection:AuthPassword" : "AuthPassword";
                target.put(key, password);
            }
        }
        String key = includeNameSpace ? "connection:SecurityType" : "SecurityType";
        target.put(key, securityType.name());
    }

    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        String securityType;
        String wsdlURI;
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String nameInSource = modelResource.getModelAnnotation().getNameInSource();
        if (nameInSource != null) {
            connectionProps.put("connection:EndPoint", nameInSource);
        }
        if ((wsdlURI = props.getProperty("wsdlURI")) != null) {
            connectionProps.put("connection:wsdlURI", wsdlURI);
        }
        this.addSecurityProperties(props, connectionProps, true);
        String endPointURI = WSSoapConnectionInfoProvider.readEndPointProperty((Properties)props);
        if (endPointURI != null) {
            connectionProps.put("connection:EndPoint", endPointURI);
        }
        if ((securityType = props.getProperty("SecurityType")) != null) {
            connectionProps.setProperty("connection:SecurityType", securityType);
        }
        if (props.getProperty("connectionClass") != null) {
            connectionProps.put("connection:connectionClass", props.getProperty("connectionClass"));
        }
        if (props.getProperty("driverClassPath") != null) {
            connectionProps.put("connection:driverClassPath", props.getProperty("driverClassPath"));
        }
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "ws");
        if (props.getProperty("DefaultServiceMode") != null) {
            connectionProps.put("translator:DefaultServiceMode", props.getProperty("DefaultServiceMode"));
        }
        if (props.getProperty("DefaultBinding") != null) {
            connectionProps.put("translator:DefaultBinding", props.getProperty("DefaultBinding"));
        }
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    public Properties getConnectionProperties(ModelResource modelResource) throws ModelWorkspaceException {
        Properties rawTranslatorConnectionProps;
        Properties rawConnectionProps = this.removeNamespaces(this.getHelper().getProperties(modelResource, "connection:"));
        Properties connectionProps = new Properties();
        if (rawConnectionProps.get("wsdlURI") != null) {
            connectionProps.put("wsdlURI", rawConnectionProps.get("wsdlURI"));
        }
        if (rawConnectionProps.get("EndPoint") != null) {
            connectionProps.put("EndPoint", rawConnectionProps.get("EndPoint"));
        }
        if (rawConnectionProps.get("SecurityType") != null) {
            connectionProps.put("SecurityType", rawConnectionProps.get("SecurityType"));
        }
        if ((rawTranslatorConnectionProps = this.removeNamespaces(this.getHelper().getProperties(modelResource, "translator:"))).getProperty("DefaultBinding") != null) {
            connectionProps.put("DefaultBinding", rawTranslatorConnectionProps.getProperty("DefaultBinding"));
        }
        this.addSecurityProperties(rawConnectionProps, connectionProps, false);
        return connectionProps;
    }

    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        Properties connectionProps = new Properties();
        Properties profileProperties = connectionProfile.getBaseProperties();
        String endPointProperty = ConnectionInfoHelper.readEndPointProperty((Properties)profileProperties);
        if (endPointProperty != null) {
            connectionProps.put("EndPoint", endPointProperty);
        }
        this.addSecurityProperties(profileProperties, connectionProps, false);
        connectionProps.setProperty(WS_CLASSNAME, WS_CONNECTION_FACTORY);
        return connectionProps;
    }

    public String getPasswordPropertyKey() {
        return null;
    }

    public String getDataSourcePasswordPropertyKey() {
        return null;
    }

    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.WS);
    }

    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return false;
    }
}

