/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.fusesource.ide.imports.sap.Messages;

public class ImportUtils {
    private static final String VERSION_STRING_DELIMITER = "\\.";
    private static final String DROPINS_FOLDER_NAME = "dropins";
    private static final String SAP_LIBRARY_UPDATE_SITE_FOLDER_NAME = "SapLibraryUpdateSite";
    private static final String PLUGINS_FOLDER_NAME = "plugins";
    private static final String FEATURES_FOLDER_NAME = "features";
    private static final String JCO_MIN_SUPPORTED_VERSION = "3.0.11";
    private static final int JCO_MIN_SUPPORTED_MAJOR_VERSION = 3;
    private static final int JCO_MIN_SUPPORTED_MINOR_VERSION = 0;
    private static final int JCO_MIN_SUPPORTED_MICRO_VERSION = 11;
    private static final String IDOC_MIN_SUPPORTED_VERSION = "3.0.10";
    private static final int IDOC_MIN_SUPPORTED_MAJOR_VERSION = 3;
    private static final int IDOC_MIN_SUPPORTED_MINOR_VERSION = 0;
    private static final int IDOC_MIN_SUPPORTED_MICRO_VERSION = 10;
    private static final String FEATURE_BUNDLE_NAME = "com.sap.conn_3.0.0.jar";
    public static final String DEFAULT_EXECUTION_ENVIRONMENT = "JavaSE-1.6";
    private static Path temporarySapLibraryUpdateSite = null;

    public static String[] getExecutionEnvironments() {
        IExecutionEnvironment[] environments;
        ArrayList<String> result = new ArrayList<String>();
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = environments = manager.getExecutionEnvironments();
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            result.add(environment.getId());
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    public static String getExecutionEnvironment(int index) {
        String[] environments = ImportUtils.getExecutionEnvironments();
        if (index < environments.length) {
            return environments[index];
        }
        return null;
    }

    public static int getExecutionEnvironmentIndex(String executionEnvironment) {
        int result = -1;
        String[] environments = ImportUtils.getExecutionEnvironments();
        int index = 0;
        while (index < environments.length) {
            String environment = environments[index];
            if (environment.equals(executionEnvironment)) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }

    public static Path getTemporySapLibrariesRepository() {
        if (temporarySapLibraryUpdateSite == null) {
            try {
                temporarySapLibraryUpdateSite = Files.createTempDirectory(SAP_LIBRARY_UPDATE_SITE_FOLDER_NAME, new FileAttribute[0]);
                Files.createDirectory(temporarySapLibraryUpdateSite.resolve(PLUGINS_FOLDER_NAME), new FileAttribute[0]);
                Files.createDirectory(temporarySapLibraryUpdateSite.resolve(FEATURES_FOLDER_NAME), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create SAP Library Update Site", e);
            }
        }
        return temporarySapLibraryUpdateSite;
    }

    public static String getPluginsFolder() {
        return ImportUtils.getTemporySapLibrariesRepository().resolve(PLUGINS_FOLDER_NAME).toString();
    }

    public static String getFeaturesFolder() {
        return ImportUtils.getTemporySapLibrariesRepository().resolve(FEATURES_FOLDER_NAME).toString();
    }

    public static String getFeatureBundleFilename() {
        return String.valueOf(ImportUtils.getFeaturesFolder()) + File.separator + FEATURE_BUNDLE_NAME;
    }

    public static void deleteTemporarySapLibrariesRepository() {
        if (temporarySapLibraryUpdateSite == null) {
            return;
        }
        try {
            Files.walkFileTree(temporarySapLibraryUpdateSite, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete SAP Library Update Site", e);
        }
        temporarySapLibraryUpdateSite = null;
    }

    public static String getDefaultDeployLocation() {
        return String.valueOf(Platform.getInstallLocation().getURL().getFile()) + DROPINS_FOLDER_NAME;
    }

    public static void isJCoArchiveVersionSupported(String archiveVersion) throws UnsupportedVersionException {
        ImportUtils.isArchiveVersionSupported(archiveVersion, JCO_MIN_SUPPORTED_VERSION, 3, 0, 11);
    }

    public static void isIDocArchiveVersionSupported(String archiveVersion) throws UnsupportedVersionException {
        ImportUtils.isArchiveVersionSupported(archiveVersion, IDOC_MIN_SUPPORTED_VERSION, 3, 0, 10);
    }

    public static void isArchiveVersionSupported(String archiveVersion, String supportedVersion, int supportedMajorVersion, int supportedMinorVersion, int supportedMicroVersion) throws UnsupportedVersionException {
        try {
            if (archiveVersion == null) {
                throw new UnsupportedVersionException(Messages.ImportUtils_ArchiveVersionNotFound);
            }
            String[] version = archiveVersion.split(VERSION_STRING_DELIMITER);
            if (version.length >= 3) {
                int archiveMajorVersion = Integer.parseInt(version[0]);
                int archiveMinorVersion = Integer.parseInt(version[1]);
                int archiveMicroVersion = Integer.parseInt(version[2]);
                if (archiveMajorVersion > supportedMajorVersion) {
                    return;
                }
                if (archiveMajorVersion == supportedMajorVersion) {
                    if (archiveMinorVersion > supportedMinorVersion) {
                        return;
                    }
                    if (archiveMinorVersion == supportedMinorVersion && archiveMicroVersion >= supportedMicroVersion) {
                        return;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnsupportedVersionException(MessageFormat.format(Messages.ImportUtils_ArchiveVersionIsInvalid, archiveVersion));
        }
        throw new UnsupportedVersionException(MessageFormat.format(Messages.ImportUtils_ArchiveVersionIsNotSupported, archiveVersion, supportedVersion));
    }

    public static class UnsupportedVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnsupportedVersionException() {
        }

        public UnsupportedVersionException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public UnsupportedVersionException(String arg0) {
            super(arg0);
        }

        public UnsupportedVersionException(Throwable arg0) {
            super(arg0);
        }
    }
}

