/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.processing.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.SchemaModelImpl;
import org.teiid.designer.schema.tools.processing.internal.BaseRelationshipProcessor;

public class RelationshipProcessorImpl
extends BaseRelationshipProcessor {
    int c_threshold;
    int p_threshold;
    int f_threshold;
    public boolean DEBUG_SOUT_REPRESENTATIONS = true;

    public RelationshipProcessorImpl(int c_threshold, int p_threshold, int f_threshold) {
        this.c_threshold = c_threshold;
        this.p_threshold = p_threshold;
        this.f_threshold = f_threshold;
    }

    @Override
    public void calculateRelationshipTypes(SchemaModel model) {
        this.setSechemaModel(model);
        List elements = model.getElements();
        PrintWriter debugWriter = null;
        if (this.DEBUG_SOUT_REPRESENTATIONS) {
            debugWriter = this.createDebugWriter(debugWriter);
        }
        this.qualifyDuplicateNonMergedTableNames();
        for (SchemaObject element : elements) {
            int P_value = 0;
            List parents = element.getParents();
            List columns = element.getAttributes();
            Iterator pIter = parents.iterator();
            while (pIter.hasNext()) {
                SchemaObject parent = ((Relationship)pIter.next()).getParent();
                if (!parent.isWithinSelectedHierarchy()) continue;
                ++P_value;
            }
            int F_value = columns.size();
            boolean canBeRoot = element.isUseAsRoot();
            int C_value = this.calculateCValue(parents);
            int representation = this.rules.calculateRelationship(P_value, C_value, canBeRoot, F_value);
            if (representation != 3 || representation != 2) {
                element.setRepresentAsTable(true);
            }
            element.setAllParentRepresentations(representation, this);
        }
        this.removeRecursiveMerges(elements);
        if (this.DEBUG_SOUT_REPRESENTATIONS) {
            debugWriter.close();
        }
        this.mergeRelationships();
        this.removeFullyMergedTables();
        ((SchemaModelImpl)this.schemaModel).setTableRelationships(this.tableRelationships);
    }

    private PrintWriter createDebugWriter(PrintWriter debugWriter) throws RuntimeException {
        try {
            File tempFile = File.createTempFile("info", ".txt");
            debugWriter = new PrintWriter(new FileWriter(tempFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return debugWriter;
    }

    @Override
    public int C_threshold() {
        return this.c_threshold;
    }

    @Override
    public int P_threshold() {
        return this.p_threshold;
    }

    @Override
    public int F_threshold() {
        return this.f_threshold;
    }
}

