/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.schema.tools.model.jdbc.DataType;
import org.teiid.designer.schema.tools.model.jdbc.internal.DataTypeImpl;
import org.teiid.designer.schema.tools.model.schema.Column;
import org.teiid.designer.schema.tools.model.schema.QName;
import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.MergedColumn;
import org.teiid.designer.schema.tools.model.schema.impl.QNameImpl;

public abstract class BaseColumn
implements Column {
    private SchemaObject table;
    protected boolean pk;
    protected XSDSimpleTypeDefinition type;

    public BaseColumn(boolean pk, XSDSimpleTypeDefinition type) {
        this.pk = pk;
        this.type = type;
        this.table = null;
    }

    @Override
    public void setTable(SchemaObject table) {
        this.table = table;
    }

    @Override
    public SchemaObject getTable() {
        return this.table;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.pk;
    }

    @Override
    public String getBaseType() {
        XSDSimpleTypeDefinition primitiveType = this.type.getRootTypeDefinition();
        String retval = primitiveType.getName();
        return retval;
    }

    @Override
    public QName getTypeName() {
        QNameImpl retval = new QNameImpl(this.type.getTargetNamespace(), this.type.getName());
        return retval;
    }

    @Override
    public XSDSimpleTypeDefinition getType() {
        return this.type;
    }

    @Override
    public Column mergeIntoParent(Relationship tableRelationship, int iOccurence) {
        MergedColumn mergedColumn = new MergedColumn(this, tableRelationship, iOccurence);
        SchemaObject parent = tableRelationship.getParent();
        parent.addAttribute(mergedColumn);
        return mergedColumn;
    }

    public String toString() {
        return this.getSimpleName();
    }

    protected DataType getDataType() {
        String typeName = this.type.getName();
        String namespace = this.type.getTargetNamespace();
        if (typeName == null) {
            typeName = this.type.getRootType().getName();
            namespace = this.type.getRootType().getTargetNamespace();
        }
        return new DataTypeImpl(typeName, namespace);
    }
}

